/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.commands.profiler;

import cloud.commandframework.ArgumentDescription;
import cloud.commandframework.CommandManager;
import com.dfsek.terra.addons.manifest.api.AddonInitializer;
import com.dfsek.terra.api.Platform;
import com.dfsek.terra.api.addon.BaseAddon;
import com.dfsek.terra.api.command.CommandSender;
import com.dfsek.terra.api.event.events.platform.CommandRegistrationEvent;
import com.dfsek.terra.api.event.functional.FunctionalEventHandler;
import com.dfsek.terra.api.inject.annotations.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfilerCommandAddon
implements AddonInitializer {
    private static final Logger logger = LoggerFactory.getLogger(ProfilerCommandAddon.class);
    @Inject
    private Platform platform;
    @Inject
    private BaseAddon addon;

    public void initialize() {
        ((FunctionalEventHandler)this.platform.getEventManager().getHandler(FunctionalEventHandler.class)).register(this.addon, CommandRegistrationEvent.class).then(event -> {
            CommandManager manager = event.getCommandManager();
            manager.command(manager.commandBuilder("profiler", ArgumentDescription.of((String)"Access the profiler"), new String[0]).literal("start", ArgumentDescription.of((String)"Start profiling"), new String[]{"st"}).permission("terra.profiler.start").handler(context -> {
                this.platform.getProfiler().start();
                ((CommandSender)context.getSender()).sendMessage("Profiling started.");
            })).command(manager.commandBuilder("profiler", ArgumentDescription.of((String)"Access the profiler"), new String[0]).literal("stop", ArgumentDescription.of((String)"Stop profiling"), new String[]{"s"}).permission("terra.profiler.stop").handler(context -> {
                this.platform.getProfiler().stop();
                ((CommandSender)context.getSender()).sendMessage("Profiling stopped.");
            })).command(manager.commandBuilder("profiler", ArgumentDescription.of((String)"Access the profiler"), new String[0]).literal("query", ArgumentDescription.of((String)"Query profiler results"), new String[]{"q"}).permission("terra.profiler.query").handler(context -> {
                StringBuilder data = new StringBuilder("Terra Profiler data: \n");
                this.platform.getProfiler().getTimings().forEach((id, timings) -> data.append((String)id).append(": ").append(timings.toString()).append('\n'));
                logger.info(data.toString());
                ((CommandSender)context.getSender()).sendMessage("Profiling data dumped to console.");
            })).command(manager.commandBuilder("profiler", ArgumentDescription.of((String)"Access the profiler"), new String[0]).literal("reset", ArgumentDescription.of((String)"Reset the profiler"), new String[]{"r"}).permission("terra.profiler.reset").handler(context -> {
                this.platform.getProfiler().reset();
                ((CommandSender)context.getSender()).sendMessage("Profiler reset.");
            }));
        });
    }
}

