/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.elevator;

import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.movingelevators.MovingElevators;
import com.supermartijn642.movingelevators.MovingElevatorsConfig;
import com.supermartijn642.movingelevators.blocks.ControllerBlockEntity;
import com.supermartijn642.movingelevators.elevator.ClientElevatorCage;
import com.supermartijn642.movingelevators.elevator.ElevatorCage;
import com.supermartijn642.movingelevators.elevator.ElevatorCollisionHandler;
import com.supermartijn642.movingelevators.elevator.ElevatorGroupCapability;
import com.supermartijn642.movingelevators.packets.PacketSyncElevatorMovement;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1767;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3419;

public class ElevatorGroup {
    private static final int RE_SYNC_INTERVAL = 10;
    private static final double ACCELERATION = 0.05;
    public final class_1937 level;
    public final int x;
    public final int z;
    public final class_2350 facing;
    private boolean isMoving = false;
    private int targetY;
    private double lastY;
    private double currentY;
    private double syncCurrentY = 2.147483647E9;
    private double targetSpeed = 0.2;
    private double speed = 0.0;
    private int cageSideOffset = 0;
    private int cageDepthOffset = 0;
    private int cageHeightOffset = -1;
    private int cageSizeX = 3;
    private int cageSizeY = 4;
    private int cageSizeZ = 3;
    private ElevatorCage cage = null;
    private final ArrayList<Integer> floors = new ArrayList();
    private final ArrayList<FloorData> floorData = new ArrayList();
    private boolean shouldBeSynced = false;
    private final Map<Integer, Set<class_2338>> comparatorListeners = new Int2ObjectArrayMap();
    private int syncCounter = 0;

    public ElevatorGroup(class_1937 level, int x, int z, class_2350 facing) {
        this.level = level;
        this.x = x;
        this.z = z;
        this.facing = facing;
    }

    public void update() {
        if (!this.level.field_9236 && this.shouldBeSynced) {
            this.shouldBeSynced = false;
            this.updateGroup();
        }
        if (this.isMoving) {
            if (this.currentY != (double)this.targetY) {
                this.lastY = this.currentY;
            }
            if (this.speed < this.targetSpeed) {
                this.speed = Math.min(this.targetSpeed, this.speed + 0.05);
            }
            if (this.currentY == (double)this.targetY) {
                this.stopElevator();
            } else if (Math.abs((double)this.targetY - this.currentY) < this.speed) {
                this.currentY = this.targetY;
                this.moveElevator(this.lastY, this.currentY);
            } else {
                if (this.syncCurrentY != 2.147483647E9) {
                    this.currentY = this.syncCurrentY;
                    this.syncCurrentY = 2.147483647E9;
                } else {
                    this.currentY += Math.signum((double)this.targetY - this.currentY) * this.speed;
                }
                this.moveElevator(this.lastY, this.currentY);
            }
            if (this.syncCounter >= 10) {
                this.syncMovement();
                this.syncCounter = 0;
            }
            ++this.syncCounter;
        }
    }

    private void moveElevator(double oldY, double newY) {
        ElevatorCollisionHandler.handleEntityCollisions(this.level, this.cage.bounds, this.cage.collisionBoxes, this.getCageAnchorPos(oldY), new class_243((double)this.x, newY - oldY, 0.0));
    }

    private void stopElevator() {
        this.isMoving = false;
        this.cage.place(this.level, this.getCageAnchorBlockPos(this.targetY));
        this.moveElevator(this.lastY, this.currentY);
        if (!this.level.field_9236) {
            this.level.method_8455(this.getPos(this.targetY), (class_2248)MovingElevators.elevator_block);
            for (class_2338 pos : this.comparatorListeners.getOrDefault(this.targetY, Collections.emptySet())) {
                if (!this.level.method_8477(pos)) continue;
                this.level.method_8455(pos, this.level.method_8320(pos).method_26204());
            }
            this.shouldBeSynced = true;
            class_243 soundPos = this.getCageAnchorPos(this.targetY).method_1031((double)this.cageSizeX / 2.0, (double)this.cageSizeY / 2.0, (double)this.cageSizeZ / 2.0);
            this.level.method_43128(null, soundPos.field_1352, soundPos.field_1351, soundPos.field_1350, MovingElevators.arrive_sound, class_3419.field_15245, 0.4f, 0.5f);
            this.syncCounter = 0;
        }
    }

    private void startElevator(int currentY, int targetY) {
        if (this.level == null || this.isMoving) {
            return;
        }
        ElevatorCage cage = ElevatorCage.createCageAndClear(this.level, this.getCageAnchorBlockPos(currentY), this.cageSizeX, this.cageSizeY, this.cageSizeZ);
        if (cage == null) {
            return;
        }
        this.cage = cage;
        this.isMoving = true;
        this.targetY = targetY;
        this.lastY = this.currentY = (double)currentY;
        this.speed = 0.0;
        if (!this.level.field_9236) {
            this.level.method_8455(this.getPos(currentY), (class_2248)MovingElevators.elevator_block);
            for (class_2338 pos : this.comparatorListeners.getOrDefault(currentY, Collections.emptySet())) {
                if (!this.level.method_8477(pos)) continue;
                this.level.method_8455(pos, this.level.method_8320(pos).method_26204());
            }
            this.updateGroup();
        }
    }

    public void onButtonPress(boolean isUp, boolean isDown, int yLevel) {
        if (this.isMoving || !this.floors.contains(yLevel)) {
            return;
        }
        ControllerBlockEntity entity = this.getEntity(yLevel);
        if (entity == null) {
            return;
        }
        if (isUp) {
            if (this.isCageAvailableAt(entity)) {
                for (int floor = this.floors.indexOf(yLevel) + 1; floor < this.floors.size(); ++floor) {
                    ControllerBlockEntity entity2 = this.getEntity(this.floors.get(floor));
                    if (entity2 == null) continue;
                    if (this.canCageBePlacedAt(entity2)) {
                        this.startElevator(yLevel, this.floors.get(floor));
                    }
                    return;
                }
            }
        } else if (isDown) {
            if (this.isCageAvailableAt(entity)) {
                for (int floor = this.floors.indexOf(yLevel) - 1; floor >= 0; --floor) {
                    ControllerBlockEntity entity2 = this.getEntity(this.floors.get(floor));
                    if (entity2 == null) continue;
                    if (this.canCageBePlacedAt(entity2)) {
                        this.startElevator(yLevel, this.floors.get(floor));
                    }
                    return;
                }
            }
        } else if (this.canCageBePlacedAt(entity)) {
            this.floors.sort(Comparator.comparingInt(a -> Math.abs(a - yLevel)));
            for (int y : this.floors) {
                ControllerBlockEntity entity2;
                if (y == yLevel || (entity2 = this.getEntity(y)) == null || !this.isCageAvailableAt(entity2)) continue;
                this.floors.sort(Integer::compare);
                this.startElevator(y, yLevel);
                return;
            }
            this.floors.sort(Integer::compare);
        }
    }

    public void onDisplayPress(int yLevel, int floorOffset) {
        if (this.isMoving || !this.floors.contains(yLevel)) {
            return;
        }
        int floor = this.floors.indexOf(yLevel);
        if (floorOffset == 0) {
            this.onButtonPress(false, false, yLevel);
            return;
        }
        int toFloor = floor + floorOffset;
        if (toFloor < 0 || toFloor >= this.floors.size()) {
            return;
        }
        ControllerBlockEntity entity = this.getEntity(yLevel);
        int toY = this.floors.get(toFloor);
        ControllerBlockEntity toEntity = this.getEntity(toY);
        if (entity != null && toEntity != null && this.isCageAvailableAt(entity) && this.canCageBePlacedAt(toEntity)) {
            this.startElevator(yLevel, toY);
        }
    }

    public void remove(ControllerBlockEntity entity) {
        int floor = this.getFloorNumber(entity.method_11016().method_10264());
        this.floors.remove(floor);
        this.floorData.remove(floor);
        if (this.floors.isEmpty()) {
            if (this.isMoving) {
                class_243 spawnPos = this.getCageAnchorPos(this.targetY).method_1031((double)this.cageSizeX / 2.0, (double)this.cageSizeY / 2.0, (double)this.cageSizeZ / 2.0);
                this.cage.getDrops().forEach(stack -> {
                    class_1542 itemEntity = new class_1542(this.level, spawnPos.field_1352, spawnPos.field_1351, spawnPos.field_1350, stack);
                    this.level.method_8649((class_1297)itemEntity);
                });
            }
        } else {
            this.shouldBeSynced = true;
        }
    }

    public void add(ControllerBlockEntity entity) {
        if (entity == null) {
            return;
        }
        int y = entity.method_11016().method_10264();
        if (this.floors.contains(y)) {
            return;
        }
        FloorData floorData = new FloorData(entity.getFloorName(), entity.getDisplayLabelColor());
        for (int i = 0; i < this.floors.size(); ++i) {
            if (y >= this.floors.get(i)) continue;
            this.floors.add(i, y);
            this.floorData.add(i, floorData);
            break;
        }
        if (!this.floors.contains(y)) {
            this.floors.add(y);
            this.floorData.add(floorData);
        }
        this.shouldBeSynced = true;
    }

    public void updateFloorData(ControllerBlockEntity entity, String name, class_1767 color) {
        int floor = this.getFloorNumber(entity.method_11016().method_10264());
        if (floor == -1) {
            return;
        }
        FloorData data = this.floorData.get(floor);
        if (!Objects.equals(name, data.name) || color != data.color) {
            data.name = name;
            data.color = color;
            this.shouldBeSynced = true;
        }
    }

    public boolean isMoving() {
        return this.isMoving;
    }

    public double getLastY() {
        return this.lastY;
    }

    public double getCurrentY() {
        return this.currentY;
    }

    public void updateCurrentY(double y, double speed) {
        if (this.isMoving && (this.currentY < this.lastY ? y < this.currentY : y > this.currentY) && speed >= this.speed) {
            this.syncCurrentY = y;
            this.speed = speed;
        }
    }

    public ElevatorCage getCage() {
        return this.cage;
    }

    public double getTargetSpeed() {
        return this.targetSpeed;
    }

    public void setTargetSpeed(double targetSpeed) {
        this.targetSpeed = targetSpeed;
        this.shouldBeSynced = true;
    }

    public int getCageSideOffset() {
        return this.cageSideOffset;
    }

    public boolean canIncreaseCageSideOffset() {
        return !this.isMoving() && this.cageSideOffset < 2 + (this.facing == class_2350.field_11043 || this.facing == class_2350.field_11039 ? (this.getCageWidth() - 1) / 2 : (int)Math.ceil((float)(this.getCageWidth() - 1) / 2.0f));
    }

    public void increaseCageSideOffset() {
        if (this.canIncreaseCageSideOffset()) {
            ++this.cageSideOffset;
            this.shouldBeSynced = true;
        }
    }

    public boolean canDecreaseCageSideOffset() {
        return !this.isMoving() && this.cageSideOffset > -2 - (this.facing == class_2350.field_11043 || this.facing == class_2350.field_11039 ? (int)Math.ceil((float)(this.getCageWidth() - 1) / 2.0f) : (this.getCageWidth() - 1) / 2);
    }

    public void decreaseCageSideOffset() {
        if (this.canDecreaseCageSideOffset()) {
            --this.cageSideOffset;
            this.shouldBeSynced = true;
        }
    }

    public int getCageDepthOffset() {
        return this.cageDepthOffset;
    }

    public boolean canIncreaseCageDepthOffset() {
        return !this.isMoving() && this.cageDepthOffset < 2;
    }

    public void increaseCageDepthOffset() {
        if (this.canIncreaseCageDepthOffset()) {
            ++this.cageDepthOffset;
            this.shouldBeSynced = true;
        }
    }

    public boolean canDecreaseCageDepthOffset() {
        return !this.isMoving() && this.cageDepthOffset > 0;
    }

    public void decreaseCageDepthOffset() {
        if (this.canDecreaseCageDepthOffset()) {
            --this.cageDepthOffset;
            this.shouldBeSynced = true;
        }
    }

    public int getCageHeightOffset() {
        return this.cageHeightOffset;
    }

    public boolean canIncreaseCageHeightOffset() {
        return !this.isMoving() && this.cageHeightOffset < 3;
    }

    public void increaseCageHeightOffset() {
        if (this.canIncreaseCageHeightOffset()) {
            ++this.cageHeightOffset;
            this.shouldBeSynced = true;
        }
    }

    public boolean canDecreaseCageHeightOffset() {
        return !this.isMoving() && this.cageHeightOffset > -this.cageSizeY;
    }

    public void decreaseCageHeightOffset() {
        if (this.canDecreaseCageHeightOffset()) {
            --this.cageHeightOffset;
            this.shouldBeSynced = true;
        }
    }

    public int getCageWidth() {
        return this.facing.method_10166() == class_2350.class_2351.field_11048 ? this.cageSizeZ : this.cageSizeX;
    }

    public boolean canIncreaseCageWidth() {
        return !this.isMoving && this.getCageWidth() < MovingElevatorsConfig.maxCabinHorizontalSize.get();
    }

    public void increaseCageWidth() {
        if (!this.isMoving && this.canIncreaseCageWidth()) {
            if (this.facing.method_10166() == class_2350.class_2351.field_11048) {
                ++this.cageSizeZ;
            } else {
                ++this.cageSizeX;
            }
            this.shouldBeSynced = true;
        }
    }

    public boolean canDecreaseCageWidth() {
        return !this.isMoving && this.getCageWidth() > 1;
    }

    public void decreaseCageWidth() {
        if (!this.isMoving && this.canDecreaseCageWidth()) {
            if (this.facing.method_10166() == class_2350.class_2351.field_11048) {
                --this.cageSizeZ;
            } else {
                --this.cageSizeX;
            }
            if (this.cageSideOffset > 2 + (this.facing == class_2350.field_11043 || this.facing == class_2350.field_11039 ? (this.getCageWidth() - 1) / 2 : (int)Math.ceil((float)(this.getCageWidth() - 1) / 2.0f))) {
                this.cageSideOffset = 2 + (this.facing == class_2350.field_11043 || this.facing == class_2350.field_11039 ? (this.getCageWidth() - 1) / 2 : (int)Math.ceil((float)(this.getCageWidth() - 1) / 2.0f));
            } else if (this.cageSideOffset < -2 - (this.facing == class_2350.field_11043 || this.facing == class_2350.field_11039 ? (int)Math.ceil((float)(this.getCageWidth() - 1) / 2.0f) : (this.getCageWidth() - 1) / 2)) {
                this.cageSideOffset = -2 - (this.facing == class_2350.field_11043 || this.facing == class_2350.field_11039 ? (int)Math.ceil((float)(this.getCageWidth() - 1) / 2.0f) : (this.getCageWidth() - 1) / 2);
            }
            this.shouldBeSynced = true;
        }
    }

    public int getCageDepth() {
        return this.facing.method_10166() == class_2350.class_2351.field_11048 ? this.cageSizeX : this.cageSizeZ;
    }

    public boolean canIncreaseCageDepth() {
        return !this.isMoving && this.getCageDepth() < MovingElevatorsConfig.maxCabinHorizontalSize.get();
    }

    public void increaseCageDepth() {
        if (!this.isMoving && this.canIncreaseCageDepth()) {
            if (this.facing.method_10166() == class_2350.class_2351.field_11048) {
                ++this.cageSizeX;
            } else {
                ++this.cageSizeZ;
            }
            this.shouldBeSynced = true;
        }
    }

    public boolean canDecreaseCageDepth() {
        return !this.isMoving && this.getCageDepth() > 1;
    }

    public void decreaseCageDepth() {
        if (!this.isMoving && this.canDecreaseCageDepth()) {
            if (this.facing.method_10166() == class_2350.class_2351.field_11048) {
                --this.cageSizeX;
            } else {
                --this.cageSizeZ;
            }
            this.shouldBeSynced = true;
        }
    }

    public int getCageHeight() {
        return this.getCageSizeY();
    }

    public boolean canIncreaseCageHeight() {
        return !this.isMoving && this.cageSizeY < MovingElevatorsConfig.maxCabinVerticalSize.get();
    }

    public void increaseCageHeight() {
        if (!this.isMoving && this.canIncreaseCageHeight()) {
            ++this.cageSizeY;
            this.shouldBeSynced = true;
        }
    }

    public boolean canDecreaseCageHeight() {
        return !this.isMoving && this.cageSizeY > 1;
    }

    public void decreaseCageHeight() {
        if (!this.isMoving && this.canDecreaseCageHeight()) {
            --this.cageSizeY;
            if (this.cageHeightOffset < -this.cageSizeY) {
                this.cageHeightOffset = -this.cageSizeY;
            }
            this.shouldBeSynced = true;
        }
    }

    public int getCageSizeX() {
        return this.cageSizeX;
    }

    public int getCageSizeY() {
        return this.cageSizeY;
    }

    public int getCageSizeZ() {
        return this.cageSizeZ;
    }

    public class_1767 getFloorDisplayColor(int floor) {
        return this.floorData.get((int)floor).color;
    }

    public String getFloorDisplayName(int floor) {
        return this.floorData.get((int)floor).name;
    }

    public class_2338 getCageAnchorBlockPos(int y) {
        int x = 0;
        int z = 0;
        if (this.facing == class_2350.field_11043) {
            x = this.x - this.cageSizeX / 2 - this.cageSideOffset;
            z = this.z - this.cageSizeZ - this.cageDepthOffset;
        } else if (this.facing == class_2350.field_11035) {
            x = this.x - this.cageSizeX / 2 + this.cageSideOffset;
            z = this.z + 1 + this.cageDepthOffset;
        } else if (this.facing == class_2350.field_11039) {
            x = this.x - this.cageSizeX - this.cageDepthOffset;
            z = this.z - this.cageSizeZ / 2 + this.cageSideOffset;
        } else if (this.facing == class_2350.field_11034) {
            x = this.x + 1 + this.cageDepthOffset;
            z = this.z - this.cageSizeZ / 2 - this.cageSideOffset;
        }
        return new class_2338(x, y += this.cageHeightOffset, z);
    }

    public class_243 getCageAnchorPos(double y) {
        class_2338 pos = this.getCageAnchorBlockPos(0);
        return new class_243((double)pos.method_10263(), y + (double)this.cageHeightOffset, (double)pos.method_10260());
    }

    public boolean isCageAvailableAt(ControllerBlockEntity entity) {
        return ElevatorCage.canCreateCage(this.level, this.getCageAnchorBlockPos(entity.method_11016().method_10264()), this.cageSizeX, this.cageSizeY, this.cageSizeZ);
    }

    public boolean canCageBePlacedAt(ControllerBlockEntity entity) {
        class_2338 startPos = this.getCageAnchorBlockPos(entity.method_11016().method_10264());
        for (int x = 0; x < this.cageSizeX; ++x) {
            for (int y = 0; y < this.cageSizeY; ++y) {
                for (int z = 0; z < this.cageSizeZ; ++z) {
                    if (this.level.method_22347(startPos.method_10069(x, y, z))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void addComparatorListener(int floorYLevel, class_2338 blockPos) {
        this.comparatorListeners.putIfAbsent(floorYLevel, new HashSet());
        this.comparatorListeners.get(floorYLevel).add(blockPos);
    }

    public boolean removeComparatorListener(class_2338 blockPos) {
        boolean removed = false;
        Iterator<Set<class_2338>> iterator = this.comparatorListeners.values().iterator();
        while (iterator.hasNext()) {
            Set<class_2338> positions = iterator.next();
            if (!positions.remove(blockPos)) continue;
            removed = true;
            if (!positions.isEmpty()) continue;
            iterator.remove();
        }
        return removed;
    }

    public class_2487 write() {
        class_2487 compound = new class_2487();
        compound.method_10556("isMoving", this.isMoving);
        if (this.isMoving) {
            compound.method_10569("targetY", this.targetY);
            compound.method_10549("lastY", this.lastY);
            compound.method_10549("currentY", this.currentY);
            compound.method_10566("cage", (class_2520)this.cage.write());
        }
        compound.method_10549("targetSpeed", this.targetSpeed);
        compound.method_10549("speed", this.speed);
        compound.method_10569("cageSideOffset", this.cageSideOffset);
        compound.method_10569("cageDepthOffset", this.cageDepthOffset);
        compound.method_10569("cageHeightOffset", this.cageHeightOffset);
        compound.method_10569("cageSizeX", this.cageSizeX);
        compound.method_10569("cageSizeY", this.cageSizeY);
        compound.method_10569("cageSizeZ", this.cageSizeZ);
        compound.method_10572("floors", this.floors);
        class_2499 floorDataTag = new class_2499();
        for (FloorData floorDatum : this.floorData) {
            floorDataTag.add((Object)floorDatum.write());
        }
        compound.method_10566("floorData", (class_2520)floorDataTag);
        return compound;
    }

    public void read(class_2487 compound) {
        if (compound.method_10545("moving")) {
            this.isMoving = compound.method_10577("moving");
            int size = compound.method_10550("size");
            if (this.isMoving) {
                this.targetY = compound.method_10550("targetY");
                this.lastY = compound.method_10574("lastY");
                this.currentY = compound.method_10574("currentY");
                class_2680[][][] blockStates = new class_2680[size][1][size];
                class_265 shape = class_259.method_1073();
                for (int x = 0; x < size; ++x) {
                    for (int z = 0; z < size; ++z) {
                        class_2680 state = class_2248.method_9531((int)compound.method_10550("platform" + x + "," + z));
                        if (state.method_26204() == class_2246.field_10124) continue;
                        blockStates[x][0][z] = state;
                        shape = class_259.method_1082((class_265)shape, (class_265)state.method_26220((class_1922)this.level, this.getPos((int)this.currentY)), (class_247)class_247.field_1366);
                    }
                }
                shape.method_1097();
                this.cage = this.level.field_9236 ? new ClientElevatorCage(size, 1, size, blockStates, new class_2487[size][1][size], new class_2487[size][1][size], shape.method_1090()) : new ElevatorCage(size, 1, size, blockStates, new class_2487[size][1][size], new class_2487[size][1][size], shape.method_1090());
            }
            this.speed = this.targetSpeed = compound.method_10574("speed");
            this.cageSizeX = this.cageSizeZ = size;
            this.cageSizeY = 1;
        } else {
            this.isMoving = compound.method_10577("isMoving");
            if (this.isMoving) {
                this.targetY = compound.method_10550("targetY");
                this.lastY = compound.method_10574("lastY");
                this.currentY = compound.method_10574("currentY");
                this.cage = ElevatorCage.read(compound.method_10562("cage"), this.level.field_9236);
            }
            this.targetSpeed = compound.method_10574("targetSpeed");
            this.speed = compound.method_10574("speed");
            this.cageSideOffset = compound.method_10550("cageSideOffset");
            this.cageDepthOffset = compound.method_10550("cageDepthOffset");
            this.cageHeightOffset = compound.method_10550("cageHeightOffset");
            this.cageSizeX = compound.method_10550("cageSizeX");
            this.cageSizeY = compound.method_10550("cageSizeY");
            this.cageSizeZ = compound.method_10550("cageSizeZ");
        }
        this.floors.clear();
        for (int y : compound.method_10561("floors")) {
            this.floors.add(y);
        }
        this.floorData.clear();
        class_2499 floorDataTag = (class_2499)compound.method_10580("floorData");
        for (class_2520 data : floorDataTag) {
            this.floorData.add(FloorData.read((class_2487)data));
        }
    }

    private class_2338 getPos(int y) {
        return new class_2338(this.x, y, this.z);
    }

    private ControllerBlockEntity getEntity(int y) {
        if (this.level == null) {
            return null;
        }
        class_2586 entity = this.level.method_8321(this.getPos(y));
        return entity instanceof ControllerBlockEntity ? (ControllerBlockEntity)entity : null;
    }

    public int getFloorCount() {
        return this.floors.size();
    }

    public int getFloorNumber(int y) {
        return this.floors.indexOf(y);
    }

    public int getClosestFloorNumber(int y) {
        if (y < this.floors.get(0)) {
            return 0;
        }
        for (int floor = 1; floor < this.floors.size(); ++floor) {
            if (y >= (this.floors.get(floor - 1) + this.floors.get(floor)) / 2) continue;
            return floor - 1;
        }
        return this.floors.size() - 1;
    }

    public int getFloorYLevel(int floor) {
        return this.floors.get(floor);
    }

    public ControllerBlockEntity getEntityForFloor(int floor) {
        if (floor < 0 || floor >= this.floors.size()) {
            return null;
        }
        return this.getEntity(this.floors.get(floor));
    }

    public boolean hasControllerAt(int yLevel) {
        return this.floors.contains(yLevel);
    }

    private void updateGroup() {
        ElevatorGroupCapability.get(this.level).updateGroup(this);
    }

    private void syncMovement() {
        if (!this.level.field_9236) {
            MovingElevators.CHANNEL.sendToDimension(this.level.method_27983(), (BasePacket)new PacketSyncElevatorMovement(this.x, this.z, this.facing, this.currentY, this.speed));
        }
    }

    private static class FloorData {
        public String name;
        public class_1767 color;

        public FloorData(String name, class_1767 color) {
            this.name = name;
            this.color = color;
        }

        public class_2487 write() {
            class_2487 tag = new class_2487();
            if (this.name != null) {
                tag.method_10582("name", this.name);
            }
            tag.method_10569("color", this.color.method_7789());
            return tag;
        }

        public static FloorData read(class_2487 tag) {
            return new FloorData(tag.method_10545("name") ? tag.method_10558("name") : null, class_1767.method_7791((int)tag.method_10550("color")));
        }
    }
}

