/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.blocks;

import com.supermartijn642.movingelevators.MovingElevators;
import com.supermartijn642.movingelevators.blocks.ControllerBlockEntity;
import com.supermartijn642.movingelevators.blocks.ElevatorInputBlockEntity;
import com.supermartijn642.movingelevators.elevator.ElevatorCabinLevel;
import com.supermartijn642.movingelevators.elevator.ElevatorGroup;
import com.supermartijn642.movingelevators.elevator.ElevatorGroupCapability;
import net.minecraft.class_1767;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

public class RemoteControllerBlockEntity
extends ElevatorInputBlockEntity {
    private class_2350 facing = class_2350.field_11043;
    private class_2338 controllerPos = class_2338.field_10980;
    private class_2350 controllerFacing = null;
    private boolean isInCabin = false;
    private int cabinFloorIndex = -1;
    private int groupCheckCounter = 2;
    private ElevatorGroup lastGroup;

    public RemoteControllerBlockEntity(class_2338 pos, class_2680 state) {
        super(MovingElevators.button_tile, pos, state);
    }

    @Override
    public void update() {
        super.update();
        --this.groupCheckCounter;
        if (this.groupCheckCounter <= 0) {
            ElevatorGroup group;
            ControllerBlockEntity controller;
            if (this.controllerFacing == null && this.controllerPos != null && (controller = this.getController()) != null) {
                this.controllerFacing = controller.getFacing();
            }
            if ((group = this.getGroup()) != this.lastGroup) {
                this.field_11863.method_8455(this.field_11867, this.method_11010().method_26204());
                if (group != null) {
                    group.addComparatorListener(this.getFloorLevel(), this.field_11867);
                }
                this.lastGroup = group;
            }
            this.calculateInCabin();
            this.groupCheckCounter = 40;
        }
    }

    public void setValues(class_2350 facing, class_2338 controllerPos, class_2350 controllerFacing) {
        this.facing = facing;
        this.controllerPos = controllerPos;
        this.controllerFacing = controllerFacing;
        this.dataChanged();
    }

    private void calculateInCabin() {
        if (this.hasGroup()) {
            ElevatorGroup group = this.getGroup();
            for (int floor = 0; floor < group.getFloorCount(); ++floor) {
                int y = group.getFloorYLevel(floor);
                class_2338 min = group.getCageAnchorBlockPos(y);
                if (this.field_11867.method_10263() < min.method_10263() || this.field_11867.method_10263() >= min.method_10263() + group.getCageSizeX() || this.field_11867.method_10264() < min.method_10264() || this.field_11867.method_10264() >= min.method_10264() + group.getCageSizeY() || this.field_11867.method_10260() < min.method_10260() || this.field_11867.method_10260() >= min.method_10260() + group.getCageSizeZ()) continue;
                this.isInCabin = true;
                this.cabinFloorIndex = floor;
                return;
            }
        }
        this.isInCabin = false;
    }

    @Override
    protected class_2487 writeData() {
        class_2487 compound = super.writeData();
        compound.method_10569("facing", this.facing.method_10146());
        compound.method_10569("controllerX", this.controllerPos.method_10263());
        compound.method_10569("controllerY", this.controllerPos.method_10264());
        compound.method_10569("controllerZ", this.controllerPos.method_10260());
        if (this.controllerFacing != null) {
            compound.method_10569("controllerFacing", this.controllerFacing.method_10161());
        }
        this.groupCheckCounter = 2;
        return compound;
    }

    @Override
    protected void readData(class_2487 compound) {
        super.readData(compound);
        this.facing = class_2350.method_10143((int)compound.method_10550("facing"));
        this.controllerPos = new class_2338(compound.method_10550("controllerX"), compound.method_10550("controllerY"), compound.method_10550("controllerZ"));
        this.controllerFacing = compound.method_10573("controllerFacing", 3) ? class_2350.method_10139((int)compound.method_10550("controllerFacing")) : null;
        this.isInCabin = false;
    }

    @Override
    public class_2350 getFacing() {
        return this.facing;
    }

    public ControllerBlockEntity getController() {
        if (this.field_11863 == null || this.controllerPos == null) {
            return null;
        }
        class_2586 entity = this.field_11863.method_8321(this.controllerPos);
        return entity instanceof ControllerBlockEntity ? (ControllerBlockEntity)entity : null;
    }

    @Override
    public boolean hasGroup() {
        return this.getGroup() != null;
    }

    @Override
    public ElevatorGroup getGroup() {
        ElevatorGroupCapability capability;
        if (this.field_11863 == null || this.controllerPos == null || this.controllerFacing == null) {
            return null;
        }
        ElevatorGroup group = this.field_11863 instanceof ElevatorCabinLevel ? ((ElevatorCabinLevel)this.field_11863).getElevatorGroup() : ((capability = ElevatorGroupCapability.get(this.field_11863)) == null ? null : capability.get(this.controllerPos.method_10263(), this.controllerPos.method_10260(), this.controllerFacing));
        return group != null && group.hasControllerAt(this.controllerPos.method_10264()) ? group : null;
    }

    @Override
    public String getFloorName() {
        ControllerBlockEntity controller = this.getController();
        return controller == null ? null : controller.getFloorName();
    }

    @Override
    public class_1767 getDisplayLabelColor() {
        ControllerBlockEntity controller = this.getController();
        return controller == null ? null : controller.getDisplayLabelColor();
    }

    @Override
    public int getFloorLevel() {
        if (this.field_11863 instanceof ElevatorCabinLevel && this.hasGroup()) {
            ElevatorGroup group = this.getGroup();
            return group.getFloorYLevel(group.getClosestFloorNumber(this.field_11867.method_10264()));
        }
        if (this.isInCabin && this.hasGroup()) {
            ElevatorGroup group = this.getGroup();
            if (this.cabinFloorIndex >= 0 && this.cabinFloorIndex < group.getFloorCount()) {
                return group.getFloorYLevel(this.cabinFloorIndex);
            }
        }
        return this.controllerPos.method_10264();
    }

    public class_2338 getControllerPos() {
        return this.controllerPos;
    }

    public void method_11012() {
        ElevatorGroup group = this.getGroup();
        if (group != null) {
            group.removeComparatorListener(this.field_11867);
        }
        super.method_11012();
    }
}

