/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.blocks;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.movingelevators.blocks.CamoBlock;
import com.supermartijn642.movingelevators.blocks.CamoBlockEntity;
import com.supermartijn642.movingelevators.blocks.ControllerBlockEntity;
import com.supermartijn642.movingelevators.blocks.DisplayBlockEntity;
import com.supermartijn642.movingelevators.blocks.ElevatorInputBlockEntity;
import com.supermartijn642.movingelevators.elevator.ElevatorGroup;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class DisplayBlock
extends CamoBlock {
    public static final int BUTTON_COUNT = 3;
    public static final int BUTTON_COUNT_BIG = 7;
    public static final float BUTTON_HEIGHT = 0.125f;

    public DisplayBlock(BlockProperties properties) {
        super(properties, DisplayBlockEntity::new);
    }

    @Override
    protected boolean onRightClick(class_2680 state, class_1937 level, CamoBlockEntity blockEntity, class_2338 pos, class_1657 player, class_1268 hand, class_2350 hitSide, class_243 hitLocation) {
        DisplayBlockEntity displayEntity;
        if (blockEntity instanceof DisplayBlockEntity && (displayEntity = (DisplayBlockEntity)blockEntity).getFacing() == hitSide) {
            if (!level.field_9236) {
                int displayCat = displayEntity.getDisplayCategory();
                class_243 hitVec = hitLocation.method_1023((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
                double hitHorizontal = hitSide.method_10166() == class_2350.class_2351.field_11051 ? hitVec.field_1352 : hitVec.field_1350;
                double hitY = hitVec.field_1351;
                if (hitHorizontal > 0.0625 && hitHorizontal < 0.9375) {
                    class_2586 blockEntity2;
                    class_2338 inputEntityPos = null;
                    int button_count = -1;
                    int height = -1;
                    if (displayCat == 1) {
                        if (hitY > 0.0625 && hitY < 0.9375) {
                            inputEntityPos = pos.method_10074();
                            button_count = 3;
                            height = 1;
                        }
                    } else if (displayCat == 2) {
                        if (hitY > 0.0625) {
                            inputEntityPos = pos.method_10074();
                            button_count = 7;
                            height = 2;
                        }
                    } else if (displayCat == 3 && hitY < 0.9375) {
                        inputEntityPos = pos.method_10087(2);
                        button_count = 7;
                        height = 2;
                        hitY += 1.0;
                    }
                    if (inputEntityPos != null && (blockEntity2 = level.method_8321(inputEntityPos)) instanceof ElevatorInputBlockEntity && ((ElevatorInputBlockEntity)blockEntity2).hasGroup()) {
                        int above;
                        ElevatorInputBlockEntity inputEntity = (ElevatorInputBlockEntity)blockEntity2;
                        ElevatorGroup group = inputEntity.getGroup();
                        int index = inputEntity.getGroup().getFloorNumber(inputEntity.getFloorLevel());
                        int below = index;
                        if (below < (above = group.getFloorCount() - index - 1)) {
                            below = Math.min(below, button_count);
                            above = Math.min(above, button_count * 2 - below);
                        } else {
                            above = Math.min(above, button_count);
                            below = Math.min(below, button_count * 2 - above);
                        }
                        int startIndex = index - below;
                        int total = below + 1 + above;
                        int floorOffset = (int)Math.floor((hitY - (double)((float)height - (float)total * 0.125f) / 2.0) / 0.125) + startIndex - index;
                        if (player == null || player.method_5998(hand).method_7960() || !(player.method_5998(hand).method_7909() instanceof class_1769)) {
                            inputEntity.getGroup().onDisplayPress(inputEntity.getFloorLevel(), floorOffset);
                        } else {
                            class_1767 color = ((class_1769)player.method_5998(hand).method_7909()).method_7802();
                            int floor = group.getFloorNumber(inputEntity.getFloorLevel()) + floorOffset;
                            ControllerBlockEntity elevatorEntity = group.getEntityForFloor(floor);
                            if (elevatorEntity != null) {
                                elevatorEntity.setDisplayLabelColor(color);
                            }
                        }
                    }
                }
            }
            return true;
        }
        return super.onRightClick(state, level, blockEntity, pos, player, hand, hitSide, hitLocation);
    }

    protected void appendItemInformation(class_1799 stack, @Nullable class_1922 level, Consumer<class_2561> info, boolean advanced) {
        info.accept((class_2561)TextComponents.translation((String)"movingelevators.elevator_display.tooltip").color(class_124.field_1075).get());
    }
}

