/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.options;

import java.util.function.DoubleConsumer;
import java.util.function.LongConsumer;
import java.util.regex.Pattern;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_5244;

public class NumberInputBox
extends class_342 {
    private static final Pattern INTEGER_PATTERN = Pattern.compile("-?\\d*");
    private static final Pattern FLOAT_PATTERN = Pattern.compile("-?\\d*(.\\d*)?");

    public NumberInputBox(class_327 font, int x, int y, int width, int height, String value, boolean floating, LongConsumer longConsumer, DoubleConsumer doubleConsumer) {
        super(font, x, y, width, height, class_5244.field_39003);
        if (floating) {
            this.method_1890(text -> FLOAT_PATTERN.matcher((CharSequence)text).matches());
        } else {
            this.method_1890(text -> INTEGER_PATTERN.matcher((CharSequence)text).matches());
        }
        this.method_1852(value);
        this.method_1863(text -> {
            if (text.isEmpty()) {
                text = "0";
            }
            if (floating) {
                try {
                    doubleConsumer.accept(Double.parseDouble(text));
                }
                catch (NumberFormatException e) {
                    doubleConsumer.accept(0.0);
                }
            } else {
                try {
                    longConsumer.accept(Long.parseLong(text));
                }
                catch (NumberFormatException e) {
                    longConsumer.accept(0L);
                }
            }
        });
    }
}

