/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.nyfsspiders.common.entity.movement;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_11;
import net.minecraft.class_13;
import net.minecraft.class_1308;
import net.minecraft.class_1950;
import net.minecraft.class_2338;
import net.minecraft.class_4459;
import net.minecraft.class_5;
import net.minecraft.class_8;
import net.minecraft.class_9;
import org.jetbrains.annotations.Nullable;

public class CustomPathFinder
extends class_13 {
    private final class_5 path = new class_5();
    private final class_9[] pathOptions = new class_9[32];
    private final class_8 nodeProcessor;
    private int maxExpansions = 200;
    public static final Heuristic DEFAULT_HEURISTIC = (start, end, isTargetHeuristic) -> start.method_21653(end);
    private Heuristic heuristic = DEFAULT_HEURISTIC;

    public CustomPathFinder(class_8 processor, int maxExpansions) {
        super(processor, maxExpansions);
        this.nodeProcessor = processor;
        this.maxExpansions = maxExpansions;
    }

    public class_8 getNodeProcessor() {
        return this.nodeProcessor;
    }

    public CustomPathFinder setMaxExpansions(int expansions) {
        this.maxExpansions = expansions;
        return this;
    }

    public CustomPathFinder setHeuristic(Heuristic heuristic) {
        this.heuristic = heuristic;
        return this;
    }

    @Nullable
    public class_11 method_52(class_1950 region, class_1308 entity, Set<class_2338> checkpoints, float maxDistance, int checkpointRange, float maxExpansionsMultiplier) {
        this.path.method_5();
        this.nodeProcessor.method_12(region, entity);
        class_9 pathpoint = this.nodeProcessor.method_21();
        Map<class_4459, class_2338> checkpointsMap = checkpoints.stream().collect(Collectors.toMap(pos -> this.nodeProcessor.method_16((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()), Function.identity()));
        class_11 path = this.findPath(pathpoint, checkpointsMap, maxDistance, checkpointRange, maxExpansionsMultiplier);
        this.nodeProcessor.method_19();
        return path;
    }

    @Nullable
    private class_11 findPath(class_9 start, Map<class_4459, class_2338> checkpointsMap, float maxDistance, int checkpointRange, float maxExpansionsMultiplier) {
        Set<class_4459> checkpoints = checkpointsMap.keySet();
        start.field_36 = 0.0f;
        start.field_47 = start.field_34 = this.computeHeuristic(start, checkpoints);
        this.path.method_5();
        this.path.method_2(start);
        HashSet reachedCheckpoints = Sets.newHashSetWithExpectedSize((int)checkpoints.size());
        int expansions = 0;
        int maxExpansions = (int)((float)this.maxExpansions * maxExpansionsMultiplier);
        while (!this.path.method_8() && ++expansions < maxExpansions) {
            class_9 openPathPoint = this.path.method_6();
            openPathPoint.field_42 = true;
            for (class_4459 checkpoint2 : checkpoints) {
                if (!(openPathPoint.method_21653((class_9)checkpoint2) <= (float)checkpointRange)) continue;
                checkpoint2.method_21665();
                reachedCheckpoints.add(checkpoint2);
            }
            if (!reachedCheckpoints.isEmpty()) break;
            if (!(openPathPoint.method_31(start) < maxDistance)) continue;
            int numOptions = this.nodeProcessor.method_18(this.pathOptions, openPathPoint);
            for (int i = 0; i < numOptions; ++i) {
                class_9 successorPathPoint = this.pathOptions[i];
                float costHeuristic = openPathPoint.method_31(successorPathPoint);
                successorPathPoint.field_46 = openPathPoint.field_46 + costHeuristic;
                float totalSuccessorPathCost = openPathPoint.field_36 + costHeuristic + successorPathPoint.field_43;
                if (!(successorPathPoint.field_46 < maxDistance) || successorPathPoint.method_27() && !(totalSuccessorPathCost < successorPathPoint.field_36)) continue;
                successorPathPoint.field_35 = openPathPoint;
                successorPathPoint.field_36 = totalSuccessorPathCost;
                successorPathPoint.field_34 = this.computeHeuristic(successorPathPoint, checkpoints) * 1.0f;
                if (successorPathPoint.method_27()) {
                    this.path.method_3(successorPathPoint, successorPathPoint.field_36 + successorPathPoint.field_34);
                    continue;
                }
                successorPathPoint.field_47 = successorPathPoint.field_36 + successorPathPoint.field_34;
                this.path.method_2(successorPathPoint);
            }
        }
        Optional<class_11> path = !reachedCheckpoints.isEmpty() ? reachedCheckpoints.stream().map(checkpoint -> this.createPath(checkpoint.method_21664(), (class_2338)checkpointsMap.get(checkpoint), true)).min(Comparator.comparingInt(class_11::method_38)) : checkpoints.stream().map(checkpoint -> this.createPath(checkpoint.method_21664(), (class_2338)checkpointsMap.get(checkpoint), false)).min(Comparator.comparingDouble(class_11::method_21656).thenComparingInt(class_11::method_38));
        return !path.isPresent() ? null : path.get();
    }

    private float computeHeuristic(class_9 pathPoint, Set<class_4459> checkpoints) {
        float minDst = Float.MAX_VALUE;
        for (class_4459 checkpoint : checkpoints) {
            float dst = pathPoint.method_31((class_9)checkpoint);
            checkpoint.method_21662(dst, pathPoint);
            minDst = Math.min(dst, minDst);
        }
        return minDst;
    }

    protected class_11 createPath(class_9 start, class_2338 target, boolean isTargetReached) {
        ArrayList points = Lists.newArrayList();
        class_9 currentPathPoint = start;
        points.add(0, start);
        while (currentPathPoint.field_35 != null) {
            currentPathPoint = currentPathPoint.field_35;
            points.add(0, currentPathPoint);
        }
        return new class_11((List)points, target, isTargetReached);
    }

    public static interface Heuristic {
        public float compute(class_9 var1, class_9 var2, boolean var3);
    }
}

