/*
 * Decompiled with CFR 0.152.
 */
package net.enderitemc.enderitemod.tools;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.enderitemc.enderitemod.EnderiteMod;
import net.enderitemc.enderitemod.materials.EnderiteMaterial;
import net.enderitemc.enderitemod.misc.EnderiteCrossbowUser;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1671;
import net.minecraft.class_1676;
import net.minecraft.class_174;
import net.minecraft.class_1744;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_5819;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class EnderiteCrossbow
extends class_1764 {
    private boolean charged = false;
    private boolean loaded = false;

    public EnderiteCrossbow(class_1792.class_1793 settings) {
        super(settings);
    }

    public Predicate<class_1799> method_20310() {
        return field_18282;
    }

    public Predicate<class_1799> method_19268() {
        return field_18281;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        if (EnderiteCrossbow.isCharged(itemStack)) {
            EnderiteCrossbow.shootAll(world, (class_1309)user, hand, itemStack, EnderiteCrossbow.getSpeed(itemStack), 1.0f);
            EnderiteCrossbow.setCharged(itemStack, false);
            return class_1271.method_22428((Object)itemStack);
        }
        if (!user.method_18808(itemStack).method_7960()) {
            if (!EnderiteCrossbow.isCharged(itemStack)) {
                this.charged = false;
                this.loaded = false;
                user.method_6019(hand);
            }
            return class_1271.method_22428((Object)itemStack);
        }
        return class_1271.method_22431((Object)itemStack);
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        int i = this.method_7881(stack) - remainingUseTicks;
        float f = EnderiteCrossbow.getPullProgress(i, stack);
        if (f >= 1.0f && !EnderiteCrossbow.isCharged(stack) && EnderiteCrossbow.loadProjectiles(user, stack)) {
            EnderiteCrossbow.setCharged(stack, true);
            class_3419 soundCategory = user instanceof class_1657 ? class_3419.field_15248 : class_3419.field_15251;
            world.method_43128((class_1657)null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_14626, soundCategory, 1.0f, 1.0f / (world.method_8409().method_43057() * 0.5f + 1.0f) + 0.2f);
        }
    }

    private static boolean loadProjectiles(class_1309 shooter, class_1799 projectile) {
        int i = class_1890.method_8225((class_1887)class_1893.field_9108, (class_1799)projectile);
        int j = i == 0 ? 1 : 3;
        boolean bl = shooter instanceof class_1657 && ((class_1657)shooter).method_31549().field_7477;
        class_1799 itemStack = shooter.method_18808(projectile);
        class_1799 itemStack2 = itemStack.method_7972();
        for (int k = 0; k < j; ++k) {
            if (k > 0) {
                itemStack = itemStack2.method_7972();
            }
            if (itemStack.method_7960() && bl) {
                itemStack = new class_1799((class_1935)class_1802.field_8107);
                itemStack2 = itemStack.method_7972();
            }
            if (EnderiteCrossbow.loadProjectile(shooter, projectile, itemStack, k > 0, bl)) continue;
            return false;
        }
        return true;
    }

    private static boolean loadProjectile(class_1309 shooter, class_1799 crossbow, class_1799 projectile, boolean simulated, boolean creative) {
        class_1799 itemStack2;
        boolean bl;
        if (projectile.method_7960()) {
            return false;
        }
        boolean bl2 = bl = creative && projectile.method_7909() instanceof class_1744;
        if (!(bl || creative || simulated)) {
            itemStack2 = projectile.method_7971(1);
            if (projectile.method_7960() && shooter instanceof class_1657) {
                ((class_1657)shooter).method_31548().method_7378(projectile);
            }
        } else {
            itemStack2 = projectile.method_7972();
        }
        EnderiteCrossbow.putProjectile(crossbow, itemStack2);
        return true;
    }

    public static boolean isCharged(class_1799 stack) {
        class_2487 compoundTag = stack.method_7969();
        return compoundTag != null && compoundTag.method_10577("Charged");
    }

    public static void setCharged(class_1799 stack, boolean charged) {
        class_2487 compoundTag = stack.method_7948();
        compoundTag.method_10556("Charged", charged);
    }

    private static void putProjectile(class_1799 crossbow, class_1799 projectile) {
        class_2487 compoundTag = crossbow.method_7948();
        class_2499 listTag2 = compoundTag.method_10573("ChargedProjectiles", 9) ? compoundTag.method_10554("ChargedProjectiles", 10) : new class_2499();
        class_2487 compoundTag2 = new class_2487();
        projectile.method_7953(compoundTag2);
        listTag2.add((Object)compoundTag2);
        compoundTag.method_10566("ChargedProjectiles", (class_2520)listTag2);
    }

    private static List<class_1799> getProjectiles(class_1799 crossbow) {
        class_2499 listTag;
        ArrayList list = Lists.newArrayList();
        class_2487 compoundTag = crossbow.method_7969();
        if (compoundTag != null && compoundTag.method_10573("ChargedProjectiles", 9) && (listTag = compoundTag.method_10554("ChargedProjectiles", 10)) != null) {
            for (int i = 0; i < listTag.size(); ++i) {
                class_2487 compoundTag2 = listTag.method_10602(i);
                list.add(class_1799.method_7915((class_2487)compoundTag2));
            }
        }
        return list;
    }

    private static void clearProjectiles(class_1799 crossbow) {
        class_2487 compoundTag = crossbow.method_7969();
        if (compoundTag != null) {
            class_2499 listTag = compoundTag.method_10554("ChargedProjectiles", 9);
            listTag.clear();
            compoundTag.method_10566("ChargedProjectiles", (class_2520)listTag);
        }
    }

    public static boolean hasProjectile(class_1799 crossbow, class_1792 projectile) {
        return EnderiteCrossbow.getProjectiles(crossbow).stream().anyMatch(s -> s.method_7909() == projectile);
    }

    private static void shoot(class_1937 world, class_1309 shooter, class_1268 hand, class_1799 crossbow, class_1799 projectile, float soundPitch, boolean creative, float speed, float divergence, float simulated) {
        if (!world.field_9236) {
            class_1665 projectileEntity2;
            boolean bl;
            boolean bl2 = bl = projectile.method_7909() == class_1802.field_8639;
            if (bl) {
                projectileEntity2 = new class_1671(world, projectile, (class_1297)shooter, shooter.method_23317(), shooter.method_23320() - (double)0.15f, shooter.method_23321(), true);
            } else {
                projectileEntity2 = EnderiteCrossbow.createArrow(world, shooter, crossbow, projectile);
                if (creative || simulated != 0.0f) {
                    projectileEntity2.field_7572 = class_1665.class_1666.field_7594;
                }
            }
            if (shooter instanceof EnderiteCrossbowUser) {
                EnderiteCrossbowUser crossbowUser = (EnderiteCrossbowUser)shooter;
                crossbowUser.method_18811(crossbowUser.method_5968(), crossbow, (class_1676)projectileEntity2, simulated);
            } else {
                class_243 vec3d = shooter.method_18864(1.0f);
                Quaternionf quaternion = new Quaternionf().setAngleAxis((double)(simulated * ((float)Math.PI / 180)), vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);
                class_243 vec3d2 = shooter.method_5828(1.0f);
                Vector3f vector3f = vec3d2.method_46409();
                vector3f.rotate((Quaternionfc)quaternion);
                ((class_1676)projectileEntity2).method_7485((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), speed, divergence);
            }
            crossbow.method_7956(bl ? 3 : 1, shooter, e -> e.method_20236(hand));
            world.method_8649((class_1297)projectileEntity2);
            world.method_43128((class_1657)null, shooter.method_23317(), shooter.method_23318(), shooter.method_23321(), class_3417.field_15187, class_3419.field_15248, 1.0f, soundPitch);
        }
    }

    private static class_1665 createArrow(class_1937 world, class_1309 entity, class_1799 crossbow, class_1799 arrow) {
        class_1744 arrowItem = (class_1744)(arrow.method_7909() instanceof class_1744 ? arrow.method_7909() : class_1802.field_8107);
        class_1665 persistentProjectileEntity = arrowItem.method_7702(world, arrow, entity);
        persistentProjectileEntity.method_5665((class_2561)class_2561.method_43470((String)"Enderite Arrow"));
        if (entity instanceof class_1657) {
            persistentProjectileEntity.method_7439(true);
        }
        persistentProjectileEntity.method_7438((double)EnderiteMod.CONFIG.tools.enderiteCrossbowAD);
        persistentProjectileEntity.method_7444(class_3417.field_14636);
        persistentProjectileEntity.method_7442(true);
        int i = class_1890.method_8225((class_1887)class_1893.field_9132, (class_1799)crossbow);
        if (i > 0) {
            persistentProjectileEntity.method_7451((byte)i);
        }
        return persistentProjectileEntity;
    }

    public static void shootAll(class_1937 world, class_1309 entity, class_1268 hand, class_1799 stack, float speed, float divergence) {
        List<class_1799> list = EnderiteCrossbow.getProjectiles(stack);
        float[] fs = EnderiteCrossbow.getSoundPitches(entity.method_6051());
        for (int i = 0; i < list.size(); ++i) {
            boolean bl;
            class_1799 itemStack = list.get(i);
            boolean bl2 = bl = entity instanceof class_1657 && ((class_1657)entity).method_31549().field_7477;
            if (itemStack.method_7960()) continue;
            if (i == 0) {
                EnderiteCrossbow.shoot(world, entity, hand, stack, itemStack, fs[i], bl, speed, divergence, 0.0f);
                continue;
            }
            if (i == 1) {
                EnderiteCrossbow.shoot(world, entity, hand, stack, itemStack, fs[i], bl, speed, divergence, -10.0f);
                continue;
            }
            if (i != 2) continue;
            EnderiteCrossbow.shoot(world, entity, hand, stack, itemStack, fs[i], bl, speed, divergence, 10.0f);
        }
        EnderiteCrossbow.postShoot(world, entity, stack);
    }

    private static float[] getSoundPitches(class_5819 random) {
        boolean bl = random.method_43056();
        return new float[]{1.0f, EnderiteCrossbow.getSoundPitch(bl, random), EnderiteCrossbow.getSoundPitch(!bl, random)};
    }

    private static float getSoundPitch(boolean flag, class_5819 random) {
        float f = flag ? 0.63f : 0.43f;
        return 1.0f / (random.method_43057() * 0.5f + 1.8f) + f;
    }

    private static void postShoot(class_1937 world, class_1309 entity, class_1799 stack) {
        if (entity instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)entity;
            if (!world.field_9236) {
                class_174.field_1196.method_9115(serverPlayerEntity, stack);
            }
            serverPlayerEntity.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
        }
        EnderiteCrossbow.clearProjectiles(stack);
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        if (!world.field_9236) {
            int i = class_1890.method_8225((class_1887)class_1893.field_9098, (class_1799)stack);
            class_3414 soundEvent = this.getQuickChargeSound(i);
            class_3414 soundEvent2 = i == 0 ? class_3417.field_14860 : null;
            float f = (float)(stack.method_7935() - remainingUseTicks) / (float)EnderiteCrossbow.getPullTime(stack);
            if (f < 0.2f) {
                this.charged = false;
                this.loaded = false;
            }
            if (f >= 0.2f && !this.charged) {
                this.charged = true;
                world.method_43128((class_1657)null, user.method_23317(), user.method_23318(), user.method_23321(), soundEvent, class_3419.field_15248, 0.5f, 1.0f);
            }
            if (f >= 0.5f && soundEvent2 != null && !this.loaded) {
                this.loaded = true;
                world.method_43128((class_1657)null, user.method_23317(), user.method_23318(), user.method_23321(), soundEvent2, class_3419.field_15248, 0.5f, 1.0f);
            }
        }
    }

    public int method_7881(class_1799 stack) {
        return EnderiteCrossbow.getPullTime(stack) + 30;
    }

    public static int getPullTime(class_1799 stack) {
        int i = class_1890.method_8225((class_1887)class_1893.field_9098, (class_1799)stack);
        return i == 0 ? 35 : 35 - 5 * i;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8947;
    }

    private class_3414 getQuickChargeSound(int stage) {
        switch (stage) {
            case 1: {
                return class_3417.field_15011;
            }
            case 2: {
                return class_3417.field_14916;
            }
            case 3: {
                return class_3417.field_15089;
            }
        }
        return class_3417.field_14765;
    }

    private static float getPullProgress(int useTicks, class_1799 stack) {
        float f = (float)useTicks / (float)EnderiteCrossbow.getPullTime(stack);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 context) {
        List<class_1799> list = EnderiteCrossbow.getProjectiles(stack);
        if (EnderiteCrossbow.isCharged(stack) && !list.isEmpty()) {
            class_1799 itemStack = list.get(0);
            tooltip.add((class_2561)class_2561.method_43471((String)"item.minecraft.crossbow.projectile").method_27693(" ").method_10852(itemStack.method_7954()));
            if (context.method_8035() && itemStack.method_7909() == class_1802.field_8639) {
                ArrayList list2 = Lists.newArrayList();
                class_1802.field_8639.method_7851(itemStack, world, (List)list2, context);
                if (!list2.isEmpty()) {
                    for (int i = 0; i < list2.size(); ++i) {
                        list2.set(i, class_2561.method_43470((String)"  ").method_10852((class_2561)list2.get(i)).method_27692(class_124.field_1080));
                    }
                    tooltip.addAll(list2);
                }
            }
        }
    }

    private static float getSpeed(class_1799 stack) {
        return stack.method_31574((class_1792)EnderiteMod.ENDERITE_CROSSBOW.get()) && EnderiteCrossbow.hasProjectile(stack, class_1802.field_8639) ? 2.1f : EnderiteMod.CONFIG.tools.enderiteCrossbowArrowSpeed;
    }

    public int method_24792() {
        return 8;
    }

    public int method_7837() {
        return EnderiteMaterial.ENDERITE.method_8026();
    }

    public boolean method_7878(class_1799 stack, class_1799 ingredient) {
        return EnderiteMaterial.ENDERITE.method_8023().method_8093(ingredient);
    }
}

