/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.forge.forge.addons.create;

import com.fizzware.dramaticdoors.forge.blocks.TallCreateSlidingDoorBlock;
import com.fizzware.dramaticdoors.forge.forge.addons.create.TallForgeCreateSlidingDoorBlockEntity;
import com.fizzware.dramaticdoors.forge.forge.compat.CreateForgeCompat;
import com.fizzware.dramaticdoors.forge.state.properties.DDBlockStateProperties;
import com.fizzware.dramaticdoors.forge.state.properties.TripleBlockPart;
import com.simibubi.create.content.contraptions.ContraptionWorld;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TallForgeCreateSlidingDoorBlock
extends TallCreateSlidingDoorBlock
implements IWrenchable,
IBE<TallForgeCreateSlidingDoorBlockEntity> {
    protected static final VoxelShape SE_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)-13.0, (double)3.0, (double)16.0, (double)3.0);
    protected static final VoxelShape ES_AABB = Block.m_49796_((double)-13.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NW_AABB = Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)29.0);
    protected static final VoxelShape WN_AABB = Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)29.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SW_AABB = Block.m_49796_((double)13.0, (double)0.0, (double)-13.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape WS_AABB = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)29.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NE_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)16.0, (double)29.0);
    protected static final VoxelShape EN_AABB = Block.m_49796_((double)-13.0, (double)0.0, (double)13.0, (double)3.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SE_AABB_FOLD = Block.m_49796_((double)0.0, (double)0.0, (double)-3.0, (double)9.0, (double)16.0, (double)3.0);
    protected static final VoxelShape ES_AABB_FOLD = Block.m_49796_((double)-3.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)9.0);
    protected static final VoxelShape NW_AABB_FOLD = Block.m_49796_((double)7.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)19.0);
    protected static final VoxelShape WN_AABB_FOLD = Block.m_49796_((double)13.0, (double)0.0, (double)7.0, (double)19.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SW_AABB_FOLD = Block.m_49796_((double)7.0, (double)0.0, (double)-3.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape WS_AABB_FOLD = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)19.0, (double)16.0, (double)9.0);
    protected static final VoxelShape NE_AABB_FOLD = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)9.0, (double)16.0, (double)19.0);
    protected static final VoxelShape EN_AABB_FOLD = Block.m_49796_((double)-3.0, (double)0.0, (double)7.0, (double)3.0, (double)16.0, (double)16.0);
    public static final BooleanProperty VISIBLE = DDBlockStateProperties.VISIBLE;

    public TallForgeCreateSlidingDoorBlock(Block from, BlockSetType blockset, boolean isFolding) {
        super(from, blockset, isFolding);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        if (state.m_61143_((Property)THIRD) == TripleBlockPart.LOWER) {
            return new TallForgeCreateSlidingDoorBlockEntity(pos, state);
        }
        return null;
    }

    @Override
    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (!((Boolean)pState.m_61143_((Property)OPEN)).booleanValue() && (((Boolean)pState.m_61143_((Property)VISIBLE)).booleanValue() || pLevel instanceof ContraptionWorld)) {
            return super.m_5940_(pState, pLevel, pPos, pContext);
        }
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        boolean hinge = pState.m_61143_((Property)HINGE) == DoorHingeSide.RIGHT;
        return TallForgeCreateSlidingDoorBlock.getShapeByProperty(direction, hinge, this.isFoldingDoor());
    }

    public static VoxelShape getShapeByProperty(Direction facing, boolean hinge, boolean fold) {
        if (fold) {
            return switch (facing) {
                case Direction.SOUTH -> {
                    if (hinge) {
                        yield ES_AABB_FOLD;
                    }
                    yield WS_AABB_FOLD;
                }
                case Direction.WEST -> {
                    if (hinge) {
                        yield SW_AABB_FOLD;
                    }
                    yield NW_AABB_FOLD;
                }
                case Direction.NORTH -> {
                    if (hinge) {
                        yield WN_AABB_FOLD;
                    }
                    yield EN_AABB_FOLD;
                }
                default -> hinge ? NE_AABB_FOLD : SE_AABB_FOLD;
            };
        }
        return switch (facing) {
            case Direction.SOUTH -> {
                if (hinge) {
                    yield ES_AABB;
                }
                yield WS_AABB;
            }
            case Direction.WEST -> {
                if (hinge) {
                    yield SW_AABB;
                }
                yield NW_AABB;
            }
            case Direction.NORTH -> {
                if (hinge) {
                    yield WN_AABB;
                }
                yield EN_AABB;
            }
            default -> hinge ? NE_AABB : SE_AABB;
        };
    }

    @Override
    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean lower = state.m_61143_((Property)THIRD) == TripleBlockPart.LOWER;
        boolean isPowered = TallForgeCreateSlidingDoorBlock.isDoorPowered(level, pos, state);
        if (this.m_49966_().m_60713_(blockIn)) {
            return;
        }
        if (isPowered == (Boolean)state.m_61143_((Property)POWERED)) {
            return;
        }
        TallForgeCreateSlidingDoorBlockEntity be = (TallForgeCreateSlidingDoorBlockEntity)this.getBlockEntity((BlockGetter)level, lower ? pos : pos.m_7495_());
        if (be != null && be.deferUpdate) {
            return;
        }
        BlockState changedState = (BlockState)((BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(isPowered))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(isPowered));
        if (isPowered) {
            changedState = (BlockState)changedState.m_61124_((Property)VISIBLE, (Comparable)Boolean.valueOf(false));
        }
        if (isPowered != (Boolean)state.m_61143_((Property)OPEN)) {
            this.playSound(null, level, pos, isPowered);
            level.m_142346_(null, isPowered ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
            DoorHingeSide hinge = (DoorHingeSide)changedState.m_61143_((Property)HINGE);
            Direction facing = (Direction)changedState.m_61143_((Property)FACING);
            BlockPos otherPos = pos.m_121945_(hinge == DoorHingeSide.LEFT ? facing.m_122427_() : facing.m_122428_());
            BlockState otherDoor = level.m_8055_(otherPos);
            if (TallForgeCreateSlidingDoorBlock.isDoubleDoor(changedState, hinge, facing, otherDoor)) {
                otherDoor = (BlockState)((BlockState)otherDoor.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(isPowered))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(isPowered));
                if (isPowered) {
                    otherDoor = (BlockState)otherDoor.m_61124_((Property)VISIBLE, (Comparable)Boolean.valueOf(false));
                }
                level.m_7731_(otherPos, otherDoor, 2);
            }
        }
        level.m_7731_(pos, changedState, 2);
    }

    @Override
    public boolean isFoldingDoor() {
        return super.isFoldingDoor();
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
    }

    @Override
    public RenderShape m_7514_(BlockState state) {
        return (Boolean)state.m_61143_((Property)VISIBLE) != false ? RenderShape.MODEL : RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Override
    public void deferUpdate(LevelAccessor level, BlockPos pos) {
        this.withBlockEntityDo((BlockGetter)level, pos, sdte -> {
            sdte.deferUpdate = true;
        });
    }

    public Class<TallForgeCreateSlidingDoorBlockEntity> getBlockEntityClass() {
        return TallForgeCreateSlidingDoorBlockEntity.class;
    }

    public BlockEntityType<? extends TallForgeCreateSlidingDoorBlockEntity> getBlockEntityType() {
        return CreateForgeCompat.TALL_SLIDING_DOOR_BLOCK_ENTITY;
    }
}

