/*
 * Decompiled with CFR 0.152.
 */
package com.seacroak.plushables.block;

import com.seacroak.plushables.block.BasePlushable;
import com.seacroak.plushables.block.tile.PoweredBlockEntity;
import com.seacroak.plushables.networking.AnimationPacketHandler;
import com.seacroak.plushables.networking.PlushablesNetworking;
import com.seacroak.plushables.networking.SoundPacketHandler;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3965;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6575;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animation.AnimationController;

public abstract class BasePoweredPlushable<T extends PoweredBlockEntity>
extends BasePlushable
implements class_2343 {
    public static class_6575 randPitch;
    public class_2586 blockEntityReference;
    protected int cooldownPeriod = 60;
    private final Class<T> BE_TYPE;
    private final class_3414 soundEffect;
    private float pitch;
    public static final class_2746 ON_COOLDOWN;

    public BasePoweredPlushable(Class<T> t, class_3414 sound_effect_in, float pitch_in) {
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11043)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)ON_COOLDOWN, (Comparable)Boolean.valueOf(false)));
        randPitch = new class_6575(100L);
        this.blockEntityReference = null;
        this.BE_TYPE = t;
        this.soundEffect = sound_effect_in;
        this.pitch = pitch_in;
    }

    public BasePoweredPlushable(Class<T> t, class_3414 sound_effect_in) {
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11043)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)ON_COOLDOWN, (Comparable)Boolean.valueOf(false)));
        randPitch = new class_6575(100L);
        this.blockEntityReference = null;
        this.BE_TYPE = t;
        this.soundEffect = sound_effect_in;
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!player.method_5715()) {
            class_2586 blockEntity;
            if (this.pitch == 0.0f) {
                this.pitch = 0.7f + randPitch.method_43057() / 2.0f;
            }
            if (!this.BE_TYPE.isInstance(blockEntity = world.method_8321(pos))) {
                return class_1269.field_21466;
            }
            PoweredBlockEntity typedBlockEntity = (PoweredBlockEntity)blockEntity;
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                try {
                    if (((Boolean)state.method_11654((class_2769)ON_COOLDOWN)).booleanValue()) {
                        return class_1269.field_21466;
                    }
                    this.startCooldown(state, world, pos);
                    world.method_33596((class_1297)player, class_5712.field_28174, pos);
                    if (!typedBlockEntity.shouldAnimate()) {
                        SoundPacketHandler.sendPlayerPacketToClients(serverWorld, new SoundPacketHandler.PlayerSoundPacket(player, pos, this.soundEffect, this.pitch));
                        AnimationPacketHandler.sendPacketToClients(serverWorld, new AnimationPacketHandler.AnimationPacket(player, pos, true, "interaction"));
                    }
                    return class_1269.field_21466;
                }
                catch (Exception e) {
                    System.out.println("An error has occurred (SE-000), please report this to the mod author if you have time :)");
                }
            }
            if (world.field_9236) {
                try {
                    if (!((Boolean)state.method_11654((class_2769)ON_COOLDOWN)).booleanValue() && typedBlockEntity.interactionController.getAnimationState() == AnimationController.State.STOPPED) {
                        typedBlockEntity.shouldAnimate(true);
                        PlushablesNetworking.playAnimationOnClient(true, world, pos, "interaction");
                        PlushablesNetworking.playSoundOnClient(this.soundEffect, world, pos, 1.0f, this.pitch);
                        return class_1269.field_5812;
                    }
                    return class_1269.field_21466;
                }
                catch (Exception e) {
                    System.out.println("An error has occurred (CE-000), please report this to the mod author if you have time :)");
                }
            }
        }
        return super.method_9534(state, world, pos, player, hand, hit);
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return null;
    }

    public void startCooldown(class_2680 state, class_1937 world, class_2338 pos) {
        world.method_8652(pos, (class_2680)state.method_11657((class_2769)ON_COOLDOWN, (Comparable)Boolean.valueOf(true)), 3);
        this.updateNeighbors(state, world, pos);
        world.method_39279(pos, (class_2248)this, this.cooldownPeriod);
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        world.method_8652(pos, (class_2680)state.method_11657((class_2769)ON_COOLDOWN, (Comparable)Boolean.valueOf(false)), 3);
        this.updateNeighbors(state, (class_1937)world, pos);
    }

    private void updateNeighbors(class_2680 state, class_1937 world, class_2338 pos) {
        world.method_8452(pos, (class_2248)this);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{ON_COOLDOWN}).method_11667(new class_2769[]{field_11177}).method_11667(new class_2769[]{WATERLOGGED});
    }

    static {
        ON_COOLDOWN = class_2746.method_11825((String)"on_cooldown");
    }
}

