/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.dynamicpack;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.colors.HSVColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.mehvahdjukaar.snowyspirit.SnowySpirit;
import net.mehvahdjukaar.snowyspirit.configs.CommonConfigs;
import net.mehvahdjukaar.snowyspirit.reg.ModRegistry;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_5819;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ClientDynamicResourcesHandler
extends DynClientResourcesGenerator {
    public static final ClientDynamicResourcesHandler INSTANCE = new ClientDynamicResourcesHandler();
    private static final Map<class_1767, float[]> COLORS = new EnumMap<class_1767, float[]>(class_1767.class);
    private static final List<class_1767> BRIGHT_COLORS = Arrays.stream(class_1767.values()).filter(c -> c.ordinal() < 16 && c != class_1767.field_7957 && c != class_1767.field_7963 && c != class_1767.field_7944 && c != class_1767.field_7967).toList();

    public ClientDynamicResourcesHandler() {
        super(new DynamicTexturePack(SnowySpirit.res("generated_pack")));
        ((DynamicTexturePack)this.dynamicPack).setGenerateDebugResources(PlatHelper.isDev() || CommonConfigs.DEBUG_RESOURCES.get() != false);
    }

    @NotNull
    public static float[] getGlowLightColor(class_1767 color, class_5819 randomSource) {
        if (color == null) {
            RGBColor c = new HSVColor(randomSource.method_43057(), 1.0f, 1.0f, 1.0f).asRGB();
            return new float[]{c.red(), c.green(), c.blue()};
        }
        float[] arr = COLORS.get(color);
        if (arr == null) {
            throw new Error("Returned null color. How? " + color + " " + COLORS);
        }
        return arr;
    }

    protected void onNormalReload(class_3300 manager) {
        super.onNormalReload(manager);
        try {
            List l = SpriteUtils.parsePaletteStrip((class_3300)manager, (class_2960)ResType.PARTICLE_TEXTURES.getPath(SnowySpirit.res("glow_lights_colors")), (int)class_1767.values().length);
            Iterator i = l.iterator();
            for (class_1767 d : class_1767.values()) {
                if (i.hasNext()) {
                    ClientDynamicResourcesHandler.addColor(d, (Integer)i.next());
                    continue;
                }
                ClientDynamicResourcesHandler.addColor(d, d.method_7790());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void addColor(class_1767 d, int c) {
        int n = (c & 0xFF0000) >> 16;
        int o = (c & 0xFF00) >> 8;
        int p = c & 0xFF;
        COLORS.put(d, new float[]{(float)p / 255.0f, (float)o / 255.0f, (float)n / 255.0f});
    }

    public Logger getLogger() {
        return SnowySpirit.LOGGER;
    }

    public boolean dependsOnLoadedPacks() {
        return true;
    }

    public void regenerateDynamicAssets(class_3300 manager) {
        TextureImage template;
        StaticResource itemModel = StaticResource.getOrLog((class_3300)manager, (class_2960)ResType.ITEM_MODELS.getPath(SnowySpirit.res("sled_oak")));
        ModRegistry.SLED_ITEMS.forEach((wood, sled) -> {
            try {
                this.addSimilarJsonResource(manager, itemModel, "sled_oak", wood.getVariantId("sled"));
            }
            catch (Exception ex) {
                this.getLogger().error("Failed to generate Sled item model for {} : {}", (Object)sled, (Object)ex);
            }
        });
        try {
            template = TextureImage.open((class_3300)manager, (class_2960)SnowySpirit.res("entity/sled/oak"));
            try {
                Respriter respriter = Respriter.of((TextureImage)template);
                ModRegistry.SLED_ITEMS.forEach((wood, sled) -> {
                    class_2960 textureRes = SnowySpirit.res("entity/sled/" + wood.getTexturePath());
                    if (this.alreadyHasTextureAtLocation(manager, textureRes)) {
                        return;
                    }
                    try (TextureImage plankTexture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)wood.planks));){
                        Palette targetPalette = Palette.fromImage((TextureImage)plankTexture);
                        TextureImage newImage = respriter.recolor(targetPalette);
                        ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(textureRes, newImage, false);
                    }
                    catch (Exception ex) {
                        this.getLogger().error("Failed to generate sled entity texture for for {} : {}", (Object)sled, (Object)ex);
                    }
                });
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Could not generate any sled entity texture : ", (Throwable)ex);
        }
        try {
            template = TextureImage.open((class_3300)manager, (class_2960)SnowySpirit.res("item/sleds/sled_oak"));
            try (TextureImage boatMask = TextureImage.open((class_3300)manager, (class_2960)SnowySpirit.res("item/sleds/boat_mask"));
                 TextureImage sledMask = TextureImage.open((class_3300)manager, (class_2960)SnowySpirit.res("item/sleds/sled_mask"));){
                Palette palette = Palette.fromImage((TextureImage)template, (TextureImage)sledMask);
                Respriter respriter = Respriter.ofPalette((TextureImage)template, (Palette)palette);
                ModRegistry.SLED_ITEMS.forEach((wood, sled) -> {
                    Palette targetPalette;
                    class_2960 textureRes = SnowySpirit.res("item/sleds/" + Utils.getID((class_1792)sled).method_12832());
                    if (this.alreadyHasTextureAtLocation(manager, textureRes)) {
                        return;
                    }
                    TextureImage newImage = null;
                    class_1792 boat = wood.getItemOfThis("boat");
                    if (boat != null) {
                        try (TextureImage vanillaBoat = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstItemTextureLocation((class_3300)manager, (class_1792)boat));){
                            targetPalette = Palette.fromImage((TextureImage)vanillaBoat, (TextureImage)boatMask);
                            newImage = respriter.recolor(targetPalette);
                        }
                        catch (Exception ex) {
                            this.getLogger().error("Could not find boat texture for wood type {}. Using plank texture : {}", wood, (Object)ex);
                        }
                    }
                    if (newImage == null) {
                        try (TextureImage plankPalette = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)wood.planks));){
                            targetPalette = SpriteUtils.extrapolateWoodItemPalette((TextureImage)plankPalette);
                            newImage = respriter.recolor(targetPalette);
                        }
                        catch (Exception ex) {
                            this.getLogger().error("Failed to generate sled item texture for for {} : {}", (Object)sled, (Object)ex);
                        }
                    }
                    if (newImage != null) {
                        ((DynamicTexturePack)this.dynamicPack).addAndCloseTexture(textureRes, newImage);
                    }
                });
            }
            finally {
                if (template != null) {
                    template.close();
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Could not generate any Sleds item texture : ", (Throwable)ex);
        }
    }

    public void addDynamicTranslations(AfterLanguageLoadEvent lang) {
        ModRegistry.SLED_ITEMS.forEach((wood, sled) -> LangBuilder.addDynamicEntry((AfterLanguageLoadEvent)lang, (String)"item.snowyspirit.sled", (BlockType)wood, (class_1792)sled));
    }
}

