/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.sprout.common.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_7923;

public class FallenTreeFeature
extends class_3031<FallenTreeConfig> {
    private static final int[] DIR = new int[]{-1, 1};
    private static final int[] DIR_REVERSED = new int[]{1, -1};

    public FallenTreeFeature(Codec<FallenTreeConfig> configCodec) {
        super(configCodec);
    }

    public boolean method_13151(class_5821<FallenTreeConfig> context) {
        class_5819 random = context.method_33654();
        class_2338 pos = context.method_33655();
        class_5281 level = context.method_33652();
        class_2350.class_2351 axis = class_2350.class_2353.field_11062.method_10183(random).method_10166();
        ArrayList<class_2338> validPosInLine = new ArrayList<class_2338>(5);
        int count = 0;
        for (int i = 0; i < 5; ++i) {
            class_2338 offset = pos.method_30513(axis, i);
            if (!level.method_8320(offset).method_45474() || level.method_8320(offset.method_10074()).method_45474()) {
                count = 0;
                continue;
            }
            validPosInLine.add(offset);
            ++count;
        }
        if (count < 3) {
            return false;
        }
        class_2680 state = ((FallenTreeConfig)context.method_33656()).log().method_9564();
        if (state.method_28498((class_2769)class_2741.field_12496)) {
            state = (class_2680)state.method_11657((class_2769)class_2741.field_12496, (Comparable)axis);
        }
        class_2350.class_2351 oppositeAxis = FallenTreeFeature.opposite(axis);
        for (class_2338 blockPos : validPosInLine) {
            if (!level.method_8652(blockPos, state, 3)) continue;
            FallenTreeFeature.place(random, blockPos, oppositeAxis, level, (FallenTreeConfig)context.method_33656());
        }
        return true;
    }

    private static void place(class_5819 random, class_2338 pos, class_2350.class_2351 axis, class_5281 level, FallenTreeConfig config) {
        boolean placedMoss = false;
        if (random.method_43057() < config.moss() && level.method_22347(pos.method_10084())) {
            level.method_8652(pos.method_10084(), class_2246.field_28680.method_9564(), 3);
            placedMoss = true;
        }
        for (FungiConfig fungus : config.fungus) {
            float chance = fungus.chance();
            if (placedMoss) {
                chance /= 2.0f;
            }
            if (!(random.method_43057() < chance)) continue;
            FallenTreeFeature.place(random, pos, axis, level, fungus.fungi().method_9564());
            break;
        }
    }

    private static class_2350.class_2351 opposite(class_2350.class_2351 axis) {
        return axis == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048;
    }

    private static void place(class_5819 random, class_2338 pos, class_2350.class_2351 axis, class_5281 level, class_2680 state) {
        for (int i : random.method_43056() ? DIR_REVERSED : DIR) {
            if (state.method_28498((class_2769)class_2383.field_11177)) {
                state = (class_2680)state.method_11657((class_2769)class_2383.field_11177, (Comparable)class_2350.method_10169((class_2350.class_2351)axis, (class_2350.class_2352)(i > 0 ? class_2350.class_2352.field_11056 : class_2350.class_2352.field_11060)));
            }
            if (!level.method_8320(pos.method_30513(axis, i)).method_45474() || !level.method_8652(pos.method_30513(axis, i), state, 3)) continue;
            return;
        }
    }

    public record FallenTreeConfig(class_2248 log, float moss, List<FungiConfig> fungus) implements class_3037
    {
        public static final Codec<FallenTreeConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_7923.field_41175.method_39673().fieldOf("log").forGetter(FallenTreeConfig::log), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("moss").orElse((Object)Float.valueOf(0.0f)).forGetter(FallenTreeConfig::moss), (App)FungiConfig.CODEC.listOf().fieldOf("fungus").orElse(new ArrayList()).forGetter(FallenTreeConfig::fungus)).apply((Applicative)instance, FallenTreeConfig::new));
    }

    public record FungiConfig(class_2248 fungi, float chance) implements class_3037
    {
        public static final Codec<FungiConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_7923.field_41175.method_39673().fieldOf("fungi").forGetter(FungiConfig::fungi), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance").orElse((Object)Float.valueOf(0.0f)).forGetter(FungiConfig::chance)).apply((Applicative)instance, FungiConfig::new));
    }
}

