/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.sprout.common.flowers;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Stream;
import tech.thatgravyboat.sprout.common.flowers.FlowerType;

public enum FlowerColor {
    WHITE(FlowerType.TULIP, FlowerType.LILY_OF_THE_VALLEY),
    ORANGE(FlowerType.TULIP),
    MAGENTA(FlowerType.ALLIUM),
    LIGHT_BLUE(FlowerType.ORCHID),
    YELLOW(FlowerType.DANDELION),
    LIME(new FlowerType[0]),
    PINK(FlowerType.TULIP),
    GRAY(new FlowerType[0]),
    LIGHT_GRAY(FlowerType.AZURE_BLUET, FlowerType.DAISY),
    CYAN(new FlowerType[0]),
    PURPLE(new FlowerType[0]),
    BLUE(FlowerType.CORNFLOWER),
    BROWN(true, new FlowerType[0]),
    GREEN(new FlowerType[0]),
    RED(FlowerType.POPPY, FlowerType.TULIP),
    BLACK(true, new FlowerType[0]);

    public final boolean special;
    public final Set<FlowerType> bannedTypes;

    private FlowerColor(FlowerType ... bannedTypes) {
        this(false, bannedTypes);
    }

    private FlowerColor(boolean special, FlowerType ... bannedTypes) {
        this.special = special;
        this.bannedTypes = Set.of(bannedTypes);
    }

    public boolean isNormal() {
        return !this.isSpecial();
    }

    public boolean isSpecial() {
        return this.special;
    }

    public static Stream<FlowerColor> stream() {
        return Arrays.stream(FlowerColor.values());
    }

    public FlowerColor combined(FlowerColor color) {
        return switch (this) {
            case RED -> {
                if (color == YELLOW) {
                    yield ORANGE;
                }
                if (color == BLUE) {
                    yield PURPLE;
                }
                yield null;
            }
            case WHITE -> {
                if (color == GREEN) {
                    yield LIME;
                }
                if (color == BLUE) {
                    yield LIGHT_BLUE;
                }
                if (color == GRAY) {
                    yield LIGHT_GRAY;
                }
                if (color == BLACK) {
                    yield GRAY;
                }
                yield null;
            }
            case GREEN -> {
                if (color == WHITE) {
                    yield LIME;
                }
                if (color == BLUE) {
                    yield CYAN;
                }
                yield null;
            }
            case BLUE -> {
                if (color == WHITE) {
                    yield LIGHT_BLUE;
                }
                if (color == GREEN) {
                    yield CYAN;
                }
                if (color == RED) {
                    yield PURPLE;
                }
                if (color == YELLOW) {
                    yield GREEN;
                }
                yield null;
            }
            case YELLOW -> {
                if (color == RED) {
                    yield ORANGE;
                }
                if (color == WHITE) {
                    yield LIME;
                }
                yield null;
            }
            case BLACK -> {
                if (color == WHITE) {
                    yield GRAY;
                }
                yield null;
            }
            default -> null;
        };
    }
}

