/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.sprout.common.flowers;

import com.mojang.datafixers.util.Pair;
import com.teamresourceful.resourcefullib.common.collections.WeightedCollection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import tech.thatgravyboat.sprout.common.flowers.FlowerBreed;
import tech.thatgravyboat.sprout.common.flowers.FlowerColor;
import tech.thatgravyboat.sprout.common.flowers.FlowerType;
import tech.thatgravyboat.sprout.common.registry.SproutFlowers;

public class FlowerBreedTree {
    public static final Map<FlowerBreed, WeightedCollection<class_2248>> BREEDS = new HashMap<FlowerBreed, WeightedCollection<class_2248>>();

    private static void addFlowers(Pair<FlowerType, FlowerColor> flower1, Pair<FlowerType, FlowerColor> flower2, double normal, double special) {
        class_2248 block2;
        Map<FlowerType, Supplier<class_2248>> flower1Type = SproutFlowers.FLOWERS.get(flower1.getSecond());
        Map<FlowerType, Supplier<class_2248>> flower2Type = SproutFlowers.FLOWERS.get(flower2.getSecond());
        class_2248 block1 = flower1Type.get(flower1.getFirst()).get();
        if (block1 == (block2 = flower2Type.get(flower2.getFirst()).get())) {
            FlowerBreedTree.register(new Builder(block1, block2).add(block1, 1.0));
            return;
        }
        Builder builder = new Builder(block1, block2).add(block1, normal).add(block2, normal).add(flower1Type.get(flower2.getFirst()), special).add(flower2Type.get(flower1.getFirst()), special);
        FlowerColor combined = ((FlowerColor)((Object)flower1.getSecond())).combined((FlowerColor)((Object)flower2.getSecond()));
        if (combined != null) {
            Map<FlowerType, Supplier<class_2248>> cominbedType = SproutFlowers.FLOWERS.get((Object)combined);
            builder.add(cominbedType.get(flower2.getFirst()), normal / 2.0);
            builder.add(cominbedType.get(flower1.getFirst()), normal / 2.0);
        }
        FlowerBreedTree.register(builder);
    }

    public static void register(Builder builder) {
        BREEDS.put(builder.breed, builder.flowers);
    }

    static {
        List normalFlowers = FlowerColor.stream().filter(FlowerColor::isNormal).flatMap(color -> FlowerType.stream().map(type -> Pair.of((Object)type, (Object)color))).toList();
        List specialFlowers = FlowerColor.stream().filter(FlowerColor::isSpecial).flatMap(color -> FlowerType.stream().map(type -> Pair.of((Object)type, (Object)color))).toList();
        List combinedFlowers = Stream.concat(specialFlowers.stream(), normalFlowers.stream()).toList();
        for (Pair flower1 : normalFlowers) {
            for (Pair flower2 : normalFlowers) {
                FlowerBreedTree.addFlowers((Pair<FlowerType, FlowerColor>)flower1, (Pair<FlowerType, FlowerColor>)flower2, 40.0, 10.0);
            }
        }
        for (Pair flower1 : specialFlowers) {
            for (Pair flower2 : combinedFlowers) {
                FlowerBreedTree.addFlowers((Pair<FlowerType, FlowerColor>)flower1, (Pair<FlowerType, FlowerColor>)flower2, 49.0, 1.0);
            }
        }
        for (Pair flower2 : combinedFlowers) {
            class_2248 block2 = SproutFlowers.FLOWERS.get(flower2.getSecond()).get(flower2.getFirst()).get();
            Builder builder = new Builder(class_2246.field_10606, block2).add(class_2246.field_10606, 49.8).add(block2, 49.85).add(SproutFlowers.FLOWERS.get((Object)FlowerColor.BLACK).get(flower2.getFirst()), 0.2).add(SproutFlowers.FLOWERS.get((Object)FlowerColor.BROWN).get(flower2.getFirst()), 0.15);
            FlowerBreedTree.register(builder);
        }
        FlowerBreedTree.register(new Builder(class_2246.field_10606, class_2246.field_10606).add(class_2246.field_10606, 1.0));
    }

    private static class Builder {
        private final FlowerBreed breed;
        private final WeightedCollection<class_2248> flowers = new WeightedCollection();

        public Builder(class_2248 flower1, class_2248 flower2) {
            this.breed = FlowerBreed.of(flower1, flower2);
        }

        public Builder add(Supplier<class_2248> flower, double weight) {
            this.flowers.add(weight, (Object)flower.get());
            return this;
        }

        public Builder add(class_2248 flower, double weight) {
            this.flowers.add(weight, (Object)flower);
            return this;
        }
    }
}

