/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.sprout.common.entities;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1321;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1386;
import net.minecraft.class_1391;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.keyframe.event.ParticleKeyframeEvent;
import software.bernie.geckolib.core.keyframe.event.SoundKeyframeEvent;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import tech.thatgravyboat.sprout.common.entities.Herbivore;
import tech.thatgravyboat.sprout.common.entities.goals.DrinkWaterGoal;
import tech.thatgravyboat.sprout.common.entities.goals.FindPlantGoal;
import tech.thatgravyboat.sprout.common.entities.goals.FindWaterGoal;
import tech.thatgravyboat.sprout.common.entities.goals.SprayWaterGoal;
import tech.thatgravyboat.sprout.common.entities.goals.SproutWanderGoal;
import tech.thatgravyboat.sprout.common.registry.SproutItems;
import tech.thatgravyboat.sprout.common.registry.SproutParticles;
import tech.thatgravyboat.sprout.common.registry.SproutSounds;
import tech.thatgravyboat.sprout.common.utils.EntityUtils;

public class ElephantEntity
extends class_1321
implements GeoEntity,
Herbivore {
    private static final RawAnimation DRINKING_ANIMATION = RawAnimation.begin().thenPlay("animation.elephant.drinking");
    private static final RawAnimation WATERING_ANIMATION = RawAnimation.begin().thenLoop("animation.elephant.watering");
    private static final RawAnimation WALKING_ANIMATION = RawAnimation.begin().thenLoop("animation.elephant.walking");
    private static final RawAnimation IDLING_ANIMATION = RawAnimation.begin().thenLoop("animation.elephant.idling");
    private static final RawAnimation SLEEPING_ANIMATION = RawAnimation.begin().thenLoop("animation.elephant.sleeping");
    protected static final class_2940<Boolean> DRINKING = class_2945.method_12791(ElephantEntity.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Boolean> WATERING = class_2945.method_12791(ElephantEntity.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Boolean> HAS_WATER = class_2945.method_12791(ElephantEntity.class, (class_2941)class_2943.field_13323);
    public static final class_1856 PEANUT_TEMPT_ITEM = class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)SproutItems.PEANUT.get()});
    public static final class_6862<class_1792> PEANUT_TAG = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960("sprout", "peanuts"));
    @Nullable
    private class_2338 waterPos;
    private class_2338 plantPos;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public ElephantEntity(class_1299<? extends class_1321> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static boolean canSpawn(class_1299<ElephantEntity> ignoredType, class_5425 world, class_3730 ignoredReason, class_2338 pos, class_5819 ignoredRandom) {
        return pos.method_10264() > world.method_8615() && world.method_8320(pos.method_10074()).method_26164(class_3481.field_29822) && world.method_8409().method_43048(10) == 0;
    }

    protected void method_5693() {
        super.method_5693();
        this.method_5841().method_12784(DRINKING, (Object)false);
        this.method_5841().method_12784(WATERING, (Object)false);
        this.method_5841().method_12784(HAS_WATER, (Object)false);
    }

    public void method_5749(@NotNull class_2487 nbt) {
        super.method_5749(nbt);
        this.method_5841().method_12778(DRINKING, (Object)nbt.method_10577("Drinking"));
        this.method_5841().method_12778(WATERING, (Object)nbt.method_10577("Watering"));
        this.method_5841().method_12778(HAS_WATER, (Object)nbt.method_10577("HasWater"));
    }

    public void method_5652(@NotNull class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("Drinking", ((Boolean)this.method_5841().method_12789(DRINKING)).booleanValue());
        nbt.method_10556("Watering", ((Boolean)this.method_5841().method_12789(WATERING)).booleanValue());
        nbt.method_10556("HasWater", ((Boolean)this.method_5841().method_12789(HAS_WATER)).booleanValue());
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1374((class_1314)this, 0.3));
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(2, (class_1352)new class_1391((class_1314)this, 0.5, PEANUT_TEMPT_ITEM, false));
        this.field_6201.method_6277(3, (class_1352)new FindWaterGoal(this));
        this.field_6201.method_6277(3, (class_1352)new DrinkWaterGoal(this, 3));
        this.field_6201.method_6277(3, new FindPlantGoal<ElephantEntity>(this, EntityUtils::validBoneMealTarget));
        this.field_6201.method_6277(3, (class_1352)new SprayWaterGoal(this, 6));
        this.field_6201.method_6277(8, new SproutWanderGoal<ElephantEntity>(this, 0.2));
        this.field_6201.method_6277(9, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(10, (class_1352)new class_1376((class_1308)this));
    }

    @Nullable
    public ElephantEntity getBreedOffspring(@NotNull class_3218 world, @NotNull class_1296 entity) {
        return null;
    }

    public boolean method_5643(@NotNull class_1282 source, float amount) {
        if (this.method_5679(source)) {
            return false;
        }
        this.method_24346(false);
        this.setWatering(false);
        return super.method_5643(source, amount);
    }

    @NotNull
    public class_1269 method_5992(class_1657 player, @NotNull class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_31573(PEANUT_TAG)) {
            if (!this.method_6181()) {
                if (!player.method_31549().field_7477) {
                    stack.method_7934(1);
                }
                if (!this.method_37908().method_8608()) {
                    if (this.field_5974.method_43048(10) == 0) {
                        this.method_6170(player);
                        this.method_37908().method_8421((class_1297)this, (byte)7);
                    } else {
                        this.method_37908().method_8421((class_1297)this, (byte)6);
                    }
                }
                return class_1269.method_29236((boolean)this.method_37908().method_8608());
            }
            if (this.method_6032() < this.method_6063()) {
                if (!player.method_31549().field_7477) {
                    stack.method_7934(1);
                }
                if (!this.method_37908().method_8608()) {
                    this.method_6025(2.0f);
                }
                return class_1269.method_29236((boolean)this.method_37908().method_8608());
            }
            return class_1269.field_5811;
        }
        class_1269 result = super.method_5992(player, hand);
        if (!result.method_23665() && this.method_6181() && this.method_6171((class_1309)player)) {
            if (!this.method_37908().method_8608()) {
                if (!this.method_24345()) {
                    this.setWatering(false);
                }
                this.method_24346(!this.method_24345());
            }
            return class_1269.method_29236((boolean)this.method_37908().method_8608());
        }
        return result;
    }

    public boolean isDrinking() {
        return (Boolean)this.method_5841().method_12789(DRINKING);
    }

    public boolean isWatering() {
        return (Boolean)this.method_5841().method_12789(WATERING);
    }

    public boolean hasWater() {
        return (Boolean)this.method_5841().method_12789(HAS_WATER);
    }

    @Nullable
    public class_2338 getWaterPos() {
        return this.waterPos;
    }

    public void setWaterPos(@Nullable class_2338 waterPos) {
        this.waterPos = waterPos;
    }

    public boolean isNearWater() {
        return this.isNearBlock(this.getWaterPos(), 1);
    }

    public boolean isNearBlock(class_2338 pos, int range) {
        return pos != null && pos.method_10262((class_2382)this.method_24515()) < (double)(range * range);
    }

    public boolean isNearPlant() {
        return this.isNearBlock(this.getTargetPlant(), 3);
    }

    public void setDrinking(boolean bool) {
        this.method_5841().method_12778(DRINKING, (Object)bool);
    }

    public void setWatering(boolean bool) {
        this.method_5841().method_12778(WATERING, (Object)bool);
    }

    public void setIfHasWater(boolean bool) {
        this.method_5841().method_12778(HAS_WATER, (Object)bool);
    }

    private PlayState actions(AnimationState<ElephantEntity> event) {
        if (!event.isMoving() && !this.method_6172()) {
            if (this.isDrinking()) {
                event.getController().setAnimation(DRINKING_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.isWatering()) {
                event.getController().setAnimation(WATERING_ANIMATION);
                return PlayState.CONTINUE;
            }
        }
        return PlayState.STOP;
    }

    private PlayState walkCycle(AnimationState<ElephantEntity> event) {
        if (!this.method_6172()) {
            if (event.isMoving()) {
                event.getController().setAnimation(WALKING_ANIMATION);
            } else {
                event.getController().setAnimation(IDLING_ANIMATION);
            }
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private PlayState sitStand(AnimationState<ElephantEntity> event) {
        if (this.method_6172()) {
            event.getController().setAnimation(SLEEPING_ANIMATION);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private void particleInitializer(ParticleKeyframeEvent<ElephantEntity> event) {
        if ("sprout:snooze".equals(event.getKeyframeData().getEffect())) {
            this.method_37908().method_8406((class_2394)SproutParticles.SNOOZE.get(), this.method_23317(), this.method_23318() + 0.8, this.method_23321(), 0.01, 1.0, 0.01);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void soundInitializer(SoundKeyframeEvent<ElephantEntity> event) {
        if (!this.method_37908().method_8608()) {
            return;
        }
        if ("sprout:sleep".equals(event.getKeyframeData().getSound())) {
            this.method_37908().method_43129((class_1657)class_310.method_1551().field_1724, (class_1297)this, SproutSounds.SLEEP.get(), class_3419.field_15256, 0.5f, 0.5f);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "action_controller", 5, this::actions)});
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "walk_controller", 5, this::walkCycle)});
        AnimationController sleepController = new AnimationController((GeoAnimatable)this, "sit_controller", 2, this::sitStand);
        sleepController.setParticleKeyframeHandler(this::particleInitializer);
        sleepController.setSoundKeyframeHandler(this::soundInitializer);
        registrar.add(new AnimationController[]{sleepController});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public boolean isNotBusy() {
        return !this.isDrinking() && !this.method_24345() && !this.isWatering();
    }

    @Override
    public boolean specialPredicate() {
        return this.hasWater();
    }

    @Override
    public void setTargetPlant(class_2338 pos) {
        this.plantPos = pos;
    }

    @Override
    @Nullable
    public class_2338 getTargetPlant() {
        return this.plantPos;
    }

    public static class_5132.class_5133 createElephantAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 10.0);
    }
}

