/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.sprout.common.entities;

import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1386;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1972;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2420;
import net.minecraft.class_2421;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3730;
import net.minecraft.class_4771;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import tech.thatgravyboat.sprout.common.entities.BounceBugVariant;
import tech.thatgravyboat.sprout.common.entities.Herbivore;
import tech.thatgravyboat.sprout.common.entities.goals.FindPlantGoal;
import tech.thatgravyboat.sprout.common.entities.goals.SpreadShroomOrGrowWartGoal;
import tech.thatgravyboat.sprout.common.entities.goals.SproutWanderGoal;
import tech.thatgravyboat.sprout.common.registry.SproutItems;

public class BounceBugEntity
extends class_1321
implements GeoEntity,
Herbivore {
    private static final RawAnimation WALKING = RawAnimation.begin().thenLoop("animation.bounce_bug.walking");
    private static final RawAnimation IDLING = RawAnimation.begin().thenLoop("animation.bounce_bug.idling");
    private static final RawAnimation SITTING = RawAnimation.begin().thenLoop("animation.bounce_bug.sitting");
    private static final RawAnimation WIGGLING = RawAnimation.begin().thenLoop("animation.bounce_bug.wiggling");
    private static final class_2940<Boolean> BOUNCE_BUG_VARIANT = class_2945.method_12791(BounceBugEntity.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Boolean> SPREADING_SPORES = class_2945.method_12791(BounceBugEntity.class, (class_2941)class_2943.field_13323);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private class_2338 shroomPos;

    public BounceBugEntity(class_1299<BounceBugEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    @NotNull
    public class_1310 method_6046() {
        return class_1310.field_6293;
    }

    public static boolean canSpawn(class_1299<BounceBugEntity> ignoredType, class_5425 world, class_3730 ignoredReason, class_2338 pos, class_5819 ignoredRandom) {
        return world.method_8320(pos.method_10074()).method_26164(class_3481.field_21953);
    }

    public class_1315 method_5943(@NotNull class_5425 world, @NotNull class_1266 difficulty, @NotNull class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        class_6880 biome = world.method_23753(this.method_24515());
        if (biome.method_40225(class_1972.field_22077)) {
            this.setBounceBugVariant(BounceBugVariant.CRIMSON);
        }
        if (class_3730.field_16465.equals((Object)spawnReason) && !biome.method_40225(class_1972.field_22075)) {
            this.setBounceBugVariant(BounceBugVariant.random(world.method_8409()));
        }
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @NotNull
    public class_1269 method_5992(class_1657 player, @NotNull class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_31574(class_1802.field_8469)) {
            if (!this.method_37908().method_8608()) {
                this.setIfSpreadingSpores(false);
                stack.method_7934(1);
                class_2487 bugNbt = new class_2487();
                this.method_5786(bugNbt);
                bugNbt.method_10551("UUID");
                class_1799 bugBottle = new class_1799((class_1935)SproutItems.BOUNCE_BUG_JAR.get());
                bugBottle.method_7948().method_10566("bug", (class_2520)bugNbt);
                player.method_31548().method_7398(bugBottle);
                this.method_31472();
                return class_1269.method_29236((boolean)this.method_37908().method_8608());
            }
        } else if (this.method_35057() != null) {
            if (!this.method_24345()) {
                class_2248 blockFromItem = class_2248.method_9503((class_1792)stack.method_7909());
                if (blockFromItem instanceof class_4771 || blockFromItem instanceof class_2420) {
                    if (!this.method_37908().method_8608()) {
                        this.method_24346(true);
                    }
                    this.setIfSpreadingSpores(false);
                    class_1799 heldItem = stack.method_7972();
                    stack.method_7934(1);
                    heldItem.method_7939(1);
                    this.method_6122(class_1268.field_5808, heldItem);
                    return class_1269.method_29236((boolean)this.method_37908().method_8608());
                }
            } else {
                if (!this.method_37908().method_8608()) {
                    this.method_24346(false);
                }
                player.method_31548().method_7398(this.method_5998(class_1268.field_5808).method_7972());
                this.method_6122(class_1268.field_5808, class_1799.field_8037);
                return class_1269.method_29236((boolean)this.method_37908().method_8608());
            }
        }
        return super.method_5992(player, hand);
    }

    protected void method_5693() {
        super.method_5693();
        this.method_5841().method_12784(BOUNCE_BUG_VARIANT, (Object)true);
        this.method_5841().method_12784(SPREADING_SPORES, (Object)false);
    }

    public void method_5652(@NotNull class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10582("bugType", this.getBounceBugVariant().name());
        nbt.method_10556("isSpreadingSpores", this.isSpreadingSpores());
    }

    public void method_5749(@NotNull class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10545("bugType")) {
            this.setBounceBugVariant(BounceBugVariant.getVariant(nbt.method_10558("bugType")));
        }
        if (nbt.method_10545("isSpreadingSpores")) {
            this.setIfSpreadingSpores(nbt.method_10577("isSpreadingSpores"));
        }
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1374((class_1314)this, 0.3));
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(2, new FindPlantGoal<BounceBugEntity>(this, (level, pos) -> {
            class_2248 block = level.method_8320(pos).method_26204();
            return block instanceof class_2421 || block instanceof class_2420 || block instanceof class_4771;
        }));
        this.field_6201.method_6277(3, (class_1352)new SpreadShroomOrGrowWartGoal(this));
        this.field_6201.method_6277(8, new SproutWanderGoal<BounceBugEntity>(this, 0.2));
        this.field_6201.method_6277(9, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(10, (class_1352)new class_1376((class_1308)this));
    }

    public boolean method_5643(@NotNull class_1282 source, float amount) {
        if (this.method_5679(source)) {
            return false;
        }
        this.method_24346(false);
        this.setIfSpreadingSpores(false);
        return super.method_5643(source, amount);
    }

    public boolean isNearShroom() {
        return this.shroomPos != null && this.shroomPos.method_10262((class_2382)this.method_24515()) < 9.0;
    }

    @Nullable
    public BounceBugEntity getBreedOffspring(@NotNull class_3218 world, @NotNull class_1296 entity) {
        return null;
    }

    @Override
    public boolean isNotBusy() {
        return !this.isSpreadingSpores();
    }

    @Override
    public void setTargetPlant(class_2338 pos) {
        this.shroomPos = pos;
    }

    @Override
    @Nullable
    public class_2338 getTargetPlant() {
        return this.shroomPos;
    }

    private void setBounceBugVariant(BounceBugVariant variant) {
        this.method_5841().method_12778(BOUNCE_BUG_VARIANT, (Object)(variant == BounceBugVariant.WARPED ? 1 : 0));
    }

    public BounceBugVariant getBounceBugVariant() {
        return (Boolean)this.method_5841().method_12789(BOUNCE_BUG_VARIANT) != false ? BounceBugVariant.WARPED : BounceBugVariant.CRIMSON;
    }

    public void setIfSpreadingSpores(boolean isSpreadingSpores) {
        this.method_5841().method_12778(SPREADING_SPORES, (Object)isSpreadingSpores);
    }

    public boolean isSpreadingSpores() {
        return (Boolean)this.method_5841().method_12789(SPREADING_SPORES);
    }

    @Override
    public boolean specialPredicate() {
        return !this.isSpreadingSpores();
    }

    private PlayState walkCycle(AnimationState<BounceBugEntity> event) {
        if (!this.method_6172()) {
            if (event.isMoving()) {
                event.getController().setAnimation(WALKING);
            } else {
                event.getController().setAnimation(IDLING);
            }
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private PlayState sitStand(AnimationState<BounceBugEntity> event) {
        if (this.method_6172()) {
            event.getController().setAnimation(SITTING);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private PlayState actions(AnimationState<BounceBugEntity> event) {
        if (!event.isMoving() && !this.method_6172() && this.isSpreadingSpores()) {
            event.getController().setAnimation(WIGGLING);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "walk_cycle", 0, this::walkCycle)});
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "sitting_cycle", 0, this::sitStand)});
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "action_cycles", 5, this::actions)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static class_5132.class_5133 createBounceBugAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 4.0);
    }
}

