/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.sprout;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1163;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1933;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2400;
import net.minecraft.class_322;
import net.minecraft.class_326;
import net.minecraft.class_4002;
import net.minecraft.class_5616;
import net.minecraft.class_5617;
import net.minecraft.class_707;
import org.jetbrains.annotations.NotNull;
import tech.thatgravyboat.sprout.client.BottledEntityBlockEntityRenderer;
import tech.thatgravyboat.sprout.client.FlowerBoxBlockEntityRenderer;
import tech.thatgravyboat.sprout.client.ShootParticle;
import tech.thatgravyboat.sprout.client.SnoozeParticle;
import tech.thatgravyboat.sprout.client.entity.BounceBugEntityRenderer;
import tech.thatgravyboat.sprout.client.entity.ButterflyModel;
import tech.thatgravyboat.sprout.client.entity.ElephantEntityModel;
import tech.thatgravyboat.sprout.client.entity.MobEntityRenderer;
import tech.thatgravyboat.sprout.common.entities.ButterFly;
import tech.thatgravyboat.sprout.common.entities.ElephantEntity;
import tech.thatgravyboat.sprout.common.flowers.FlowerColor;
import tech.thatgravyboat.sprout.common.flowers.FlowerType;
import tech.thatgravyboat.sprout.common.registry.SproutBlocks;
import tech.thatgravyboat.sprout.common.registry.SproutEntities;
import tech.thatgravyboat.sprout.common.registry.SproutFlowers;
import tech.thatgravyboat.sprout.common.registry.SproutItems;
import tech.thatgravyboat.sprout.common.registry.SproutParticles;
import tech.thatgravyboat.sprout.fabric.SproutClientImpl;

@Environment(value=EnvType.CLIENT)
public class SproutClient {
    public static void init() {
        SproutClient.renderBlockRenderers(SproutBlocks.PEANUT_PLANT_BLOCK, class_1921.method_23581());
        SproutClient.renderBlockRenderers(SproutBlocks.BOUNCE_BUG_BOTTLE, class_1921.method_23581());
        SproutClient.renderBlockRenderers(SproutBlocks.BUTTER_FLY_BOTTLE, class_1921.method_23581());
        SproutClient.renderBlockRenderers(SproutBlocks.CATTIAL, class_1921.method_23581());
        SproutClient.renderBlockRenderers(SproutBlocks.TALL_DEAD_BUSH, class_1921.method_23581());
        SproutClient.renderBlockRenderers(SproutBlocks.WATER_LENTIL, class_1921.method_23581());
        SproutClient.renderBlockRenderers(SproutBlocks.SPROUTS, class_1921.method_23581());
        SproutClient.renderBlockRenderers(SproutBlocks.DUNE_GRASS, class_1921.method_23581());
        SproutClient.renderBlockRenderers(SproutBlocks.RED_SHELF_FUNGI, class_1921.method_23581());
        SproutClient.renderBlockRenderers(SproutBlocks.BROWN_SHELF_FUNGI, class_1921.method_23581());
        SproutClient.renderBlockRenderers(SproutBlocks.WARPED_SHELF_FUNGI, class_1921.method_23581());
        SproutClient.renderBlockRenderers(SproutBlocks.CRIMSON_SHELF_FUNGI, class_1921.method_23581());
        SproutClient.renderBlockRenderers(SproutBlocks.DUNE_GRASS, class_1921.method_23581());
        for (Map.Entry<FlowerColor, Map<FlowerType, Supplier<class_2248>>> entry : SproutFlowers.FLOWERS.entrySet()) {
            for (Map.Entry<FlowerType, Supplier<class_2248>> flower : entry.getValue().entrySet()) {
                if (entry.getKey().bannedTypes.contains((Object)flower.getKey())) continue;
                SproutClient.renderBlockRenderers(flower.getValue(), class_1921.method_23581());
            }
        }
        SproutFlowers.POTTED_FLOWERS.forEach(value -> SproutClient.renderBlockRenderers(value, class_1921.method_23581()));
        SproutClient.registerEntityRenderer(SproutEntities.ELEPHANT_ENTITY_TYPE, ctx -> new MobEntityRenderer<ElephantEntity>(ctx, new ElephantEntityModel()));
        SproutClient.registerEntityRenderer(SproutEntities.BUTTERFLY, ctx -> new MobEntityRenderer<ButterFly>(ctx, new ButterflyModel()));
        SproutClient.registerEntityRenderer(SproutEntities.BOUNCE_BUG_ENTITY, BounceBugEntityRenderer::new);
        class_5616.method_32144(SproutBlocks.BOUNCE_BUG_JAR_BLOCK_ENTITY.get(), ctx -> new BottledEntityBlockEntityRenderer());
        class_5616.method_32144(SproutBlocks.BUTTER_FLY_JAR_BLOCK_ENTITY.get(), ctx -> new BottledEntityBlockEntityRenderer());
        class_5616.method_32144(SproutBlocks.FLOWER_BOX_ENTITY.get(), ctx -> new FlowerBoxBlockEntityRenderer());
    }

    public static void initBlockColors() {
        SproutClient.registerBlockColor((state, world, pos, tintIndex) -> tintIndex == 1 ? -1 : (world == null || pos == null ? class_1933.method_8377((double)0.5, (double)1.0) : class_1163.method_4962((class_1920)world, (class_2338)pos)), SproutBlocks.CATTIAL.get(), SproutBlocks.WATER_LENTIL.get(), SproutBlocks.SPROUTS.get());
    }

    public static void initItemColors() {
        SproutClient.registerItemColor((stack, tintIndex) -> class_1933.method_8377((double)0.5, (double)1.0), SproutItems.WATER_LENTIL.get(), SproutItems.SPROUTS.get());
    }

    public static void initParticleFactories() {
        SproutClient.registerParticleFactory(SproutParticles.SNOOZE, SnoozeParticle.Factory::new);
        SproutClient.registerParticleFactory(SproutParticles.SHOOTS, ShootParticle.Factory::new);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerBlockColor(class_322 provider, class_2248 ... items) {
        void var1_1;
        SproutClientImpl.registerBlockColor(provider, (class_2248[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerItemColor(class_326 provider, class_1792 ... items) {
        void var1_1;
        SproutClientImpl.registerItemColor(provider, (class_1792[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void renderBlockRenderers(Supplier<class_2248> blockSupplier, class_1921 renderLayer) {
        void var1_1;
        SproutClientImpl.renderBlockRenderers(blockSupplier, (class_1921)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends class_1297> void registerEntityRenderer(Supplier<class_1299<T>> entityTypeSupplier, class_5617<T> renderer) {
        void var1_1;
        SproutClientImpl.registerEntityRenderer(entityTypeSupplier, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerParticleFactory(Supplier<class_2400> particle, SpriteAwareFactory<class_2400> factory) {
        void var1_1;
        SproutClientImpl.registerParticleFactory(particle, (SpriteAwareFactory<class_2400>)var1_1);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface SpriteAwareFactory<T extends class_2394> {
        @NotNull
        public class_707<T> create(class_4002 var1);
    }
}

