/*
 * Decompiled with CFR 0.152.
 */
package paulevs.edenring.world.generator;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2338;
import net.minecraft.class_5819;
import net.minecraft.class_6677;
import org.betterx.bclib.noise.OpenSimplexNoise;
import org.betterx.bclib.sdf.SDF;
import org.betterx.bclib.util.MHelper;
import paulevs.edenring.world.generator.IslandTypes;
import paulevs.edenring.world.generator.LayerOptions;

public class IslandLayer {
    private final Map<class_2338, SDF> islandCache = Maps.newHashMap();
    private final List<class_2338> positions = new ArrayList<class_2338>(9);
    private final List<SDF> nearIslands = new ArrayList<SDF>(9);
    private final class_5819 random = new class_6677(0L);
    private final OpenSimplexNoise density;
    private final LayerOptions options;
    private final int seed;
    private int lastX;
    private int lastZ;

    public IslandLayer(int seed, LayerOptions options) {
        this.density = new OpenSimplexNoise((long)seed);
        this.options = options;
        this.seed = seed;
    }

    public void updatePositions(double x, double z) {
        int ix = MHelper.floor((double)(x / (double)this.options.distance));
        int iz = MHelper.floor((double)(z / (double)this.options.distance));
        if (this.lastX != ix || this.lastZ != iz || this.positions.isEmpty()) {
            this.lastX = ix;
            this.lastZ = iz;
            this.nearIslands.clear();
            this.positions.clear();
            for (int pox = -1; pox < 2; ++pox) {
                int px = pox + ix;
                for (int poz = -1; poz < 2; ++poz) {
                    int pz = poz + iz;
                    this.random.method_43052((long)MHelper.getSeed((int)this.seed, (int)px, (int)pz));
                    double posX = ((float)px + this.random.method_43057()) * this.options.distance;
                    double posY = MHelper.randRange((int)this.options.minY, (int)this.options.maxY, (class_5819)this.random);
                    double posZ = ((float)pz + this.random.method_43057()) * this.options.distance;
                    if (!(this.density.eval(posX * 0.01, posZ * 0.01) > (double)this.options.coverage)) continue;
                    class_2338 pos = new class_2338((int)posX, (int)posY, (int)posZ);
                    this.nearIslands.add(this.getIsland(pos));
                    this.positions.add(pos);
                }
            }
        }
    }

    private SDF getIsland(class_2338 pos) {
        return this.islandCache.computeIfAbsent(pos, i -> {
            this.random.method_43052((long)MHelper.getSeed((int)this.seed, (int)pos.method_10263(), (int)pos.method_10260()));
            return IslandTypes.getIsland(this.options, this.random);
        });
    }

    private float getRelativeDistance(SDF sdf, class_2338 center, double px, double py, double pz) {
        float x = (float)(px - (double)center.method_10263()) / this.options.scale;
        float y = (float)(py - (double)center.method_10264()) / this.options.scale;
        float z = (float)(pz - (double)center.method_10260()) / this.options.scale;
        return sdf.getDistance(x, y, z);
    }

    private float calculateSDF(double x, double y, double z) {
        float distance = 10.0f;
        int size = this.positions.size();
        for (int i = 0; i < size; ++i) {
            class_2338 pos;
            SDF island = this.nearIslands.get(i);
            float dist = this.getRelativeDistance(island, pos = this.positions.get(i), x, y, z);
            if (dist < distance) {
                distance = dist;
            }
            if (distance < 0.0f) break;
        }
        return distance;
    }

    public float getDensity(double x, double y, double z) {
        return -this.calculateSDF(x, y, z);
    }

    public void clearCache() {
        if (this.islandCache.size() > 128) {
            this.islandCache.clear();
        }
    }
}

