/*
 * Decompiled with CFR 0.152.
 */
package paulevs.datagen.worldgen;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_1959;
import net.minecraft.class_7225;
import net.minecraft.class_7891;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeBuilder;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.api.v3.datagen.TagDataProvider;
import org.betterx.worlds.together.tag.v3.TagManager;
import org.betterx.worlds.together.tag.v3.TagRegistry;
import paulevs.edenring.registries.EdenBiomes;
import paulevs.edenring.world.biomes.EdenRingBiome;
import paulevs.edenring.world.biomes.air.AirOceanBiome;
import paulevs.edenring.world.biomes.air.GraviliteDebrisFieldBiome;
import paulevs.edenring.world.biomes.air.SkyColonyBiome;
import paulevs.edenring.world.biomes.cave.EmptyCaveBiome;
import paulevs.edenring.world.biomes.cave.ErodedCaveBiome;
import paulevs.edenring.world.biomes.land.BrainStormBiome;
import paulevs.edenring.world.biomes.land.GoldenForestBiome;
import paulevs.edenring.world.biomes.land.LakesideDesertBiome;
import paulevs.edenring.world.biomes.land.MycoticForestBiome;
import paulevs.edenring.world.biomes.land.OldMycoticForestBiome;
import paulevs.edenring.world.biomes.land.PulseForestBiome;
import paulevs.edenring.world.biomes.land.StoneGardenBiome;
import paulevs.edenring.world.biomes.land.WindValleyBiome;

public class EdenRingBiomesDataProvider
extends TagDataProvider<class_1959> {
    public static final List<EdenRingBiome> BIOMES_LAND = Lists.newArrayList();
    public static final List<EdenRingBiome> BIOMES_AIR = Lists.newArrayList();
    public static final List<EdenRingBiome> BIOMES_CAVE = Lists.newArrayList();
    protected static final EdenRingBiome STONE_GARDEN = EdenRingBiomesDataProvider.registerLand(new StoneGardenBiome());
    protected static final EdenRingBiome GOLDEN_FOREST = EdenRingBiomesDataProvider.registerLand(new GoldenForestBiome());
    protected static final EdenRingBiome MYCOTIC_FOREST = EdenRingBiomesDataProvider.registerLand(new MycoticForestBiome());
    protected static final EdenRingBiome PULSE_FOREST = EdenRingBiomesDataProvider.registerLand(new PulseForestBiome());
    protected static final EdenRingBiome BRAINSTORM = EdenRingBiomesDataProvider.registerLand(new BrainStormBiome());
    protected static final EdenRingBiome LAKESIDE_DESERT = EdenRingBiomesDataProvider.registerLand(new LakesideDesertBiome());
    protected static final EdenRingBiome WIND_VALLEY = EdenRingBiomesDataProvider.registerLand(new WindValleyBiome());
    protected static final EdenRingBiome AIR_OCEAN = EdenRingBiomesDataProvider.registerVoid(new AirOceanBiome());
    protected static final EdenRingBiome GRAVILITE_DEBRIS_FIELD = EdenRingBiomesDataProvider.registerVoid(new GraviliteDebrisFieldBiome());
    protected static final EdenRingBiome SKY_COLONY = EdenRingBiomesDataProvider.registerVoid(new SkyColonyBiome());
    protected static final EdenRingBiome EMPTY_CAVE = EdenRingBiomesDataProvider.registerCave(new EmptyCaveBiome());
    protected static final EdenRingBiome ERODED_CAVE = EdenRingBiomesDataProvider.registerCave(new ErodedCaveBiome());
    protected static final EdenRingBiome OLD_MYCOTIC_FOREST = EdenRingBiomesDataProvider.registerSubBiome(new OldMycoticForestBiome(), MYCOTIC_FOREST);

    public EdenRingBiomesDataProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super((TagRegistry)TagManager.BIOMES, List.of("edenring"), output, registriesFuture);
    }

    public static void bootstrap(class_7891<class_1959> ctx) {
        BCLBiomeBuilder.registerUnbound(ctx);
    }

    public static void ensureStaticallyLoaded() {
    }

    private static EdenRingBiome registerBiome(EdenRingBiome.Config biomeConfig, BiomeAPI.BiomeType type) {
        return EdenRingBiome.create(biomeConfig, type);
    }

    private static EdenRingBiome registerLand(EdenRingBiome.Config biomeConfig) {
        EdenRingBiome biome = EdenRingBiomesDataProvider.registerBiome(biomeConfig, EdenBiomes.EDEN_LAND);
        BIOMES_LAND.add(biome);
        return biome;
    }

    private static EdenRingBiome registerVoid(EdenRingBiome.Config biomeConfig) {
        EdenRingBiome biome = EdenRingBiomesDataProvider.registerBiome(biomeConfig, EdenBiomes.EDEN_LAND);
        BIOMES_AIR.add(biome);
        return biome;
    }

    private static EdenRingBiome registerCave(EdenRingBiome.Config biomeConfig) {
        EdenRingBiome biome = EdenRingBiomesDataProvider.registerBiome(biomeConfig, EdenBiomes.EDEN_LAND);
        BIOMES_CAVE.add(biome);
        return biome;
    }

    private static EdenRingBiome registerSubBiome(EdenRingBiome.Config biomeConfig, EdenRingBiome parent) {
        EdenRingBiome biome = EdenRingBiome.createSubBiome(biomeConfig, parent);
        BiomeAPI.BiomeType type = parent.getIntendedType();
        if (type == EdenBiomes.EDEN_LAND) {
            BIOMES_LAND.add(biome);
        } else if (type == EdenBiomes.EDEN_VOID) {
            BIOMES_AIR.add(biome);
        } else if (type == EdenBiomes.EDEN_CAVE) {
            BIOMES_CAVE.add(biome);
        }
        return biome;
    }
}

