/*
 * Decompiled with CFR 0.152.
 */
package net.freedinner.items_displayed.entity.custom;

import java.util.List;
import java.util.function.Predicate;
import net.freedinner.items_displayed.item.ModItems;
import net.freedinner.items_displayed.item.ModTags;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1688;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5712;
import net.minecraft.class_8103;
import org.jetbrains.annotations.Nullable;

public class ItemDisplayEntity
extends class_1309 {
    private static final float DEFAULT_DISPLAY_ROTATION = 0.0f;
    public static final class_2940<Float> DISPLAY_ROTATION_TRACKER = class_2945.method_12791(ItemDisplayEntity.class, (class_2941)class_2943.field_13320);
    private static final Predicate<class_1297> RIDEABLE_MINECART_PREDICATE = entity -> entity instanceof class_1688 && ((class_1688)entity).method_7518() == class_1688.class_1689.field_7674;
    private static final String DISPLAYED_ITEM_NBT_KEY = "displayed_item";
    private static final String DISPLAY_ROTATION_NBT_KEY = "display_rotation";
    private class_1799 displayedItem = class_1799.field_8037;
    private float displayRotation = 0.0f;
    public long lastHitTime;

    public ItemDisplayEntity(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
        this.method_49477(0.0f);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DISPLAY_ROTATION_TRACKER, (Object)Float.valueOf(0.0f));
    }

    public void method_5773() {
        super.method_5773();
        float angle = ((Float)this.field_6011.method_12789(DISPLAY_ROTATION_TRACKER)).floatValue();
        if (this.displayRotation != angle) {
            this.setDisplayRotation(angle);
        }
    }

    public void setDisplayRotation(float angle) {
        this.displayRotation = angle;
        this.field_6011.method_12778(DISPLAY_ROTATION_TRACKER, (Object)Float.valueOf(angle));
    }

    public float getDisplayRotation() {
        return this.displayRotation;
    }

    protected float method_6031(float bodyRotation, float headRotation) {
        this.field_6220 = this.field_5982;
        this.field_6283 = this.method_36454();
        return 0.0f;
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (player.method_7325()) {
            return class_1269.field_5812;
        }
        if (player.method_37908().field_9236) {
            return class_1269.field_21466;
        }
        if (this.tryDisplayItem(player, itemStack, hand)) {
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private boolean tryDisplayItem(class_1657 player, class_1799 stack, class_1268 hand) {
        if (stack.method_7960()) {
            if (this.displayedItem.method_7960()) {
                return false;
            }
            player.method_6122(hand, this.displayedItem);
            this.method_5673(class_1304.field_6173, class_1799.field_8037);
            return true;
        }
        if (!this.displayedItem.method_7960() || !this.method_18397(stack)) {
            return false;
        }
        this.method_5673(class_1304.field_6173, stack.method_46651(1));
        if (!player.method_31549().field_7477) {
            stack.method_7934(1);
        }
        this.playPutSound();
        return true;
    }

    public boolean method_18397(class_1799 stack) {
        return stack.method_31573(ModTags.SHERDS) || stack.method_31573(ModTags.SMITHING_TEMPLATES);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        if (!this.displayedItem.method_7960()) {
            class_2487 heldItemNbt = new class_2487();
            this.displayedItem.method_7953(heldItemNbt);
            nbt.method_10566(DISPLAYED_ITEM_NBT_KEY, (class_2520)heldItemNbt);
        }
        if (this.displayRotation != 0.0f) {
            nbt.method_10548(DISPLAY_ROTATION_NBT_KEY, this.displayRotation);
        }
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10545(DISPLAYED_ITEM_NBT_KEY)) {
            class_2487 heldItemNbt = nbt.method_10562(DISPLAYED_ITEM_NBT_KEY);
            this.displayedItem = class_1799.method_7915((class_2487)heldItemNbt);
        }
        if (nbt.method_10545(DISPLAY_ROTATION_NBT_KEY)) {
            this.setDisplayRotation(nbt.method_10583(DISPLAY_ROTATION_NBT_KEY));
        }
    }

    public Iterable<class_1799> method_5877() {
        return class_2371.method_10213((int)1, (Object)this.displayedItem);
    }

    public Iterable<class_1799> method_5661() {
        return class_2371.method_10211();
    }

    public class_1799 method_6118(class_1304 slot) {
        return slot == class_1304.field_6173 ? this.displayedItem : class_1799.field_8037;
    }

    public void method_5673(class_1304 slot, class_1799 stack) {
        this.method_37410(stack);
        if (slot == class_1304.field_6173) {
            class_1799 oldStack = this.displayedItem;
            this.displayedItem = stack;
            this.method_6116(slot, oldStack, stack);
        }
    }

    public class_1306 method_6068() {
        return class_1306.field_6183;
    }

    public void method_18382() {
        double x = this.method_23317();
        double y = this.method_23318();
        double z = this.method_23321();
        super.method_18382();
        this.method_5814(x, y, z);
    }

    public boolean method_5810() {
        return false;
    }

    protected void method_6087(class_1297 entity) {
    }

    protected void method_6070() {
        List otherEntities = this.method_37908().method_8333((class_1297)this, this.method_5829(), RIDEABLE_MINECART_PREDICATE);
        for (class_1297 entity : otherEntities) {
            if (!(this.method_5858(entity) <= 0.2)) continue;
            entity.method_5697((class_1297)this);
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_37908().field_9236 || this.method_31481()) {
            return false;
        }
        if (source.method_48789(class_8103.field_42242)) {
            this.method_5768();
            return false;
        }
        if (this.method_5679(source)) {
            return false;
        }
        if (source.method_48789(class_8103.field_42249)) {
            this.breakAndDropItem(source);
            this.method_5768();
            return false;
        }
        if (source.method_48789(class_8103.field_42258)) {
            if (this.method_5809()) {
                this.updateHealth(source, 0.15f);
            } else {
                this.method_5639(5);
            }
            return false;
        }
        if (source.method_48789(class_8103.field_42259) && this.method_6032() > 0.5f) {
            this.updateHealth(source, 4.0f);
            return false;
        }
        boolean isProjectile = source.method_5526() instanceof class_1665;
        boolean hasPiercing = isProjectile && ((class_1665)source.method_5526()).method_7447() > 0;
        boolean fromPlayer = source.method_5525().equals("player");
        if (!fromPlayer && !isProjectile) {
            return false;
        }
        class_1297 attacker = source.method_5529();
        if (attacker instanceof class_1657) {
            class_1657 playerEntity = (class_1657)attacker;
            if (!playerEntity.method_31549().field_7476) {
                return false;
            }
        }
        if (source.method_5530()) {
            this.playBreakSound();
            this.spawnBreakParticles();
            this.method_5768();
            return hasPiercing;
        }
        long currTime = this.method_37908().method_8510();
        if (currTime - this.lastHitTime <= 5L || isProjectile) {
            this.breakAndDropItem(source);
            this.spawnBreakParticles();
            this.method_5768();
        } else {
            this.method_37908().method_8421((class_1297)this, (byte)32);
            this.method_32875(class_5712.field_28736, source.method_5529());
            this.lastHitTime = currTime;
        }
        return true;
    }

    public void method_5711(byte status) {
        if (status == 32) {
            if (this.method_37908().field_9236) {
                this.method_37908().method_8486(this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14897, this.method_5634(), 0.3f, 1.0f, false);
                this.lastHitTime = this.method_37908().method_8510();
            }
        } else {
            super.method_5711(status);
        }
    }

    public boolean method_5640(double distance) {
        double d;
        double d2 = this.method_5829().method_995() * 4.0;
        if (Double.isNaN(d2) || d2 == 0.0) {
            d2 = 4.0;
        }
        return distance < d * (d2 *= 64.0);
    }

    private void spawnBreakParticles() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            class_2388 particles = new class_2388(class_2398.field_11217, class_2246.field_10126.method_9564());
            serverWorld.method_14199((class_2394)particles, this.method_23317(), this.method_23323(0.6666666666666666), this.method_23321(), 10, (double)(this.method_17681() / 4.0f), (double)(this.method_17682() / 4.0f), (double)(this.method_17681() / 4.0f), 0.05);
        }
    }

    private void updateHealth(class_1282 damageSource, float amount) {
        float f = this.method_6032() - amount;
        if (f <= 0.5f) {
            this.onBreak(damageSource);
            this.method_5768();
        } else {
            this.method_6033(f);
            this.method_32875(class_5712.field_28736, damageSource.method_5529());
        }
    }

    private void breakAndDropItem(class_1282 damageSource) {
        class_1799 itemStack = new class_1799((class_1935)ModItems.ITEM_DISPLAY);
        class_2248.method_9577((class_1937)this.method_37908(), (class_2338)this.method_24515(), (class_1799)itemStack);
        this.onBreak(damageSource);
    }

    private void onBreak(class_1282 damageSource) {
        this.playBreakSound();
        this.method_16080(damageSource);
        if (!this.displayedItem.method_7960()) {
            class_2248.method_9577((class_1937)this.method_37908(), (class_2338)this.method_24515(), (class_1799)this.displayedItem);
            this.displayedItem = class_1799.field_8037;
        }
    }

    private void playBreakSound() {
        this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_15118, this.method_5634(), 1.0f, 1.0f);
    }

    private void playPutSound() {
        this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_40975, this.method_5634(), 1.0f, 1.0f);
    }

    public void method_5768() {
        this.method_5650(class_1297.class_5529.field_26998);
        this.method_32876(class_5712.field_37676);
    }

    public boolean method_5698(class_1297 attacker) {
        return attacker instanceof class_1657 && !this.method_37908().method_8505((class_1657)attacker, this.method_24515());
    }

    public class_1309.class_6823 method_39760() {
        return new class_1309.class_6823(class_3417.field_15186, class_3417.field_15186);
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_14897;
    }

    @Nullable
    protected class_3414 method_6002() {
        return class_3417.field_15118;
    }

    public void method_5800(class_3218 world, class_1538 lightning) {
    }

    public boolean method_6086() {
        return false;
    }

    public boolean method_6102() {
        return false;
    }

    public class_1799 method_31480() {
        return new class_1799((class_1935)ModItems.ITEM_DISPLAY);
    }
}

