/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.terrascript.parser.lang.operations.statements;

import com.dfsek.terra.addons.terrascript.lib.jafama.FastMath;
import com.dfsek.terra.addons.terrascript.parser.lang.ImplementationArguments;
import com.dfsek.terra.addons.terrascript.parser.lang.Returnable;
import com.dfsek.terra.addons.terrascript.parser.lang.Scope;
import com.dfsek.terra.addons.terrascript.parser.lang.operations.BinaryOperation;
import com.dfsek.terra.addons.terrascript.tokenizer.Position;

public class NotEqualsStatement
extends BinaryOperation<Object, Boolean> {
    public NotEqualsStatement(Returnable<Object> left, Returnable<Object> right, Position position) {
        super(left, right, position);
    }

    @Override
    public Boolean apply(ImplementationArguments implementationArguments, Scope scope) {
        return this.applyBoolean(implementationArguments, scope);
    }

    @Override
    public boolean applyBoolean(ImplementationArguments implementationArguments, Scope scope) {
        Object leftValue = this.left.apply(implementationArguments, scope);
        Object rightValue = this.right.apply(implementationArguments, scope);
        if (leftValue instanceof Number) {
            Number l = (Number)leftValue;
            if (rightValue instanceof Number) {
                Number r = (Number)rightValue;
                return FastMath.abs(l.doubleValue() - r.doubleValue()) > 1.0E-5;
            }
        }
        return !leftValue.equals(rightValue);
    }

    @Override
    public Returnable.ReturnType returnType() {
        return Returnable.ReturnType.BOOLEAN;
    }
}

