/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.terrascript.parser.lang;

import com.dfsek.terra.addons.terrascript.lib.jafama.FastMath;
import com.dfsek.terra.addons.terrascript.parser.lang.Returnable;
import com.dfsek.terra.api.util.generic.pair.Pair;
import java.util.HashMap;
import java.util.Map;

public class Scope {
    private final double[] num;
    private final boolean[] bool;
    private final String[] str;

    private Scope(int numSize, int boolSize, int strSize) {
        this.num = new double[numSize];
        this.bool = new boolean[boolSize];
        this.str = new String[strSize];
    }

    public double getNum(int index) {
        return this.num[index];
    }

    public boolean getBool(int index) {
        return this.bool[index];
    }

    public String getStr(int index) {
        return this.str[index];
    }

    public void setNum(int index, double value) {
        this.num[index] = value;
    }

    public void setBool(int index, boolean value) {
        this.bool[index] = value;
    }

    public void setStr(int index, String value) {
        this.str[index] = value;
    }

    public static final class ScopeBuilder {
        private final Map<String, Pair<Integer, Returnable.ReturnType>> indices;
        private int numSize;
        private int boolSize;
        private int strSize = 0;
        private ScopeBuilder parent;

        public ScopeBuilder() {
            this.indices = new HashMap<String, Pair<Integer, Returnable.ReturnType>>();
        }

        private ScopeBuilder(ScopeBuilder parent) {
            this.parent = parent;
            this.numSize = parent.numSize;
            this.boolSize = parent.boolSize;
            this.strSize = parent.strSize;
            this.indices = new HashMap<String, Pair<Integer, Returnable.ReturnType>>(parent.indices);
        }

        public Scope build() {
            return new Scope(this.numSize, this.boolSize, this.strSize);
        }

        public ScopeBuilder sub() {
            return new ScopeBuilder(this);
        }

        private String check(String id) {
            if (this.indices.containsKey(id)) {
                throw new IllegalArgumentException("Variable with ID " + id + " already registered.");
            }
            return id;
        }

        public int num(String id) {
            int num = this.numSize++;
            this.indices.put(this.check(id), (Pair<Integer, Returnable.ReturnType>)Pair.of((Object)num, (Object)((Object)Returnable.ReturnType.NUMBER)));
            this.updateNumSize(this.numSize);
            return num;
        }

        public int str(String id) {
            int str = this.strSize++;
            this.indices.put(this.check(id), (Pair<Integer, Returnable.ReturnType>)Pair.of((Object)str, (Object)((Object)Returnable.ReturnType.STRING)));
            this.updateStrSize(this.strSize);
            return str;
        }

        public int bool(String id) {
            int bool = this.boolSize++;
            this.indices.put(this.check(id), (Pair<Integer, Returnable.ReturnType>)Pair.of((Object)bool, (Object)((Object)Returnable.ReturnType.BOOLEAN)));
            this.updateBoolSize(this.boolSize);
            return bool;
        }

        private void updateBoolSize(int size) {
            this.boolSize = FastMath.max(this.boolSize, size);
            if (this.parent != null) {
                this.parent.updateBoolSize(size);
            }
        }

        private void updateNumSize(int size) {
            this.numSize = FastMath.max(this.numSize, size);
            if (this.parent != null) {
                this.parent.updateNumSize(size);
            }
        }

        private void updateStrSize(int size) {
            this.strSize = FastMath.max(this.strSize, size);
            if (this.parent != null) {
                this.parent.updateStrSize(size);
            }
        }

        public int getIndex(String id) {
            return (Integer)this.indices.get(id).getLeft();
        }

        public Returnable.ReturnType getType(String id) {
            return (Returnable.ReturnType)((Object)this.indices.get(id).getRight());
        }

        public boolean contains(String id) {
            return this.indices.containsKey(id);
        }
    }
}

