/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.nethervinery.registry;

import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.class_1291;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import satisfyu.nethervinery.NetherVinery;
import satisfyu.nethervinery.effect.GravediggerEffect;
import satisfyu.nethervinery.effect.HearthstoneEffect;
import satisfyu.nethervinery.effect.ImprovedGravediggerEffect;
import satisfyu.nethervinery.effect.ImprovedHearthstoneEffect;
import satisfyu.nethervinery.effect.NetheriteEffect;
import satisfyu.nethervinery.util.NetherVineryIdentifier;

public class NetherEffects {
    private static final DeferredRegister<class_1291> MOB_EFFECTS = DeferredRegister.create((String)"nethervinery", (class_5321)class_7924.field_41208);
    private static final Registrar<class_1291> MOB_EFFECTS_REGISTRAR = MOB_EFFECTS.getRegistrar();
    public static final RegistrySupplier<class_1291> GRAVEDIGGER = NetherEffects.registerEffect("gravedigger", GravediggerEffect::new);
    public static final RegistrySupplier<class_1291> HEARTHSTONE = NetherEffects.registerEffect("hearthstone", HearthstoneEffect::new);
    public static final RegistrySupplier<class_1291> IMPROVED_GRAVEDIGGER = NetherEffects.registerEffect("improved_gravedigger", ImprovedGravediggerEffect::new);
    public static final RegistrySupplier<class_1291> IMPROVED_HEARTHSTONE = NetherEffects.registerEffect("improved_hearthstone", ImprovedHearthstoneEffect::new);
    public static final RegistrySupplier<class_1291> NETHERITE = NetherEffects.registerEffect("netherite", NetheriteEffect::new);

    private static RegistrySupplier<class_1291> registerEffect(String name, Supplier<class_1291> effect) {
        if (Platform.isForge()) {
            return MOB_EFFECTS.register(name, effect);
        }
        return MOB_EFFECTS_REGISTRAR.register((class_2960)new NetherVineryIdentifier(name), effect);
    }

    public static void init() {
        NetherVinery.LOGGER.debug("Mob effects");
        MOB_EFFECTS.register();
    }
}

