/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.util.biome;

import grondag.canvas.terrain.region.input.InputRegion;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1920;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import org.jetbrains.annotations.Nullable;

public final class BiomeRetriever {
    private static final Provider PROVIDER = BiomeRetriever.createProvider();

    private static Provider createProvider() {
        ClassLoader classLoader = BiomeRetriever.class.getClassLoader();
        if (FabricLoader.getInstance().isModLoaded("canvas")) {
            try {
                Class<?> inputRegionClass = Class.forName("grondag.canvas.terrain.region.input.InputRegion", false, classLoader);
                inputRegionClass.getMethod("getBiome", class_2338.class);
                return BiomeRetriever::getBiomeByInputRegion;
            }
            catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
        }
        return BiomeRetriever::getBiomeByAPI;
    }

    @Nullable
    public static class_1959 getBiome(class_1920 blockView, class_2338 pos) {
        return PROVIDER.getBiome(blockView, pos);
    }

    public static void init() {
    }

    @Nullable
    private static class_1959 getBiomeByAPI(class_1920 blockView, class_2338 pos) {
        if (blockView.hasBiomes()) {
            return (class_1959)blockView.getBiomeFabric(pos).comp_349();
        }
        return null;
    }

    @Nullable
    private static class_1959 getBiomeByInputRegion(class_1920 blockView, class_2338 pos) {
        if (blockView instanceof InputRegion) {
            InputRegion inputRegion = (InputRegion)blockView;
            return inputRegion.getBiome(pos);
        }
        return BiomeRetriever.getBiomeByAPI(blockView, pos);
    }

    private static interface Provider {
        @Nullable
        public class_1959 getBiome(class_1920 var1, class_2338 var2);
    }
}

