/*
 * Decompiled with CFR 0.152.
 */
package fuzs.hangglider.client;

import fuzs.hangglider.HangGlider;
import fuzs.hangglider.client.handler.ElytraEquippedHandler;
import fuzs.hangglider.client.handler.FovModifierHandler;
import fuzs.hangglider.client.handler.GlidingCameraHandler;
import fuzs.hangglider.client.handler.GlidingCrouchHandler;
import fuzs.hangglider.client.init.ModClientRegistry;
import fuzs.hangglider.client.model.GliderModel;
import fuzs.hangglider.client.renderer.entity.layers.GliderLayer;
import fuzs.hangglider.helper.PlayerGlidingHelper;
import fuzs.hangglider.init.ModRegistry;
import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.core.v1.context.ItemModelPropertiesContext;
import fuzs.puzzleslib.api.client.core.v1.context.LayerDefinitionsContext;
import fuzs.puzzleslib.api.client.core.v1.context.LivingEntityRenderLayersContext;
import fuzs.puzzleslib.api.client.event.v1.ClientTickEvents;
import fuzs.puzzleslib.api.client.event.v1.ComputeCameraAnglesCallback;
import fuzs.puzzleslib.api.client.event.v1.ComputeFovModifierCallback;
import fuzs.puzzleslib.api.client.event.v1.RenderGuiCallback;
import fuzs.puzzleslib.api.client.event.v1.RenderHandCallback;
import fuzs.puzzleslib.api.client.event.v1.RenderPlayerEvents;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1935;
import net.minecraft.class_3883;
import net.minecraft.class_591;
import net.minecraft.class_742;

public class HangGliderClient
implements ClientModConstructor {
    public void onConstructMod() {
        HangGliderClient.registerHandlers();
    }

    private static void registerHandlers() {
        ComputeFovModifierCallback.EVENT.register(FovModifierHandler::onComputeFovModifier);
        ClientTickEvents.END.register(GlidingCameraHandler::onEndClientTick);
        ClientTickEvents.END.register(ElytraEquippedHandler.INSTANCE::onClientTick$End);
        RenderGuiCallback.EVENT.register(ElytraEquippedHandler.INSTANCE::onRenderGui);
        RenderPlayerEvents.BEFORE.register(GlidingCrouchHandler::onRenderPlayer$Pre);
        RenderPlayerEvents.AFTER.register(GlidingCrouchHandler::onRenderPlayer$Post);
        RenderHandCallback.EVENT.register(GlidingCameraHandler::onRenderHand);
        ComputeCameraAnglesCallback.EVENT.register(GlidingCameraHandler::onComputeCameraRoll);
    }

    public void onRegisterLayerDefinitions(LayerDefinitionsContext context) {
        context.registerLayerDefinition(ModClientRegistry.GLIDER, GliderModel::createLayer);
    }

    public void onRegisterLivingEntityRenderLayers(LivingEntityRenderLayersContext context) {
        context.registerRenderLayer(class_1299.field_6097, (renderLayerParent, context1) -> new GliderLayer((class_3883<class_742, class_591<class_742>>)renderLayerParent, context1.method_32170()));
    }

    public void onRegisterItemModelProperties(ItemModelPropertiesContext context) {
        context.registerItemProperty(HangGlider.id("deployed"), (itemStack, clientLevel, livingEntity, i) -> {
            if (!(livingEntity instanceof class_1657)) return 0.0f;
            class_1657 player = (class_1657)livingEntity;
            if (!PlayerGlidingHelper.isValidGlider(itemStack)) return 0.0f;
            if (!PlayerGlidingHelper.isGliderDeployed(player)) return 0.0f;
            if (PlayerGlidingHelper.getGliderInHand(player) != itemStack) return 0.0f;
            return 1.0f;
        }, new class_1935[]{(class_1935)ModRegistry.HANG_GLIDER_ITEM.get(), (class_1935)ModRegistry.REINFORCED_HANG_GLIDER_ITEM.get()});
        context.registerItemProperty(HangGlider.id("broken"), (itemStack, clientLevel, livingEntity, i) -> !PlayerGlidingHelper.isValidGlider(itemStack) ? 1.0f : 0.0f, new class_1935[]{(class_1935)ModRegistry.HANG_GLIDER_ITEM.get(), (class_1935)ModRegistry.REINFORCED_HANG_GLIDER_ITEM.get()});
    }
}

