/*
 * Decompiled with CFR 0.152.
 */
package me.cg360.mod.bridging.raytrace;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import me.cg360.mod.bridging.BridgingMod;
import me.cg360.mod.bridging.util.GameSupport;
import me.cg360.mod.bridging.util.Path;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_638;

public class PathTraversalHandler {
    private static final float MIN_DISTANCE = 1.0f;
    private static final double DIRECTION_SIMILARITY_THRESHOLD = 0.1;

    public static class_3545<class_2338, class_2350> getClosestAssistTarget(class_1657 player) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return null;
        }
        List<class_2338> path = PathTraversalHandler.getViewBlockPath(player);
        class_243 viewDirection = player.method_5828(1.0f);
        List<class_2350> validSides = PathTraversalHandler.getValidAssistSides(viewDirection);
        class_2350 validDirection = null;
        class_2338 validPos = null;
        for (class_2338 pos : path) {
            Optional<class_2350> firstValidDirection;
            if (!PathTraversalHandler.isBridgingPlacementAllowedAt(pos)) continue;
            class_243 collideMin = class_243.method_24954((class_2382)pos);
            class_243 collideMax = class_243.method_49273((class_2382)pos, (double)1.0, (double)1.0, (double)1.0);
            if (player.method_5829().method_993(collideMin, collideMax) || (firstValidDirection = validSides.stream().filter(dir -> PathTraversalHandler.canSideBeBuiltOffOf(pos, dir)).findFirst()).isEmpty()) continue;
            validDirection = firstValidDirection.get();
            validPos = pos;
            break;
        }
        if (validDirection == null || validPos == null) {
            return null;
        }
        return new class_3545(validPos, validDirection);
    }

    public static List<class_2338> getViewBlockPath(class_1657 player) {
        if (player == null) {
            return new ArrayList<class_2338>();
        }
        float eyeOffset = player.method_18381(player.method_18376());
        class_243 viewOrigin = player.method_19538().method_1031(0.0, (double)eyeOffset, 0.0);
        class_243 viewDirection = player.method_5828(1.0f);
        class_243 nearVec = viewDirection.method_1021(1.0);
        class_243 farVec = viewDirection.method_1021(GameSupport.getReach());
        class_2338 startPos = class_2338.method_49638((class_2374)viewOrigin.method_1019(nearVec));
        class_2338 endPos = class_2338.method_49638((class_2374)viewOrigin.method_1019(farVec));
        return Path.calculateBresenhamVoxels(startPos, endPos);
    }

    private static List<class_2350> getValidAssistSides(class_243 viewDirection) {
        LinkedList<class_2350> validSides = new LinkedList<class_2350>();
        for (class_2350 direction : class_2350.values()) {
            class_243 directionNormal = class_243.method_24954((class_2382)direction.method_10163());
            double similarity = viewDirection.method_1026(directionNormal);
            if (similarity < 0.1) continue;
            validSides.add(direction.method_10153());
        }
        return validSides;
    }

    private static boolean canSideBeBuiltOffOf(class_2338 placementTarget, class_2350 checkSide) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return false;
        }
        if (!BridgingMod.getConfig().getSupportedBridgeAxes().isDirectionEnabled(checkSide)) {
            return false;
        }
        class_2338 blockPlacingOffOf = placementTarget.method_10081(checkSide.method_10163());
        if (level.method_22347(blockPlacingOffOf)) {
            return false;
        }
        if (level.method_8320(blockPlacingOffOf).method_26204() instanceof class_2404) {
            return false;
        }
        return !level.method_8320(blockPlacingOffOf).method_45474();
    }

    private static boolean isBridgingPlacementAllowedAt(class_2338 placementTarget) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return false;
        }
        class_2680 target = level.method_8320(placementTarget);
        return BridgingMod.getConfig().isNonSolidReplaceEnabled() ? target.method_45474() : target.method_26215();
    }
}

