/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.oregrowth.content;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.data.condition.ModLoadedResourceCondition;
import com.supermartijn642.core.data.condition.ResourceCondition;
import com.supermartijn642.core.data.recipe.ConditionalRecipeSerializer;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.registry.Registries;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;

public abstract class OreGrowthRecipeGenerator
extends ResourceGenerator {
    private final Map<class_2960, OreGrowthRecipeBuilder> recipes = new HashMap<class_2960, OreGrowthRecipeBuilder>();

    public OreGrowthRecipeGenerator(String modid, ResourceCache cache) {
        super(modid, cache);
    }

    public OreGrowthRecipeBuilder recipe(String namespace, String location, class_2960 base, int stages, double spawnChance, double growthChance, class_2960 resultItem, int resultCount) {
        if (stages < 1 || stages > 4) {
            throw new RuntimeException("Invalid number of stages: '" + stages + "'!");
        }
        if (spawnChance <= 0.0 || spawnChance > 1.0) {
            throw new RuntimeException("Invalid spawn chance: '" + spawnChance + "'!");
        }
        if (growthChance <= 0.0 || growthChance > 1.0) {
            throw new RuntimeException("Invalid growth chance: '" + growthChance + "'!");
        }
        if (resultCount <= 0) {
            throw new RuntimeException("Invalid result count '" + resultCount + "'!");
        }
        class_2960 identifier = new class_2960(namespace, location);
        if (this.recipes.containsKey(identifier)) {
            throw new RuntimeException("Duplicate recipe for location '" + identifier + "'!");
        }
        OreGrowthRecipeBuilder recipe = new OreGrowthRecipeBuilder(base, stages, spawnChance, growthChance, resultItem, resultCount);
        this.recipes.put(identifier, recipe);
        this.cache.trackToBeGeneratedResource(ResourceType.DATA, namespace, "recipes", location, ".json");
        return recipe;
    }

    public OreGrowthRecipeBuilder recipe(String location, class_2248 base, int stages, double spawnChance, double growthChance, class_1792 result, int resultCount) {
        return this.recipe(this.modid, location, Registries.BLOCKS.getIdentifier((Object)base), stages, spawnChance, growthChance, Registries.ITEMS.getIdentifier((Object)result), resultCount);
    }

    public OreGrowthRecipeBuilder recipe(String location, class_2248 base, int stages, double spawnChance, double growthChance, class_1792 result) {
        return this.recipe(location, base, stages, spawnChance, growthChance, result, 1);
    }

    public OreGrowthRecipeBuilder modIntegration(String modid, String base, int stages, double spawnChance, double growthChance, class_2960 result, int resultCount) {
        class_2960 baseIdentifier = base.contains(":") ? new class_2960(base) : new class_2960(modid, base);
        return this.recipe(this.modid, modid + "_" + baseIdentifier.method_12832() + "_growth", baseIdentifier, stages, spawnChance, growthChance, result, resultCount).modLoadedCondition(modid);
    }

    public OreGrowthRecipeBuilder modIntegration(String modid, String base, int stages, double spawnChance, double growthChance, String result, int resultCount) {
        class_2960 resultIdentifier = result.contains(":") ? new class_2960(result) : new class_2960(modid, result);
        return this.modIntegration(modid, base, stages, spawnChance, growthChance, resultIdentifier, resultCount);
    }

    public OreGrowthRecipeBuilder modIntegration(String modid, String base, int stages, double spawnChance, double growthChance, String result) {
        return this.modIntegration(modid, base, stages, spawnChance, growthChance, result, 1);
    }

    public OreGrowthRecipeBuilder modIntegration(String modid, String base, int stages, double spawnChance, double growthChance, class_1792 result) {
        return this.modIntegration(modid, base, stages, spawnChance, growthChance, Registries.ITEMS.getIdentifier((Object)result), 1);
    }

    public void save() {
        for (Map.Entry<class_2960, OreGrowthRecipeBuilder> entry : this.recipes.entrySet()) {
            OreGrowthRecipeBuilder recipe = entry.getValue();
            JsonObject json = new JsonObject();
            json.addProperty("type", "oregrowth:ore_growth");
            json.addProperty("base", recipe.base.toString());
            json.addProperty("stages", (Number)recipe.stages);
            json.addProperty("spawn_chance", (Number)recipe.spawnChance);
            json.addProperty("growth_chance", (Number)recipe.growthChance);
            JsonObject itemJson = new JsonObject();
            itemJson.addProperty("item", recipe.output.toString());
            itemJson.addProperty("count", (Number)recipe.outputCount);
            json.add("result", (JsonElement)itemJson);
            ArrayList<ResourceCondition> conditions = recipe.conditions;
            if (!conditions.isEmpty()) {
                json = ConditionalRecipeSerializer.wrapRecipe((JsonObject)json, conditions);
            }
            class_2960 location = entry.getKey();
            this.cache.saveJsonResource(ResourceType.DATA, json, location.method_12836(), "recipes", location.method_12832() + ".json");
        }
    }

    public static class OreGrowthRecipeBuilder {
        private final class_2960 base;
        private final int stages;
        private final double spawnChance;
        private final double growthChance;
        private final class_2960 output;
        private final int outputCount;
        private final ArrayList<ResourceCondition> conditions = new ArrayList();

        public OreGrowthRecipeBuilder(class_2960 base, int stages, double spawnChance, double growthChance, class_2960 output, int outputCount) {
            this.base = base;
            this.stages = stages;
            this.spawnChance = spawnChance;
            this.growthChance = growthChance;
            this.output = output;
            this.outputCount = outputCount;
        }

        public OreGrowthRecipeBuilder condition(ResourceCondition condition) {
            this.conditions.add(condition);
            return this;
        }

        public OreGrowthRecipeBuilder modLoadedCondition(String modid) {
            return this.condition((ResourceCondition)new ModLoadedResourceCondition(modid));
        }
    }
}

