/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.oregrowth.content;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.oregrowth.OreGrowth;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5455;

public class OreGrowthRecipe
implements class_1860<class_1263> {
    public static final Serializer SERIALIZER = new Serializer();
    private final class_2960 identifier;
    private final class_2248 base;
    private final int stages;
    private final double spawnChance;
    private final double growthChance;
    private final class_1799 output;

    public OreGrowthRecipe(class_2960 identifier, class_2248 base, int stages, double spawnChance, double growthChance, class_1799 output) {
        this.identifier = identifier;
        this.base = base;
        this.stages = stages;
        this.spawnChance = spawnChance;
        this.growthChance = growthChance;
        this.output = output;
    }

    public class_2248 base() {
        return this.base;
    }

    public int stages() {
        return this.stages;
    }

    public double spawnChance() {
        return this.spawnChance;
    }

    public double growthChance() {
        return this.growthChance;
    }

    public class_1799 output() {
        return this.output.method_7972();
    }

    public boolean method_8115(class_1263 container, class_1937 level) {
        return false;
    }

    public class_1799 method_8116(class_1263 container, class_5455 registryAccess) {
        return class_1799.field_8037;
    }

    public boolean method_8113(int width, int height) {
        return false;
    }

    public class_1799 method_8110(class_5455 registryAccess) {
        return class_1799.field_8037;
    }

    public class_2960 method_8114() {
        return this.identifier;
    }

    public class_1865<?> method_8119() {
        return SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return OreGrowth.ORE_GROWTH_RECIPE_TYPE;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", "oregrowth:ore_growth");
        json.addProperty("base", Registries.BLOCKS.getIdentifier((Object)this.base).toString());
        json.addProperty("stages", (Number)this.stages);
        json.addProperty("spawn_chance", (Number)this.spawnChance);
        json.addProperty("growth_chance", (Number)this.growthChance);
        JsonObject itemJson = new JsonObject();
        itemJson.addProperty("item", Registries.ITEMS.getIdentifier((Object)this.output.method_7909()).toString());
        itemJson.addProperty("count", (Number)this.output.method_7947());
        json.add("result", (JsonElement)itemJson);
        return json;
    }

    private static class Serializer
    implements class_1865<OreGrowthRecipe> {
        private Serializer() {
        }

        public OreGrowthRecipe fromJson(class_2960 identifier, JsonObject json) {
            class_2960 blockIdentifier = new class_2960(class_3518.method_15265((JsonObject)json, (String)"base"));
            if (!Registries.BLOCKS.hasIdentifier(blockIdentifier)) {
                throw new JsonParseException("Unknown block '" + blockIdentifier + "'!");
            }
            class_2248 base = (class_2248)Registries.BLOCKS.getValue(blockIdentifier);
            if (base == class_2246.field_10124 || base == class_2246.field_10543 || base == class_2246.field_10243) {
                throw new JsonParseException("Got AIR block for identifier '" + blockIdentifier + "'!");
            }
            int stages = class_3518.method_15260((JsonObject)json, (String)"stages");
            if (stages < 1 || stages > 4) {
                throw new JsonParseException("Invalid number of stages: '" + stages + "'!");
            }
            double spawnChance = class_3518.method_34927((JsonObject)json, (String)"spawn_chance");
            if (spawnChance <= 0.0 || spawnChance > 1.0) {
                throw new JsonParseException("Invalid spawn chance: '" + spawnChance + "'!");
            }
            double growthChance = class_3518.method_34927((JsonObject)json, (String)"growth_chance");
            if (growthChance <= 0.0 || growthChance > 1.0) {
                throw new JsonParseException("Invalid growth chance: '" + growthChance + "'!");
            }
            class_1799 output = class_1869.method_35228((JsonObject)json.getAsJsonObject("result"));
            if (output.method_7960()) {
                throw new JsonParseException("Invalid output '" + output + "'!");
            }
            return new OreGrowthRecipe(identifier, base, stages, spawnChance, growthChance, output);
        }

        public OreGrowthRecipe fromNetwork(class_2960 identifier, class_2540 buffer) {
            class_2960 blockIdentifier = buffer.method_10810();
            if (!Registries.BLOCKS.hasIdentifier(blockIdentifier)) {
                throw new IllegalArgumentException("Unknown block '" + blockIdentifier + "'!");
            }
            class_2248 base = (class_2248)Registries.BLOCKS.getValue(blockIdentifier);
            if (base == class_2246.field_10124 || base == class_2246.field_10543 || base == class_2246.field_10243) {
                throw new IllegalArgumentException("Got AIR block for identifier '" + blockIdentifier + "'!");
            }
            int stages = buffer.readInt();
            if (stages < 1 || stages > 4) {
                throw new IllegalArgumentException("Invalid number of stages: '" + stages + "'!");
            }
            double spawnChance = buffer.readDouble();
            if (spawnChance <= 0.0 || spawnChance > 1.0) {
                throw new IllegalArgumentException("Invalid spawn chance: '" + spawnChance + "'!");
            }
            double growthChance = buffer.readDouble();
            if (growthChance <= 0.0 || growthChance > 1.0) {
                throw new IllegalArgumentException("Invalid growth chance: '" + growthChance + "'!");
            }
            class_1799 output = buffer.method_10819();
            if (output.method_7960()) {
                throw new IllegalArgumentException("Invalid output '" + output + "'!");
            }
            return new OreGrowthRecipe(identifier, base, stages, spawnChance, growthChance, output);
        }

        public void toNetwork(class_2540 buffer, OreGrowthRecipe recipe) {
            buffer.method_10812(Registries.BLOCKS.getIdentifier((Object)recipe.base));
            buffer.writeInt(recipe.stages);
            buffer.writeDouble(recipe.spawnChance);
            buffer.writeDouble(recipe.growthChance);
            buffer.method_10793(recipe.output);
        }
    }
}

