/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.oregrowth.content;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.util.Holder;
import com.supermartijn642.core.util.Pair;
import com.supermartijn642.oregrowth.content.OreGrowthBlock;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_296;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_806;
import net.minecraft.class_809;
import org.jetbrains.annotations.Nullable;

public class OreGrowthBlockBakedModel
implements class_1087 {
    private static final int BLOCK_VERTEX_DATA_UV_OFFSET = OreGrowthBlockBakedModel.findUVOffset(class_290.field_1590, class_296.class_298.field_1636);
    private static final int BLOCK_VERTEX_DATA_TINT_OFFSET = OreGrowthBlockBakedModel.findUVOffset(class_290.field_1590, class_296.class_298.field_1632);
    private static final class_2350[] MODEL_DIRECTIONS = new class_2350[]{class_2350.field_11036, class_2350.field_11033, class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039, null};
    private final class_1087 original;
    private final Map<class_2350, Map<class_2248, List<class_777>>> quadCache = new HashMap<class_2350, Map<class_2248, List<class_777>>>();
    private final Map<class_2248, List<class_777>> directionlessQuadCache = new HashMap<class_2248, List<class_777>>();
    private final ThreadLocal<class_2248> baseBlock = new ThreadLocal();

    public OreGrowthBlockBakedModel(class_1087 original) {
        this.original = original;
        for (class_2350 direction : class_2350.values()) {
            this.quadCache.put(direction, new HashMap());
        }
    }

    public void withContext(class_2248 baseBlock, Runnable runnable) {
        this.baseBlock.set(baseBlock);
        runnable.run();
        this.baseBlock.set(null);
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        class_2338 basePos = pos.method_10093((class_2350)state.method_11654(OreGrowthBlock.FACE));
        class_2248 base = blockView.method_8320(basePos).method_26204();
        this.baseBlock.set(base);
        context.bakedModelConsumer().accept((class_1087)this, state);
        this.baseBlock.set(null);
    }

    public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
        context.bakedModelConsumer().accept((class_1087)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 side, class_5819 random) {
        List<class_777> quads;
        Map<class_2248, List<class_777>> cache;
        class_2248 base = this.baseBlock.get();
        if (base == null) {
            return this.original.method_4707(state, side, random);
        }
        Map<class_2248, List<class_777>> map = cache = side == null ? this.directionlessQuadCache : this.quadCache.get(side);
        synchronized (map) {
            quads = cache.get(base);
        }
        if (quads == null) {
            quads = this.remapQuads(this.original.method_4707(state, side, random), base, random);
            map = cache;
            synchronized (map) {
                if (!cache.containsKey(base)) {
                    cache.put(base, quads);
                } else {
                    quads = cache.get(base);
                }
            }
        }
        if (quads == null) {
            throw new IllegalStateException("Tried returning null list from OreGrowthBlockBakedModel#getQuads for side '" + side + "' and base '" + base + "'!");
        }
        return quads;
    }

    private List<class_777> remapQuads(List<class_777> originalQuads, class_2248 baseBlock, class_5819 random) {
        class_2680 baseState = baseBlock.method_9564();
        class_1087 baseModel = ClientUtils.getBlockRenderer().method_3349(baseState);
        if (!baseModel.isVanillaAdapter()) {
            return originalQuads;
        }
        HashMap spriteCounts = new HashMap();
        for (class_2350 cullFace : MODEL_DIRECTIONS) {
            baseModel.method_4707(baseState, cullFace, random).forEach(quad -> {
                class_1058 sprite = quad.method_35788();
                Holder count = (Holder)spriteCounts.computeIfAbsent(sprite, s -> Pair.of((Object)new Holder((Object)0), (Object)quad.method_3359())).left();
                count.set((Object)((Integer)count.get() + 1));
            });
        }
        if (spriteCounts.isEmpty()) {
            return originalQuads;
        }
        class_1058 sprite = null;
        int tint = 0;
        int count = 0;
        for (Map.Entry entry : spriteCounts.entrySet()) {
            if ((Integer)((Holder)((Pair)entry.getValue()).left()).get() <= count) continue;
            sprite = (class_1058)entry.getKey();
            tint = (Integer)((Pair)entry.getValue()).right();
        }
        class_1058 finalSprite = sprite;
        int n = tint;
        return originalQuads.stream().map(quad -> this.remapQuad((class_777)quad, finalSprite, finalTint)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected class_777 remapQuad(class_777 quad, class_1058 newSprite, int newTint) {
        class_1058 sprite = quad.method_35788();
        int[] vertexData = quad.method_3357();
        vertexData = Arrays.copyOf(vertexData, vertexData.length);
        int vertexSize = class_290.field_1590.method_1359();
        int vertices = vertexData.length / vertexSize;
        int uvOffset = BLOCK_VERTEX_DATA_UV_OFFSET / 4;
        int tintOffset = BLOCK_VERTEX_DATA_TINT_OFFSET / 4;
        for (int i = 0; i < vertices; ++i) {
            int offset = i * vertexSize;
            float u = Float.intBitsToFloat(vertexData[offset + uvOffset]);
            float newU = newSprite.method_4594() + (u - sprite.method_4594()) / (sprite.method_4577() - sprite.method_4594()) * (newSprite.method_4577() - newSprite.method_4594());
            vertexData[offset + uvOffset] = Float.floatToRawIntBits(newU);
            float v = Float.intBitsToFloat(vertexData[offset + uvOffset + 1]);
            float newV = newSprite.method_4593() + (v - sprite.method_4593()) / (sprite.method_4575() - sprite.method_4593()) * (newSprite.method_4575() - newSprite.method_4593());
            vertexData[offset + uvOffset + 1] = Float.floatToRawIntBits(newV);
            vertexData[offset + tintOffset] = newTint;
        }
        return new class_777(vertexData, quad.method_3359(), quad.method_3358(), quad.method_35788(), quad.method_24874());
    }

    private static int[] adjustVertexDataUV(int[] vertexData, int newU, int newV, class_1058 sprite) {
        int vertexSize = class_290.field_1590.method_1359();
        int vertices = vertexData.length / vertexSize;
        int uvOffset = BLOCK_VERTEX_DATA_UV_OFFSET / 4;
        for (int i = 0; i < vertices; ++i) {
            int offset = i * vertexSize + uvOffset;
            float width = sprite.method_4577() - sprite.method_4594();
            float u = Float.intBitsToFloat(vertexData[offset]) + width * (float)newU;
            vertexData[offset] = Float.floatToRawIntBits(u);
            float height = sprite.method_4575() - sprite.method_4593();
            float v = Float.intBitsToFloat(vertexData[offset + 1]) + height * (float)newV;
            vertexData[offset + 1] = Float.floatToRawIntBits(v);
        }
        return vertexData;
    }

    private static int findUVOffset(class_293 vertexFormat, class_296.class_298 vertexFormatElement) {
        int index;
        class_296 element = null;
        for (index = 0; index < vertexFormat.method_1357().size(); ++index) {
            class_296 el = (class_296)vertexFormat.method_1357().get(index);
            if (el.method_1382() != vertexFormatElement) continue;
            element = el;
            break;
        }
        if (index == vertexFormat.method_1357().size() || element == null) {
            throw new RuntimeException("Expected vertex format to have a '" + vertexFormat + "' attribute");
        }
        return vertexFormat.field_1597.getInt(index);
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public boolean method_4713() {
        return this.original.method_4713();
    }

    public class_809 method_4709() {
        return this.original.method_4709();
    }

    public class_806 method_4710() {
        return class_806.field_4292;
    }

    public boolean method_4708() {
        return this.original.method_4708();
    }

    public boolean method_4712() {
        return this.original.method_4712();
    }

    public boolean method_24304() {
        return this.original.method_24304();
    }

    public class_1058 method_4711() {
        return this.original.method_4711();
    }
}

