/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.oregrowth.compat;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.oregrowth.OreGrowth;
import com.supermartijn642.oregrowth.content.OreGrowthBlock;
import com.supermartijn642.oregrowth.content.OreGrowthBlockBakedModel;
import com.supermartijn642.oregrowth.content.OreGrowthRecipe;
import com.supermartijn642.oregrowth.content.OreGrowthRecipeManager;
import net.minecraft.class_1087;
import net.minecraft.class_124;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.Identifiers;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.IElement;

@WailaPlugin
public class OreGrowthWailaPlugin
implements IWailaPlugin {
    public void register(IWailaCommonRegistration registration) {
        super.register(registration);
    }

    public void registerClient(IWailaClientRegistration registration) {
        registration.registerBlockComponent(new IBlockComponentProvider(){

            public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
                class_2350 facing = (class_2350)accessor.getBlockState().method_11654(OreGrowthBlock.FACE);
                class_2248 base = accessor.getLevel().method_8320(accessor.getPosition().method_10093(facing)).method_26204();
                tooltip.remove(Identifiers.CORE_OBJECT_NAME);
                tooltip.add(0, (class_2561)IThemeHelper.get().title((Object)TextComponents.translation((String)"oregrowth.ore_growth_block.adjusted_name", (Object[])new Object[]{base.method_9518()}).get()));
                OreGrowthRecipe recipe = OreGrowthRecipeManager.getRecipeFor(base);
                if (recipe != null) {
                    float growth = (float)((Integer)accessor.getBlockState().method_11654((class_2769)OreGrowthBlock.STAGE)).intValue() / (float)recipe.stages() * 100.0f;
                    class_5250 growthText = TextComponents.string((String)String.format("%.0f%%", Float.valueOf(growth))).color(growth < 100.0f ? class_124.field_1068 : class_124.field_1060).get();
                    tooltip.add((class_2561)TextComponents.translation((String)"oregrowth.ore_growth_block.growth_hint", (Object[])new Object[]{growthText}).get());
                }
            }

            public class_2960 getUid() {
                return new class_2960("oregrowth", "ore_growth_hint");
            }
        }, OreGrowthBlock.class);
        registration.registerBlockIcon(new IBlockComponentProvider(){

            @Nullable
            public IElement getIcon(BlockAccessor accessor, IPluginConfig config, final IElement currentIcon) {
                class_2680 state = accessor.getBlockState();
                class_2350 facing = (class_2350)state.method_11654(OreGrowthBlock.FACE);
                final class_2248 base = accessor.getLevel().method_8320(accessor.getPosition().method_10093(facing)).method_26204();
                return new Element(){

                    public class_241 getSize() {
                        return currentIcon.getSize();
                    }

                    public void render(class_332 guiGraphics, float x, float y, float maxX, float maxY) {
                        class_1087 model = ClientUtils.getItemRenderer().method_4012().method_3304(OreGrowth.ORE_GROWTH_BLOCK.method_8389());
                        if (model instanceof OreGrowthBlockBakedModel) {
                            ((OreGrowthBlockBakedModel)model).withContext(base, () -> currentIcon.render(guiGraphics, x, y, maxX, maxY));
                        } else {
                            currentIcon.render(guiGraphics, x, y, maxX, maxY);
                        }
                    }

                    @Nullable
                    public String getMessage() {
                        return currentIcon.getMessage();
                    }
                };
            }

            public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
            }

            public class_2960 getUid() {
                return new class_2960("oregrowth", "ore_growth_icon");
            }
        }, OreGrowthBlock.class);
    }
}

