/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.palette.palette;

import com.dfsek.terra.api.block.state.BlockState;
import com.dfsek.terra.api.noise.NoiseSampler;
import com.dfsek.terra.api.util.collection.ProbabilityCollection;
import com.dfsek.terra.api.world.chunk.generation.util.Palette;
import java.util.ArrayList;
import java.util.List;

public class PaletteImpl
implements Palette {
    private final List<PaletteLayer> pallet = new ArrayList<PaletteLayer>();
    private final NoiseSampler sampler;

    public PaletteImpl(NoiseSampler sampler) {
        this.sampler = sampler;
    }

    public Palette add(ProbabilityCollection<BlockState> m, int layers, NoiseSampler sampler) {
        for (int i = 0; i < layers; ++i) {
            this.pallet.add(new PaletteLayer(m, sampler));
        }
        return this;
    }

    public BlockState get(int layer, double x, double y, double z, long seed) {
        List<PaletteLayer> pl;
        PaletteLayer paletteLayer = layer > this.getSize() ? this.getLayers().get(this.getLayers().size() - 1) : (layer >= (pl = this.getLayers()).size() ? pl.get(pl.size() - 1) : pl.get(layer));
        NoiseSampler paletteSampler = paletteLayer.getSampler();
        return paletteLayer.get(paletteSampler == null ? this.sampler : paletteSampler, x, y, z, seed);
    }

    public int getSize() {
        return this.pallet.size();
    }

    public List<PaletteLayer> getLayers() {
        return this.pallet;
    }

    public static class PaletteLayer {
        private final NoiseSampler sampler;
        private final ProbabilityCollection<BlockState> collection;

        public PaletteLayer(ProbabilityCollection<BlockState> type, NoiseSampler sampler) {
            this.sampler = sampler;
            this.collection = type;
        }

        public BlockState get(NoiseSampler random, double x, double y, double z, long seed) {
            return (BlockState)this.collection.get(random, x, y, z, seed);
        }

        public NoiseSampler getSampler() {
            return this.sampler;
        }
    }
}

