/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.showmeyourskin.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import nl.enjarai.showmeyourskin.config.SyncedModConfig;

public class SyncedModConfigServer
implements SyncedModConfig {
    public static final Path CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("showmeyourskin-server.json");
    public static SyncedModConfigServer INSTANCE;
    private static final Gson GSON;
    public boolean allowNotShowInCombat = false;
    public boolean allowNotShowNameTag = false;

    public static void load() {
        INSTANCE = SyncedModConfigServer.loadConfigFile(CONFIG_FILE);
    }

    public void save() {
        this.saveConfigFile(CONFIG_FILE);
    }

    private static SyncedModConfigServer loadConfigFile(Path file) {
        SyncedModConfigServer config = null;
        if (Files.exists(file, new LinkOption[0])) {
            try (BufferedReader fileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file.toFile()), StandardCharsets.UTF_8));){
                config = (SyncedModConfigServer)GSON.fromJson((Reader)fileReader, SyncedModConfigServer.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Problem occurred when trying to load config: ", e);
            }
        }
        if (config == null) {
            config = new SyncedModConfigServer();
        }
        config.saveConfigFile(file);
        return config;
    }

    private void saveConfigFile(Path file) {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file.toFile()), StandardCharsets.UTF_8);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean allowNotShowInCombat() {
        return this.allowNotShowInCombat;
    }

    @Override
    public boolean allowNotShowNameTag() {
        return this.allowNotShowNameTag;
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().disableHtmlEscaping().create();
    }
}

