/*
 * Decompiled with CFR 0.152.
 */
package io.github.beeebea.fastmove.mixin;

import io.github.beeebea.fastmove.FastMove;
import io.github.beeebea.fastmove.IFastPlayer;
import io.github.beeebea.fastmove.MoveState;
import io.github.beeebea.fastmove.config.FastMoveConfig;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1656;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_8112;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309
implements IFastPlayer {
    @Shadow
    @Final
    private static Logger field_38197;
    @Shadow
    @Final
    private class_1656 field_7503;
    @Shadow
    protected class_1702 field_7493;
    @Unique
    private MoveState moveState = MoveState.NONE;
    @Unique
    private MoveState lastMoveState = MoveState.NONE;
    @Unique
    private class_243 bonusVelocity = class_243.field_1353;
    @Unique
    private int rollTickCounter = 0;
    @Unique
    private int wallRunCounter = 0;
    @Unique
    private class_243 lastWallDir = class_243.field_1353;
    @Unique
    private boolean isWallLeft = false;
    @Unique
    private int slideCooldown = 0;
    @Unique
    private int diveCooldown = 0;
    @Unique
    private class_2338 lastBlockPos = null;
    @Unique
    private boolean fastmove_lastSprintingState = false;

    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Shadow
    public abstract boolean method_7340();

    @Shadow
    protected abstract void method_7318();

    @Override
    public MoveState fastmove_getMoveState() {
        return this.moveState;
    }

    @Override
    public void fastmove_setMoveState(MoveState moveState) {
        this.moveState = moveState;
    }

    @Unique
    private void updateCurrentMoveState() {
        if (this.lastMoveState != this.moveState) {
            this.lastMoveState = this.moveState;
            if (this.moveState == MoveState.ROLLING) {
                this.rollTickCounter = 0;
                this.method_18380(class_4050.field_18079);
            }
            if (this.moveState == MoveState.PRONE) {
                this.rollTickCounter = 0;
                this.method_18380(class_4050.field_18079);
            }
            if (this.method_7340()) {
                FastMove.moveStateUpdater.setMoveState((class_1657)this, this.moveState);
            }
            FastMove.moveStateUpdater.setAnimationState((class_1657)this, this.moveState);
            this.method_7318();
            this.method_18382();
        }
    }

    @Unique
    private static class_243 fastmove_movementInputToVelocity(class_243 movementInput, double speed, float yaw) {
        double d = movementInput.method_1027();
        if (d < 1.0E-7) {
            return class_243.field_1353;
        }
        class_243 vec3d = (d > 1.0 ? movementInput.method_1029() : movementInput).method_1021(speed);
        double f = class_3532.method_15374((float)(yaw * ((float)Math.PI / 180)));
        double g = class_3532.method_15362((float)(yaw * ((float)Math.PI / 180)));
        return new class_243(vec3d.field_1352 * g - vec3d.field_1350 * f, vec3d.field_1351, vec3d.field_1350 * g + vec3d.field_1352 * f);
    }

    @Unique
    private static class_243 fastmove_velocityToMovementInput(class_243 velocity, float yaw) {
        double d = velocity.method_1027();
        if (d < 1.0E-7) {
            return class_243.field_1353;
        }
        float f = class_3532.method_15374((float)(yaw * ((float)Math.PI / 180)));
        float g = class_3532.method_15362((float)(yaw * ((float)Math.PI / 180)));
        class_243 unrotatedVec = new class_243(velocity.field_1352 * (double)g + velocity.field_1350 * (double)f, velocity.field_1351, -velocity.field_1352 * (double)f + velocity.field_1350 * (double)g);
        return unrotatedVec.method_1027() > 1.0 ? unrotatedVec.method_1029() : unrotatedVec;
    }

    @Unique
    private void fastmove_WallRun() {
        class_243 vel = this.method_18798();
        boolean hasWall = this.getWallDirection();
        if (this.moveState == MoveState.WALLRUNNING_LEFT || this.moveState == MoveState.WALLRUNNING_RIGHT) {
            if (!hasWall || this.method_24828()) {
                this.wallRunCounter = 0;
                this.moveState = MoveState.NONE;
            } else {
                ++this.wallRunCounter;
                this.method_5728(true);
                class_2338 wallBlockPos = this.method_24515().method_10059((class_2382)class_2338.method_49638((class_2374)this.lastWallDir));
                if (this.lastBlockPos == null || !this.lastBlockPos.equals((Object)wallBlockPos)) {
                    this.lastBlockPos = wallBlockPos;
                    this.method_5712(wallBlockPos, this.method_37908().method_8320(wallBlockPos));
                }
                class_243 flatVel = vel.method_18805(1.0, 0.0, 1.0);
                class_243 wallVel = this.isWallLeft ? flatVel.method_1029().method_1024(90.0f) : flatVel.method_1029().method_1024(-90.0f);
                MoveState moveState = this.moveState = !this.isWallLeft ? MoveState.WALLRUNNING_LEFT : MoveState.WALLRUNNING_RIGHT;
                if (PlayerEntityMixin.fastmove_velocityToMovementInput(flatVel, this.method_36454()).method_1026(this.lastWallDir) < 0.0) {
                    this.method_45319(wallVel.method_18805(-0.1, 0.0, -0.1));
                }
                this.method_45319(new class_243(0.0, -vel.field_1351 * (1.0 - (double)this.wallRunCounter / (double)FastMove.getConfig().getWallRunDurationTicks()), 0.0));
                this.bonusVelocity = class_243.field_1353;
                if (!FastMove.INPUT.ismoveUpKeyPressed()) {
                    double velocityMult = FastMove.getConfig().getWallRunSpeedBoostMultiplier();
                    this.method_45319(wallVel.method_18805(0.3 * velocityMult, 0.0, 0.3 * velocityMult).method_1019(new class_243(0.0, 0.4 * velocityMult, 0.0)));
                    this.moveState = MoveState.NONE;
                }
            }
        } else {
            this.wallRunCounter = 0;
            if (!this.method_24828() && FastMove.INPUT.ismoveUpKeyPressed() && hasWall && vel.field_1351 <= 0.0) {
                this.moveState = MoveState.WALLRUNNING_LEFT;
                this.field_7493.method_7583((float)FastMove.getConfig().getWallRunStaminaCost());
            }
        }
    }

    @Unique
    private boolean getWallDirection() {
        class_3965 upperRightHit;
        class_3965 upperLeftHit;
        class_243 flat = this.method_18798().method_18805(1.0, 0.0, 1.0);
        if (flat.method_1027() < 0.01) {
            return false;
        }
        flat = flat.method_1029();
        class_1937 world = this.method_37908();
        class_243 left = flat.method_1024(-90.0f).method_18805(0.5, 0.0, 0.5);
        class_243 right = flat.method_1024(90.0f).method_18805(0.5, 0.0, 0.5);
        class_3965 lowerLeftHit = world.method_17742(new class_3959(this.method_19538().method_1031(0.0, 0.2, 0.0), this.method_19538().method_1019(left), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
        if (lowerLeftHit.method_17783() == class_239.class_240.field_1332 && (upperLeftHit = world.method_17742(new class_3959(this.method_19538().method_1031(0.0, 1.5, 0.0), this.method_19538().method_1019(left), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this))).method_17783() == class_239.class_240.field_1332) {
            this.lastWallDir = this.method_24515().method_46558().method_1020(lowerLeftHit.method_17777().method_46558());
            this.isWallLeft = true;
            return true;
        }
        class_3965 lowerRightHit = world.method_17742(new class_3959(this.method_19538().method_1031(0.0, 0.2, 0.0), this.method_19538().method_1019(right), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
        if (lowerRightHit.method_17783() == class_239.class_240.field_1332 && (upperRightHit = world.method_17742(new class_3959(this.method_19538().method_1031(0.0, 1.5, 0.0), this.method_19538().method_1019(right), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this))).method_17783() == class_239.class_240.field_1332) {
            this.lastWallDir = this.method_24515().method_46558().method_1020(lowerRightHit.method_17777().method_46558());
            this.isWallLeft = false;
            return true;
        }
        this.lastWallDir = class_243.field_1353;
        return false;
    }

    @Unique
    private boolean fastmove_isValidForMovement(boolean canSwim, boolean canElytra) {
        return !(this.method_7325() || !canElytra && this.method_6128() || !canSwim && this.method_5799() || this.method_6101() || this.field_7503.field_7479);
    }

    @Inject(method={"getDimensions"}, at={@At(value="HEAD")}, cancellable=true)
    public void fastmove_getDimensions(class_4050 pose, CallbackInfoReturnable<class_4048> cir) {
        MoveState moveState = this.fastmove_getMoveState();
        if (moveState != null && moveState != MoveState.NONE) {
            cir.setReturnValue((Object)moveState.dimensions);
        }
    }

    @Inject(method={"getActiveEyeHeight"}, at={@At(value="HEAD")}, cancellable=true)
    public void fastmove_getActiveEyeHeight(class_4050 pose, class_4048 dimensions, CallbackInfoReturnable<Float> cir) {
        MoveState moveState = this.fastmove_getMoveState();
        if (moveState != null && moveState != MoveState.NONE) {
            cir.setReturnValue((Object)Float.valueOf(moveState.dimensions.field_18068 * 0.85f));
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void fastmove_tick(CallbackInfo info) {
        if (!FastMove.getConfig().enableFastMove) {
            return;
        }
        if (this.method_7340()) {
            if (this.field_7503.field_7479 || this.method_49694() != null) {
                this.moveState = MoveState.NONE;
                this.updateCurrentMoveState();
                return;
            }
            double bonusDecay = 0.9;
            if (this.moveState == MoveState.ROLLING) {
                ++this.rollTickCounter;
                if (this.rollTickCounter >= 10) {
                    this.rollTickCounter = 0;
                    this.moveState = FastMove.INPUT.ismoveDownKeyPressed() ? MoveState.PRONE : MoveState.NONE;
                }
                bonusDecay = 0.98;
            }
            if (this.moveState == MoveState.SLIDING && !FastMove.INPUT.ismoveDownKeyPressed()) {
                this.moveState = MoveState.NONE;
            }
            if (FastMove.getConfig().wallRunEnabled) {
                this.fastmove_WallRun();
            }
            this.method_45319(this.bonusVelocity);
            this.bonusVelocity = this.bonusVelocity.method_18805(bonusDecay, 0.0, bonusDecay);
        }
        this.updateCurrentMoveState();
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void fastmove_tick_tail(CallbackInfo info) {
        if (!FastMove.getConfig().enableFastMove) {
            return;
        }
        if (this.moveState == MoveState.PRONE || this.moveState == MoveState.ROLLING) {
            this.method_18380(class_4050.field_18079);
        }
        if (this.diveCooldown > 0) {
            --this.diveCooldown;
        }
        if (this.slideCooldown > 0) {
            --this.slideCooldown;
        }
    }

    @Inject(method={"travel"}, at={@At(value="HEAD")})
    private void fastmove_travel(class_243 movementInput, CallbackInfo info) {
        if (!this.method_7340() || !FastMove.getConfig().enableFastMove || this.field_7503.field_7479 || this.method_49694() != null) {
            return;
        }
        this.fastmove_lastSprintingState = this.method_5624();
        if (FastMove.INPUT.ismoveDownKeyPressed()) {
            if (!FastMove.INPUT.ismoveDownKeyPressedLastTick()) {
                FastMoveConfig conf = FastMove.getConfig();
                if (this.diveCooldown == 0 && conf.diveRollEnabled && !this.method_24828() && this.method_18798().method_18805(1.0, 0.0, 1.0).method_1027() > 0.05 && this.fastmove_isValidForMovement(conf.diveRollWhenSwimming, conf.diveRollWhenFlying)) {
                    this.diveCooldown = conf.getDiveRollCoolDown();
                    this.field_7493.method_7583((float)conf.getDiveRollStaminaCost());
                    this.moveState = MoveState.ROLLING;
                    this.bonusVelocity = PlayerEntityMixin.fastmove_movementInputToVelocity(new class_243(0.0, 0.0, 1.0), (double)0.1f * conf.getDiveRollSpeedBoostMultiplier(), this.method_36454());
                    this.method_5728(true);
                } else if (this.slideCooldown == 0 && conf.slideEnabled && this.fastmove_lastSprintingState && this.fastmove_isValidForMovement(false, false)) {
                    this.slideCooldown = conf.getSlideCoolDown();
                    this.field_7493.method_7583((float)conf.getSlideStaminaCost());
                    this.moveState = MoveState.SLIDING;
                    this.bonusVelocity = PlayerEntityMixin.fastmove_movementInputToVelocity(new class_243(0.0, 0.0, 1.0), (double)0.2f * conf.getSlideSpeedBoostMultiplier(), this.method_36454());
                    this.method_5728(true);
                }
            }
        } else if (this.moveState == MoveState.PRONE) {
            this.moveState = MoveState.NONE;
        }
    }

    @Inject(method={"adjustMovementForSneaking"}, at={@At(value="HEAD")}, cancellable=true)
    private void fastmove_adjustMovementForSneaking(class_243 movement, class_1313 type, CallbackInfoReturnable<class_243> cir) {
        if (this.method_7340() && (this.moveState == MoveState.ROLLING || this.moveState == MoveState.SLIDING)) {
            cir.setReturnValue((Object)movement);
        }
    }

    @Inject(method={"jump"}, at={@At(value="HEAD")})
    private void fastmove_jump(CallbackInfo info) {
        if (this.method_7340()) {
            this.method_5728(this.fastmove_lastSprintingState);
            if (this.moveState == MoveState.SLIDING || this.moveState == MoveState.PRONE) {
                this.moveState = MoveState.NONE;
            }
            if (this.moveState == MoveState.ROLLING) {
                this.moveState = MoveState.PRONE;
            }
        }
    }

    @Inject(method={"damage"}, at={@At(value="HEAD")}, cancellable=true)
    private void fastmove_damage(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (source.method_48792().comp_1246() == class_8112.field_42362 && this.moveState == MoveState.ROLLING) {
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }
}

