/*
 * Decompiled with CFR 0.152.
 */
package io.github.beeebea.fastmove.client;

import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import io.github.beeebea.fastmove.FastMove;
import io.github.beeebea.fastmove.IAnimatedPlayer;
import io.github.beeebea.fastmove.IFastPlayer;
import io.github.beeebea.fastmove.IMoveStateUpdater;
import io.github.beeebea.fastmove.MoveState;
import io.github.beeebea.fastmove.client.FastMoveInput;
import io.github.beeebea.fastmove.config.FastMoveConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.uku3lig.ukulib.config.ConfigManager;

public class FastMoveClient
extends FastMove
implements ClientModInitializer {
    private static final Map<String, KeyframeAnimation> _animations = new HashMap<String, KeyframeAnimation>();
    public static final ConfigManager<FastMoveConfig> CONFIG_MANAGER = ConfigManager.createDefault(FastMoveConfig.class, (String)"fastmove");

    public void onInitializeClient() {
        LOGGER.info("initializing FastMove Client :3");
        FastMoveInput input = new FastMoveInput();
        INPUT = input;
        ClientTickEvents.END_CLIENT_TICK.register(input::onEndTick);
        moveStateUpdater = new IMoveStateUpdater(){

            @Override
            public void setMoveState(class_1657 player, MoveState moveState) {
                class_2540 buf = PacketByteBufs.create();
                buf.method_10797(player.method_5667());
                buf.writeInt(MoveState.STATE(moveState));
                ClientPlayNetworking.send((class_2960)FastMove.MOVE_STATE, (class_2540)buf);
            }

            @Override
            public void setAnimationState(class_1657 player, MoveState moveState) {
                if (!(player instanceof IAnimatedPlayer)) {
                    return;
                }
                IAnimatedPlayer animatedPlayer = (IAnimatedPlayer)player;
                ModifierLayer<IAnimation> animationContainer = animatedPlayer.fastmove_getModAnimation();
                ModifierLayer<IAnimation> animationBodyContainer = animatedPlayer.fastmove_getModAnimationBody();
                if (animationContainer == null || animationBodyContainer == null) {
                    return;
                }
                if (_animations.isEmpty()) {
                    for (MoveState entry : MoveState.STATES.values()) {
                        KeyframeAnimation animation;
                        String name = entry.name;
                        if (name.equals("none") || (animation = PlayerAnimationRegistry.getAnimation((class_2960)new class_2960("fastmove", entry.name))) == null) continue;
                        _animations.put(entry.name, animation);
                    }
                }
                AbstractFadeModifier fade = AbstractFadeModifier.standardFadeIn((int)10, (Ease)Ease.INOUTQUAD);
                KeyframeAnimation anim = _animations.get(moveState.name);
                if (anim == null) {
                    animationBodyContainer.replaceAnimationWithFade(fade, null);
                    animationContainer.replaceAnimationWithFade(fade, null);
                    return;
                }
                KeyframeAnimationPlayer bodyLayer = new KeyframeAnimationPlayer(anim);
                KeyframeAnimationPlayer.BodyPart bodyVal = (KeyframeAnimationPlayer.BodyPart)bodyLayer.bodyParts.get("body");
                bodyLayer.bodyParts.clear();
                bodyLayer.bodyParts.put("body", bodyVal);
                animationBodyContainer.replaceAnimationWithFade(fade, (IAnimation)bodyLayer);
                animationContainer.replaceAnimationWithFade(fade, (IAnimation)new KeyframeAnimationPlayer(anim));
            }
        };
        CONFIG = () -> CONFIG_MANAGER.getConfig();
        ClientPlayNetworking.registerGlobalReceiver((class_2960)FastMove.MOVE_STATE, (client, handler, buf, responseSender) -> {
            if (client.field_1687 != null) {
                UUID uuid = buf.method_10790();
                int moveStateInt = buf.readInt();
                MoveState moveState = MoveState.STATE(moveStateInt);
                IFastPlayer fastPlayer = (IFastPlayer)client.field_1687.method_18470(uuid);
                if (fastPlayer != null) {
                    fastPlayer.fastmove_setMoveState(moveState);
                }
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)FastMove.CONFIG_STATE, (client, handler, buf, responseSender) -> {
            serverConfig = new FastMoveConfig();
            FastMoveClient.serverConfig.enableFastMove = buf.readBoolean();
            FastMoveClient.serverConfig.diveRollEnabled = buf.readBoolean();
            FastMoveClient.serverConfig.diveRollStaminaCost = buf.readInt();
            FastMoveClient.serverConfig.diveRollSpeedBoostMultiplier = buf.readDouble();
            FastMoveClient.serverConfig.diveRollCoolDown = buf.readInt();
            FastMoveClient.serverConfig.diveRollWhenSwimming = buf.readBoolean();
            FastMoveClient.serverConfig.diveRollWhenFlying = buf.readBoolean();
            FastMoveClient.serverConfig.wallRunEnabled = buf.readBoolean();
            FastMoveClient.serverConfig.wallRunStaminaCost = buf.readInt();
            FastMoveClient.serverConfig.wallRunSpeedBoostMultiplier = buf.readDouble();
            FastMoveClient.serverConfig.wallRunDurationTicks = buf.readInt();
            FastMoveClient.serverConfig.slideEnabled = buf.readBoolean();
            FastMoveClient.serverConfig.slideStaminaCost = buf.readInt();
            FastMoveClient.serverConfig.slideSpeedBoostMultiplier = buf.readDouble();
            FastMoveClient.serverConfig.slideCoolDown = buf.readInt();
            LOGGER.info("Got config from server");
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            serverConfig = null;
        });
    }
}

