/*
 * Decompiled with CFR 0.152.
 */
package io.github.beeebea.fastmove;

import io.github.beeebea.fastmove.IFastMoveInput;
import io.github.beeebea.fastmove.IFastPlayer;
import io.github.beeebea.fastmove.IMoveStateUpdater;
import io.github.beeebea.fastmove.MoveState;
import io.github.beeebea.fastmove.config.FastMoveConfig;
import io.github.beeebea.fastmove.config.IFastMoveConfig;
import java.util.LinkedList;
import java.util.Queue;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastMove
implements ModInitializer {
    public static final String MOD_ID = "fastmove";
    protected static FastMoveConfig serverConfig = null;
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"fastmove");
    public static final class_2960 MOVE_STATE = new class_2960("fastmove", "move_state");
    public static final class_2960 CONFIG_STATE = new class_2960("fastmove", "config_state");
    private static final Object _queueLock = new Object();
    private static final Queue<Runnable> _actionQueue = new LinkedList<Runnable>();
    public static IMoveStateUpdater moveStateUpdater;
    public static IFastMoveInput INPUT;
    public static IFastMoveConfig CONFIG;

    public static FastMoveConfig getConfig() {
        if (serverConfig != null) {
            return serverConfig;
        }
        return CONFIG.getConfig();
    }

    public void onInitialize() {
        LOGGER.info("initializing FastMove :3");
        moveStateUpdater = new IMoveStateUpdater(){

            @Override
            public void setMoveState(class_1657 player, MoveState moveState) {
            }

            @Override
            public void setAnimationState(class_1657 player, MoveState moveState) {
            }
        };
        INPUT = new IFastMoveInput(){

            @Override
            public boolean ismoveUpKeyPressed() {
                return false;
            }

            @Override
            public boolean ismoveDownKeyPressed() {
                return false;
            }

            @Override
            public boolean ismoveUpKeyPressedLastTick() {
                return false;
            }

            @Override
            public boolean ismoveDownKeyPressedLastTick() {
                return false;
            }
        };
        CONFIG = FastMoveConfig::new;
        ServerPlayNetworking.registerGlobalReceiver((class_2960)MOVE_STATE, (server, player, handler, buf, responseSender) -> {
            UUID uuid = buf.method_10790();
            int moveStateInt = buf.readInt();
            MoveState moveState = MoveState.STATE(moveStateInt);
            IFastPlayer fastPlayer = (IFastPlayer)server.method_3760().method_14602(uuid);
            if (fastPlayer != null) {
                fastPlayer.fastmove_setMoveState(moveState);
            }
            FastMove.SendToClients((class_1657)fastPlayer, MOVE_STATE, uuid, moveStateInt);
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            Object object = _queueLock;
            synchronized (object) {
                while (_actionQueue.size() > 0) {
                    _actionQueue.poll().run();
                }
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_2540 buf = PacketByteBufs.create();
            buf.writeBoolean(FastMove.getConfig().enableFastMove);
            buf.writeBoolean(FastMove.getConfig().diveRollEnabled);
            buf.writeInt(FastMove.getConfig().diveRollStaminaCost);
            buf.writeDouble(FastMove.getConfig().diveRollSpeedBoostMultiplier);
            buf.writeInt(FastMove.getConfig().diveRollCoolDown);
            buf.writeBoolean(FastMove.getConfig().diveRollWhenSwimming);
            buf.writeBoolean(FastMove.getConfig().diveRollWhenFlying);
            buf.writeBoolean(FastMove.getConfig().wallRunEnabled);
            buf.writeInt(FastMove.getConfig().wallRunStaminaCost);
            buf.writeDouble(FastMove.getConfig().wallRunSpeedBoostMultiplier);
            buf.writeInt(FastMove.getConfig().wallRunDurationTicks);
            buf.writeBoolean(FastMove.getConfig().slideEnabled);
            buf.writeInt(FastMove.getConfig().slideStaminaCost);
            buf.writeDouble(FastMove.getConfig().slideSpeedBoostMultiplier);
            buf.writeInt(FastMove.getConfig().slideCoolDown);
            sender.sendPacket(CONFIG_STATE, buf);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SendToClients(class_1657 source, class_2960 type, UUID uuid, int moveStateInt) {
        Object object = _queueLock;
        synchronized (object) {
            _actionQueue.add(() -> {
                for (class_1657 target : source.method_5682().method_3760().method_14571()) {
                    if (target == source || !(target.method_5858((class_1297)source) < 6400.0)) continue;
                    class_2540 buf = PacketByteBufs.create();
                    buf.method_10797(uuid);
                    buf.writeInt(moveStateInt);
                    ServerPlayNetworking.send((class_3222)((class_3222)target), (class_2960)type, (class_2540)buf);
                }
            });
        }
    }
}

