/*
 * Decompiled with CFR 0.152.
 */
package io.github.zemelua.umu_little_maid.util;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import io.github.zemelua.umu_little_maid.UMULittleMaid;
import io.github.zemelua.umu_little_maid.util.ImmutableText;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2742;
import net.minecraft.class_2745;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3610;
import net.minecraft.class_3902;
import net.minecraft.class_4081;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4208;
import net.minecraft.class_4770;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5498;
import net.minecraft.class_5712;
import net.minecraft.class_6862;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class ModUtils {
    public static boolean isMonster(class_1309 living) {
        return living.method_5864().method_5891() == class_1311.field_6302;
    }

    public static boolean hasEnchantment(class_1887 enchantment, class_1799 itemStack) {
        return class_1890.method_8225((class_1887)enchantment, (class_1799)itemStack) > 0;
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean isFirstPersonView() {
        return class_310.method_1551().field_1690.method_31044().method_31034();
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean isThirdPersonView() {
        class_5498 perspective = class_310.method_1551().field_1690.method_31044();
        return perspective == class_5498.field_26665 || perspective.method_31035();
    }

    public static class_1799 searchInInventory(class_1263 inventory, class_6862<class_1792> tag) {
        return ModUtils.searchInInventory(inventory, (class_1799 stack) -> stack.method_31573(tag));
    }

    public static class_1799 searchInInventory(class_1263 inventory, Predicate<class_1799> predicate) {
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 itemStack = inventory.method_5438(i);
            if (!predicate.test(itemStack)) continue;
            return itemStack;
        }
        return class_1799.field_8037;
    }

    public static Optional<class_2338> getNearestPos(Collection<class_2338> poses, class_1297 entity) {
        return poses.stream().min(Comparator.comparingDouble(pos -> entity.method_5707(class_243.method_24954((class_2382)pos))));
    }

    public static int getHeightFromGround(class_1937 world, class_1297 entity) {
        class_2338.class_2339 pos = entity.method_24515().method_10074().method_25503();
        int i = 0;
        while (world.method_8320((class_2338)pos).method_26215() && world.method_24794((class_2338)pos)) {
            ++i;
            pos.method_10104(class_2350.field_11033, 1);
        }
        return i;
    }

    public static boolean isSameObject(class_1937 world, class_2338 pos1, class_2338 pos2) {
        class_2680 state1 = world.method_8320(pos1);
        class_2680 state2 = world.method_8320(pos2);
        if (pos1.equals((Object)pos2)) {
            return true;
        }
        if (!state1.method_27852(state2.method_26204())) {
            return false;
        }
        if (state1.method_28498((class_2769)class_2741.field_12483) && state2.method_28498((class_2769)class_2741.field_12483) && state1.method_28498((class_2769)class_2741.field_12481) && state2.method_28498((class_2769)class_2741.field_12481)) {
            class_2350 facing = (class_2350)state1.method_11654((class_2769)class_2741.field_12481);
            class_2350 connectTo = state1.method_11654((class_2769)class_2741.field_12483) == class_2742.field_12560 ? facing.method_10153() : facing;
            class_2742 connectWith = state1.method_11654((class_2769)class_2741.field_12483) == class_2742.field_12560 ? class_2742.field_12557 : class_2742.field_12560;
            return pos1.method_10093(connectTo).equals((Object)pos2) && state2.method_11654((class_2769)class_2741.field_12483) == connectWith && state2.method_11654((class_2769)class_2741.field_12481) == facing;
        }
        if (state1.method_28498((class_2769)class_2741.field_12533) && state2.method_28498((class_2769)class_2741.field_12533)) {
            class_2350 connectTo = state1.method_11654((class_2769)class_2741.field_12533) == class_2756.field_12609 ? class_2350.field_11033 : class_2350.field_11036;
            class_2756 connectWith = state1.method_11654((class_2769)class_2741.field_12533) == class_2756.field_12609 ? class_2756.field_12607 : class_2756.field_12609;
            return pos1.method_10093(connectTo).equals((Object)pos2) && state2.method_11654((class_2769)class_2741.field_12533) == connectWith;
        }
        if (state1.method_28498((class_2769)class_2741.field_12506) && state2.method_28498((class_2769)class_2741.field_12506) && state1.method_28498((class_2769)class_2741.field_12481) && state2.method_28498((class_2769)class_2741.field_12481)) {
            class_2350 facing1 = (class_2350)state1.method_11654((class_2769)class_2741.field_12481);
            class_2350 facing2 = (class_2350)state2.method_11654((class_2769)class_2741.field_12481);
            class_2745 type1 = (class_2745)state1.method_11654((class_2769)class_2741.field_12506);
            class_2745 type2 = (class_2745)state2.method_11654((class_2769)class_2741.field_12506);
            class_2350 connectTo = type1 == class_2745.field_12574 ? facing1.method_10170() : facing1.method_10160();
            class_2745 connectWith = type1 == class_2745.field_12574 ? class_2745.field_12571 : class_2745.field_12574;
            return pos1.method_10093(connectTo).equals((Object)pos2) && facing2 == facing1 && type2 == connectWith;
        }
        return false;
    }

    public static boolean isSameObject(class_1937 world, class_2338 pos, class_4208 globalPos) {
        if (!world.method_27983().equals(globalPos.method_19442())) {
            return false;
        }
        return ModUtils.isSameObject(world, pos, globalPos.method_19446());
    }

    public static boolean hasHarmfulEffect(class_1309 living) {
        return living.method_6026().stream().anyMatch(effect -> effect.method_5579().method_18792() == class_4081.field_18272);
    }

    private ModUtils() {
    }

    public static final class KeyBinds {
        public static class_304 getAttackKey() {
            return class_310.method_1551().field_1690.field_1886;
        }

        public static class_304 getUseKey() {
            return class_310.method_1551().field_1690.field_1904;
        }
    }

    public static final class Texts {
        public static final ImmutableText DECIDE = new ImmutableText((class_2561)class_2561.method_43471((String)"message.umu_little_maid.decide").method_27694(s -> s.method_10977(class_124.field_1060)));
        public static final ImmutableText REMOVE = new ImmutableText((class_2561)class_2561.method_43471((String)"message.umu_little_maid.remove").method_27694(s -> s.method_10977(class_124.field_1061)));

        public static class_5250 blockWithPos(class_2680 state, class_2338 pos) {
            return class_2561.method_43471((String)state.method_26204().method_9539()).method_10852((class_2561)Texts.pos(pos)).method_27694(style -> style.method_10977(class_124.field_1060));
        }

        public static class_5250 pos(class_2338 pos) {
            return class_2564.method_10885((class_2561)class_2561.method_43469((String)"chat.coordinates", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260()}));
        }
    }

    public static final class GUIs {
        public static void drawTextWithBackground(class_332 context, class_327 textRenderer, class_2561 text, int x, int y, int color) {
            class_315 options = class_310.method_1551().field_1690;
            int textW = textRenderer.method_27525((class_5348)text);
            Objects.requireNonNull(textRenderer);
            int textH = 9;
            int backgroundColor = (int)((Double)options.method_42550().method_41753() * 255.0) << 24 & 0xFF000000;
            context.method_25294(x - 2, y - 2, x + textW + 2, y + textH + 2, backgroundColor);
            context.method_27535(textRenderer, text, x, y, color);
        }
    }

    public static final class Conversions {
        public static final Codec<List<class_4208>> GLOBAL_POS_COLLECTION_CODEC = class_4208.field_25066.listOf();

        public static class_2520 globalPosToNBT(class_4208 pos) {
            return (class_2520)class_4208.field_25066.encodeStart((DynamicOps)class_2509.field_11560, (Object)pos).getOrThrow(false, arg_0 -> ((Logger)UMULittleMaid.LOGGER).error(arg_0));
        }

        public static class_4208 nbtToGlobalPos(class_2520 nbt) {
            return (class_4208)class_4208.field_25066.parse((DynamicOps)class_2509.field_11560, (Object)nbt).getOrThrow(false, arg_0 -> ((Logger)UMULittleMaid.LOGGER).error(arg_0));
        }
    }

    public static final class Inventories {
        public static boolean canInsert(class_1263 to, class_1799 stack) {
            for (int i = 0; i < to.method_5439(); ++i) {
                class_1799 stackInInv = to.method_5438(i);
                if (stackInInv.method_7947() >= stackInInv.method_7914()) continue;
                if (stackInInv.method_7960()) {
                    return true;
                }
                if (!class_1799.method_31577((class_1799)stack, (class_1799)stackInInv)) continue;
                return true;
            }
            return false;
        }
    }

    public static final class Brains {
        public static void remember(class_4095<?> brain, class_4140<class_3902> type) {
            brain.method_18878(type, (Object)class_3902.field_17274);
        }
    }

    public static final class Worlds {
        public static void breakBlockWithoutDrop(class_1937 world, class_2338 pos, @Nullable class_1297 breaker) {
            class_2680 blockState = world.method_8320(pos);
            class_3610 fluidState = world.method_8316(pos);
            if (blockState.method_26215()) {
                return;
            }
            if (!(blockState.method_26204() instanceof class_4770)) {
                world.method_20290(2001, pos, class_2248.method_9507((class_2680)blockState));
            }
            if (world.method_30092(pos, fluidState.method_15759(), 3, 512)) {
                world.method_43276(class_5712.field_28165, pos, class_5712.class_7397.method_43286((class_1297)breaker, (class_2680)blockState));
            }
        }

        public static long getTimeOfDay(class_1937 world) {
            return world.method_8532() % 24000L;
        }
    }
}

