/*
 * Decompiled with CFR 0.152.
 */
package io.github.zemelua.umu_little_maid.util;

import io.github.zemelua.umu_little_maid.c_component.Components;
import io.github.zemelua.umu_little_maid.c_component.instruction.IInstructionComponent;
import io.github.zemelua.umu_little_maid.entity.maid.LittleMaidEntity;
import io.github.zemelua.umu_little_maid.network.NetworkHandler;
import io.github.zemelua.umu_little_maid.util.ImmutableText;
import io.github.zemelua.umu_little_maid.util.ModUtils;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_5244;
import net.minecraft.class_5250;

public final class InstructionUtils {
    public static final ImmutableText PASS_ON_BLOCK_MESSAGE = new ImmutableText((class_2561)class_2561.method_43471((String)"message.umu_little_maid.instruction_pass_on_block"));
    public static final ImmutableText PASS_ON_ENTITY_MESSAGE = new ImmutableText((class_2561)class_2561.method_43471((String)"message.umu_little_maid.instruction_pass_on_entity"));
    public static final ImmutableText PASS_ON_ANCHOR_MESSAGE = new ImmutableText((class_2561)class_2561.method_43471((String)"message.umu_little_maid.instruction_pass_on_anchor"));
    public static final ImmutableText CANCEL = new ImmutableText((class_2561)class_2561.method_43471((String)"message.umu_little_maid.instruction_cancel"));
    public static final ImmutableText HOME_TOOLTIP = new ImmutableText((class_2561)class_2561.method_43471((String)"tooltip.umu_little_maid.home"));
    public static final ImmutableText ANCHOR_TOOLTIP = new ImmutableText((class_2561)class_2561.method_43471((String)"tooltip.umu_little_maid.anchor"));
    public static final ImmutableText DELIVERY_BOX_TOOLTIP = new ImmutableText((class_2561)class_2561.method_43471((String)"tooltip.umu_little_maid.delivery_box"));

    public static IInstructionComponent getComponent(class_1657 player) {
        return (IInstructionComponent)player.getComponent(Components.INSTRUCTION);
    }

    @Environment(value=EnvType.CLIENT)
    public static Optional<IInstructionComponent> getComponent(class_310 client) {
        return Optional.ofNullable(client.field_1724).map(InstructionUtils::getComponent);
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean isInstructing(class_310 client) {
        return InstructionUtils.getComponent(client).map(IInstructionComponent::isInstructing).orElse(false);
    }

    @Environment(value=EnvType.CLIENT)
    public static Optional<LittleMaidEntity> getMaid(class_310 client) {
        return InstructionUtils.getComponent(client).flatMap(IInstructionComponent::getTarget);
    }

    @Environment(value=EnvType.CLIENT)
    public static void cancelOnClient() {
        ClientPlayNetworking.send((class_2960)NetworkHandler.CHANNEL_CLIENT_INSTRUCTION_CANCEL, (class_2540)PacketByteBufs.create());
    }

    public static <I extends class_1297> class_5250 homeMessage(I owner) {
        return class_2561.method_43469((String)"message.umu_little_maid.instruction_home", (Object[])new Object[]{owner.method_5476()});
    }

    public static <I extends class_1297> class_5250 anchorMessage(I owner) {
        return class_2561.method_43469((String)"message.umu_little_maid.instruction_anchor", (Object[])new Object[]{owner.method_5476()});
    }

    public static <I extends class_1297> class_5250 deliveryBoxMessage(I owner) {
        return class_2561.method_43469((String)"message.umu_little_maid.instruction_delivery_box", (Object[])new Object[]{owner.method_5476()});
    }

    public static <I extends class_1297> class_5250 setHomeMessage(class_2680 state, class_2338 pos, I owner) {
        return InstructionUtils.setSiteMessage(state, pos, (class_2561)InstructionUtils.homeMessage(owner));
    }

    public static <I extends class_1297> class_5250 renewHomeMessage(class_2680 state, class_2338 pos, I owner) {
        return InstructionUtils.renewSiteMessage(state, pos, (class_2561)InstructionUtils.homeMessage(owner));
    }

    public static <I extends class_1297> class_5250 removeHomeMessage(class_2680 state, class_2338 pos, I owner) {
        return InstructionUtils.removeSiteMessage(state, pos, (class_2561)InstructionUtils.homeMessage(owner));
    }

    public static <I extends class_1297> class_5250 addDeliveryBoxMessage(class_2680 state, class_2338 pos, I owner) {
        return InstructionUtils.addSiteMessage(state, pos, (class_2561)InstructionUtils.deliveryBoxMessage(owner));
    }

    public static <I extends class_1297> class_5250 removeDeliveryBoxMessage(class_2680 state, class_2338 pos, I owner) {
        return InstructionUtils.removeSiteMessage(state, pos, (class_2561)InstructionUtils.deliveryBoxMessage(owner));
    }

    public static class_5250 setSiteMessage(class_2680 state, class_2338 pos, class_2561 site) {
        return class_2561.method_43469((String)"message.umu_little_maid.instruction_set_site", (Object[])new Object[]{ModUtils.Texts.blockWithPos(state, pos), site});
    }

    public static class_5250 renewSiteMessage(class_2680 state, class_2338 pos, class_2561 site) {
        return class_2561.method_43469((String)"message.umu_little_maid.instruction_renew_site", (Object[])new Object[]{ModUtils.Texts.blockWithPos(state, pos), site});
    }

    public static class_5250 addSiteMessage(class_2680 state, class_2338 pos, class_2561 site) {
        return class_2561.method_43469((String)"message.umu_little_maid.instruction_add_site", (Object[])new Object[]{ModUtils.Texts.blockWithPos(state, pos), site});
    }

    public static class_5250 removeSiteMessage(class_2680 state, class_2338 pos, class_2561 site) {
        return class_2561.method_43469((String)"message.umu_little_maid.instruction_remove_site", (Object[])new Object[]{ModUtils.Texts.blockWithPos(state, pos), site});
    }

    public static class_5250 guideCancelMessage() {
        class_304 attackKey = ModUtils.KeyBinds.getAttackKey();
        return class_2561.method_43469((String)"message.umu_little_maid.instruction_guide_cancel", (Object[])new Object[]{attackKey.method_16007(), class_5244.field_24335});
    }

    public static class_5250 guideDecideMessage() {
        class_304 useKey = ModUtils.KeyBinds.getUseKey();
        return class_2561.method_43469((String)"message.umu_little_maid.instruction_guide_decide", (Object[])new Object[]{useKey.method_16007(), ModUtils.Texts.DECIDE});
    }

    public static class_5250 guideRemoveMessage() {
        class_304 useKey = ModUtils.KeyBinds.getUseKey();
        return class_2561.method_43469((String)"message.umu_little_maid.instruction_guide_remove", (Object[])new Object[]{useKey.method_16007(), ModUtils.Texts.REMOVE});
    }

    private InstructionUtils() {
    }
}

