/*
 * Decompiled with CFR 0.152.
 */
package io.github.zemelua.umu_little_maid.entity.maid;

import com.google.common.collect.ImmutableMap;
import io.github.zemelua.umu_little_maid.entity.ModEntities;
import io.github.zemelua.umu_little_maid.entity.maid.MaidPersonality;
import java.util.Map;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_5819;
import net.minecraft.class_6880;

public final class MaidSpawnHandler {
    private static final Map<MaidPersonality, Integer> PLAINS_ODDS = ImmutableMap.of((Object)ModEntities.PERSONALITY_BRAVERY, (Object)100, (Object)ModEntities.PERSONALITY_DILIGENT, (Object)100, (Object)ModEntities.PERSONALITY_AUDACIOUS, (Object)100, (Object)ModEntities.PERSONALITY_GENTLE, (Object)90, (Object)ModEntities.PERSONALITY_SHY, (Object)30, (Object)ModEntities.PERSONALITY_LAZY, (Object)5, (Object)ModEntities.PERSONALITY_TSUNDERE, (Object)6);
    private static final Map<MaidPersonality, Integer> DESERT_ODDS = ImmutableMap.of((Object)ModEntities.PERSONALITY_BRAVERY, (Object)70, (Object)ModEntities.PERSONALITY_DILIGENT, (Object)70, (Object)ModEntities.PERSONALITY_AUDACIOUS, (Object)100, (Object)ModEntities.PERSONALITY_GENTLE, (Object)40, (Object)ModEntities.PERSONALITY_SHY, (Object)5, (Object)ModEntities.PERSONALITY_LAZY, (Object)5, (Object)ModEntities.PERSONALITY_TSUNDERE, (Object)6);
    private static final Map<MaidPersonality, Integer> SWAMP_ODDS = ImmutableMap.of((Object)ModEntities.PERSONALITY_BRAVERY, (Object)30, (Object)ModEntities.PERSONALITY_DILIGENT, (Object)40, (Object)ModEntities.PERSONALITY_AUDACIOUS, (Object)30, (Object)ModEntities.PERSONALITY_GENTLE, (Object)40, (Object)ModEntities.PERSONALITY_SHY, (Object)50, (Object)ModEntities.PERSONALITY_LAZY, (Object)100, (Object)ModEntities.PERSONALITY_TSUNDERE, (Object)30);
    private static final Map<MaidPersonality, Integer> FOREST_ODDS = ImmutableMap.of((Object)ModEntities.PERSONALITY_BRAVERY, (Object)30, (Object)ModEntities.PERSONALITY_DILIGENT, (Object)40, (Object)ModEntities.PERSONALITY_AUDACIOUS, (Object)40, (Object)ModEntities.PERSONALITY_GENTLE, (Object)80, (Object)ModEntities.PERSONALITY_SHY, (Object)100, (Object)ModEntities.PERSONALITY_LAZY, (Object)60, (Object)ModEntities.PERSONALITY_TSUNDERE, (Object)10);
    private static final Map<MaidPersonality, Integer> TAIGA_ODDS = ImmutableMap.of((Object)ModEntities.PERSONALITY_BRAVERY, (Object)20, (Object)ModEntities.PERSONALITY_DILIGENT, (Object)90, (Object)ModEntities.PERSONALITY_AUDACIOUS, (Object)60, (Object)ModEntities.PERSONALITY_GENTLE, (Object)70, (Object)ModEntities.PERSONALITY_SHY, (Object)20, (Object)ModEntities.PERSONALITY_LAZY, (Object)10, (Object)ModEntities.PERSONALITY_TSUNDERE, (Object)100);
    private static final Map<MaidPersonality, Integer> SAVANNA_ODDS = ImmutableMap.of((Object)ModEntities.PERSONALITY_BRAVERY, (Object)100, (Object)ModEntities.PERSONALITY_DILIGENT, (Object)20, (Object)ModEntities.PERSONALITY_AUDACIOUS, (Object)80, (Object)ModEntities.PERSONALITY_GENTLE, (Object)20, (Object)ModEntities.PERSONALITY_SHY, (Object)5, (Object)ModEntities.PERSONALITY_LAZY, (Object)3, (Object)ModEntities.PERSONALITY_TSUNDERE, (Object)5);
    private static final Map<MaidPersonality, Integer> GROVE_ODDS = ImmutableMap.of((Object)ModEntities.PERSONALITY_BRAVERY, (Object)50, (Object)ModEntities.PERSONALITY_DILIGENT, (Object)20, (Object)ModEntities.PERSONALITY_AUDACIOUS, (Object)50, (Object)ModEntities.PERSONALITY_GENTLE, (Object)40, (Object)ModEntities.PERSONALITY_SHY, (Object)20, (Object)ModEntities.PERSONALITY_LAZY, (Object)10, (Object)ModEntities.PERSONALITY_TSUNDERE, (Object)10);
    private static final Map<MaidPersonality, Integer> CAVES_ODDS = ImmutableMap.of((Object)ModEntities.PERSONALITY_BRAVERY, (Object)20, (Object)ModEntities.PERSONALITY_DILIGENT, (Object)30, (Object)ModEntities.PERSONALITY_AUDACIOUS, (Object)10, (Object)ModEntities.PERSONALITY_GENTLE, (Object)80, (Object)ModEntities.PERSONALITY_SHY, (Object)100, (Object)ModEntities.PERSONALITY_LAZY, (Object)90, (Object)ModEntities.PERSONALITY_TSUNDERE, (Object)90);

    public static MaidPersonality randomPersonality(class_5819 random, class_6880<class_1959> biome) {
        if (biome.method_40225(class_1972.field_9451) || biome.method_40225(class_1972.field_9455) || biome.method_40225(class_1972.field_35117) || biome.method_40225(class_1972.field_9453) || biome.method_40225(class_1972.field_34470)) {
            return MaidSpawnHandler.randomPersonality(random, PLAINS_ODDS);
        }
        if (biome.method_40225(class_1972.field_9424)) {
            return MaidSpawnHandler.randomPersonality(random, DESERT_ODDS);
        }
        if (biome.method_40225(class_1972.field_9471)) {
            return MaidSpawnHandler.randomPersonality(random, SWAMP_ODDS);
        }
        if (biome.method_40225(class_1972.field_9409) || biome.method_40225(class_1972.field_9414) || biome.method_40225(class_1972.field_9412) || biome.method_40225(class_1972.field_9475) || biome.method_40225(class_1972.field_35112)) {
            return MaidSpawnHandler.randomPersonality(random, FOREST_ODDS);
        }
        if (biome.method_40225(class_1972.field_35119) || biome.method_40225(class_1972.field_35113) || biome.method_40225(class_1972.field_9420) || biome.method_40225(class_1972.field_9454)) {
            return MaidSpawnHandler.randomPersonality(random, TAIGA_ODDS);
        }
        if (biome.method_40225(class_1972.field_9449) || biome.method_40225(class_1972.field_9430) || biome.method_40225(class_1972.field_9417) || biome.method_40225(class_1972.field_35118) || biome.method_40225(class_1972.field_9440)) {
            return MaidSpawnHandler.randomPersonality(random, SAVANNA_ODDS);
        }
        if (biome.method_40225(class_1972.field_34471) || biome.method_40225(class_1972.field_9415) || biome.method_40225(class_1972.field_9443) || biome.method_40225(class_1972.field_35110)) {
            return MaidSpawnHandler.randomPersonality(random, GROVE_ODDS);
        }
        if (biome.method_40225(class_1972.field_29218)) {
            return MaidSpawnHandler.randomPersonality(random, CAVES_ODDS);
        }
        return MaidSpawnHandler.randomPersonality(random, PLAINS_ODDS);
    }

    public static MaidPersonality randomPersonality(class_5819 random, Map<MaidPersonality, Integer> odds) {
        int entirety = odds.values().stream().mapToInt(i -> i).sum();
        int odd = random.method_43048(entirety);
        int currentOdds = 0;
        for (Map.Entry<MaidPersonality, Integer> entry : odds.entrySet()) {
            if (odd >= (currentOdds += entry.getValue().intValue())) continue;
            return entry.getKey();
        }
        return ModEntities.PERSONALITY_BRAVERY;
    }

    private MaidSpawnHandler() throws IllegalAccessException {
        throw new IllegalAccessException();
    }
}

