/*
 * Decompiled with CFR 0.152.
 */
package io.github.zemelua.umu_little_maid.entity.maid;

import io.github.zemelua.umu_little_maid.data.tag.ModTags;
import io.github.zemelua.umu_little_maid.register.ModRegistries;
import io.github.zemelua.umu_little_maid.util.ICanTagObject;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1309;
import net.minecraft.class_3414;
import net.minecraft.class_6862;
import net.minecraft.class_6880;

public class MaidPersonality
implements ICanTagObject<MaidPersonality> {
    private final double maxHealth;
    private final double movementSpeed;
    private final double attackDamage;
    private final double attackKnockback;
    private final double armor;
    private final double armorToughness;
    private final double knockbackResistance;
    private final double luck;
    private final Predicate<class_1309> hostiles;
    private final Predicate<class_1309> chases;
    private final class_3414 ambientSound;
    private final class_3414 fencerAttackSound;
    private final class_3414 crackerAttackSound;
    private final class_3414 archerAttackSound;
    private final class_3414 killedSound;
    private final class_3414 killedBarelySound;
    private final class_3414 hurtSound;
    private final class_3414 deathSound;
    private final class_3414 eatSound;
    private final class_3414 contractSound;
    private final class_3414 sitSound;
    private final class_3414 engageSound;

    public MaidPersonality(Builder builder, Predicate<class_1309> chases, class_3414 ambientSound, class_3414 fencerAttackSound, class_3414 crackerAttackSound, class_3414 archerAttackSound, class_3414 killedSound, class_3414 killedBarelySound, class_3414 hurtSound, class_3414 deathSound, class_3414 eatSound, class_3414 contractSound, class_3414 sitSound, class_3414 engageSound) {
        this.maxHealth = builder.maxHealth;
        this.movementSpeed = builder.movementSpeed;
        this.attackDamage = builder.attackDamage;
        this.attackKnockback = builder.attackKnockback;
        this.armor = builder.armor;
        this.armorToughness = builder.armorToughness;
        this.knockbackResistance = builder.knockbackResistance;
        this.luck = builder.luck;
        this.hostiles = builder.hostiles;
        this.chases = chases;
        this.ambientSound = ambientSound;
        this.fencerAttackSound = fencerAttackSound;
        this.crackerAttackSound = crackerAttackSound;
        this.archerAttackSound = archerAttackSound;
        this.killedSound = killedSound;
        this.killedBarelySound = killedBarelySound;
        this.hurtSound = hurtSound;
        this.deathSound = deathSound;
        this.eatSound = eatSound;
        this.contractSound = contractSound;
        this.sitSound = sitSound;
        this.engageSound = engageSound;
    }

    public double getMaxHealth() {
        return this.maxHealth;
    }

    public double getMovementSpeed() {
        return this.movementSpeed;
    }

    public double getAttackDamage() {
        return this.attackDamage;
    }

    public double getAttackKnockback() {
        return this.attackKnockback;
    }

    public double getArmor() {
        return this.armor;
    }

    public double getArmorToughness() {
        return this.armorToughness;
    }

    public double getKnockbackResistance() {
        return this.knockbackResistance;
    }

    public double getLuck() {
        return this.luck;
    }

    public boolean isHostile(class_1309 living) {
        return this.hostiles.test(living);
    }

    public boolean isChase(class_1309 target) {
        return this.chases.test(target);
    }

    public class_3414 getAmbientSound() {
        return this.ambientSound;
    }

    public class_3414 getFencerAttackSound() {
        return this.fencerAttackSound;
    }

    public class_3414 getCrackerAttackSound() {
        return this.crackerAttackSound;
    }

    public class_3414 getArcherAttackSound() {
        return this.archerAttackSound;
    }

    public class_3414 getKilledSound() {
        return this.killedSound;
    }

    public class_3414 getKilledBarelySound() {
        return this.killedBarelySound;
    }

    public class_3414 getHurtSound() {
        return this.hurtSound;
    }

    public class_3414 getDeathSound() {
        return this.deathSound;
    }

    public class_3414 getEatSound() {
        return this.eatSound;
    }

    public class_3414 getContractSound() {
        return this.contractSound;
    }

    public class_3414 getSitSound() {
        return this.sitSound;
    }

    public class_3414 getEngageSound() {
        return this.engageSound;
    }

    @Override
    public boolean isIn(class_6862<MaidPersonality> tag) {
        return ModRegistries.MAID_PERSONALITY.method_40266(tag).map(list -> list.method_40239().map(class_6880::comp_349).collect(Collectors.toSet()).contains(this)).orElse(false);
    }

    public static class Builder {
        private double maxHealth = 20.0;
        private double movementSpeed = 0.3;
        private double attackDamage = 1.0;
        private double attackKnockback = 0.0;
        private double armor = 0.0;
        private double armorToughness = 0.0;
        private double knockbackResistance = 0.0;
        private double luck = 0.0;
        private Predicate<class_1309> hostiles = living -> living.method_5864().method_20210(ModTags.ENTITY_MAID_GENERAL_HOSTILES);

        public Builder setMaxHealth(double maxHealth) {
            this.maxHealth = maxHealth;
            return this;
        }

        public Builder setMovementSpeed(double movementSpeed) {
            this.movementSpeed = movementSpeed;
            return this;
        }

        public Builder setAttackDamage(double attackDamage) {
            this.attackDamage = attackDamage;
            return this;
        }

        public Builder setAttackKnockback(double attackKnockback) {
            this.attackKnockback = attackKnockback;
            return this;
        }

        public Builder setArmor(double armor) {
            this.armor = armor;
            return this;
        }

        public Builder setArmorToughness(double armorToughness) {
            this.armorToughness = armorToughness;
            return this;
        }

        public Builder setKnockbackResistance(double knockbackResistance) {
            this.knockbackResistance = knockbackResistance;
            return this;
        }

        public Builder setLuck(double luck) {
            this.luck = luck;
            return this;
        }

        public Builder setHostiles(Predicate<class_1309> value) {
            this.hostiles = value;
            return this;
        }

        public MaidPersonality build(Predicate<class_1309> chases, class_3414 ambientSound, class_3414 fencerAttackSound, class_3414 crackerAttackSound, class_3414 archerAttackSound, class_3414 killedSound, class_3414 killedBarelySound, class_3414 hurtSound, class_3414 deathSound, class_3414 eatSound, class_3414 contractSound, class_3414 sitSound, class_3414 engageSound) {
            return new MaidPersonality(this, chases, ambientSound, fencerAttackSound, crackerAttackSound, archerAttackSound, killedSound, killedBarelySound, hurtSound, deathSound, eatSound, contractSound, sitSound, engageSound);
        }
    }
}

