/*
 * Decompiled with CFR 0.152.
 */
package io.github.zemelua.umu_little_maid.entity.maid;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import io.github.zemelua.umu_little_maid.UMULittleMaid;
import io.github.zemelua.umu_little_maid.api.IHeadpattable;
import io.github.zemelua.umu_little_maid.c_component.Components;
import io.github.zemelua.umu_little_maid.c_component.instruction.IInstructionComponent;
import io.github.zemelua.umu_little_maid.client.particle.ZZZParticle;
import io.github.zemelua.umu_little_maid.data.tag.ModTags;
import io.github.zemelua.umu_little_maid.entity.ModDataHandlers;
import io.github.zemelua.umu_little_maid.entity.ModEntities;
import io.github.zemelua.umu_little_maid.entity.brain.ModMemories;
import io.github.zemelua.umu_little_maid.entity.brain.sensor.ModSensors;
import io.github.zemelua.umu_little_maid.entity.control.MaidControl;
import io.github.zemelua.umu_little_maid.entity.maid.AbstractLittleMaidEntity;
import io.github.zemelua.umu_little_maid.entity.maid.ILittleMaidEntity;
import io.github.zemelua.umu_little_maid.entity.maid.MaidItemAnimationSetter;
import io.github.zemelua.umu_little_maid.entity.maid.MaidMode;
import io.github.zemelua.umu_little_maid.entity.maid.MaidPersonality;
import io.github.zemelua.umu_little_maid.entity.maid.MaidSpawnHandler;
import io.github.zemelua.umu_little_maid.entity.maid.action.MaidAction;
import io.github.zemelua.umu_little_maid.entity.maid.attack.MaidAttackType;
import io.github.zemelua.umu_little_maid.entity.maid.feeling.IMaidFeeling;
import io.github.zemelua.umu_little_maid.entity.maid.feeling.MaidFeeling;
import io.github.zemelua.umu_little_maid.entity.maid.job.IMaidJob;
import io.github.zemelua.umu_little_maid.entity.maid.job.MaidJobs;
import io.github.zemelua.umu_little_maid.inventory.LittleMaidScreenHandlerFactory;
import io.github.zemelua.umu_little_maid.mixin.MobEntityAccessor;
import io.github.zemelua.umu_little_maid.mixin.PersistentProjectileEntityAccessor;
import io.github.zemelua.umu_little_maid.mixin.TridentEntityAccessor;
import io.github.zemelua.umu_little_maid.network.NetworkHandler;
import io.github.zemelua.umu_little_maid.particle.ModParticles;
import io.github.zemelua.umu_little_maid.register.ModRegistries;
import io.github.zemelua.umu_little_maid.util.HeadpatManager;
import io.github.zemelua.umu_little_maid.util.IAvoidRain;
import io.github.zemelua.umu_little_maid.util.IInstructable;
import io.github.zemelua.umu_little_maid.util.IPoseidonMob;
import io.github.zemelua.umu_little_maid.util.ITameable;
import io.github.zemelua.umu_little_maid.util.ModUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_14;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_1542;
import net.minecraft.class_1603;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1685;
import net.minecraft.class_1738;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1811;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2397;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3321;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3745;
import net.minecraft.class_3902;
import net.minecraft.class_3908;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4095;
import net.minecraft.class_4102;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4168;
import net.minecraft.class_4208;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5575;
import net.minecraft.class_5766;
import net.minecraft.class_5819;
import net.minecraft.class_6067;
import net.minecraft.class_6880;
import net.minecraft.class_7;
import net.minecraft.class_7923;
import net.minecraft.class_8103;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class LittleMaidEntity
extends AbstractLittleMaidEntity
implements ILittleMaidEntity,
class_6067,
class_1603,
IPoseidonMob,
class_3745,
ITameable,
IAvoidRain,
IInstructable,
IHeadpattable,
GeoEntity {
    private static final Set<class_4140<?>> MEMORY_MODULES;
    private static final Set<class_4149<? extends class_4148<? super LittleMaidEntity>>> SENSORS;
    public static final int MAX_COMMITMENT = 300;
    public static final int DAY_CEIL_COMMITMENT = 30;
    public static final float LEFT_HAND_CHANCE = 0.15f;
    private static final class_2940<Optional<UUID>> MASTER;
    private static final class_2940<MaidMode> MODE;
    private static final class_2940<IMaidJob> JOB;
    private static final class_2940<MaidPersonality> PERSONALITY;
    private static final class_2940<IMaidFeeling> FEELING;
    private static final class_2940<Optional<MaidAction>> ACTION;
    private static final class_2940<Boolean> IS_VARIABLE_COSTUME;
    private static final class_2940<Integer> COMMITMENT;
    private static final class_2940<Optional<class_4208>> HOME;
    private static final class_2940<Optional<class_4208>> ANCHOR;
    private static final class_2940<Collection<class_4208>> DELIVERY_BOXES;
    private static final class_2940<Optional<Integer>> ATTACK_TARGET;
    private static final class_2940<MaidAttackType> ATTACK_TYPE;
    private final class_1408 landNavigation;
    private final class_1408 canSwimNavigation;
    private final class_1277 inventory = new class_1277(15);
    private final List<class_1792> givenFoods = new ArrayList<class_1792>();
    private int attackingTicks;
    @Nullable
    private class_1309 attackingTarget;
    private int eatingTicks;
    @Nullable
    private Consumer<class_1799> onFinishEating;
    private int changingCostumeTicks = 0;
    private boolean damageBlocked = false;
    private int attackedCooldown;
    private int continuityAttackedCount;
    private long lastClearCommitmentDayTime;
    private int increasedCommitment;
    private final AnimatableInstanceCache animationFactory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final class_4048 DIMENSIONS_SLEEPING;
    private static final class_4048 DIMENSIONS_CRAWLING;
    private static final float EYE_HEIGHT_STANDING = 1.2f;
    private static final float EYE_HEIGHT_SLEEPING = 0.2f;
    private static final float EYE_HEIGHT_CRAWLING = 0.4f;
    private static final UUID ATTRIBUTE_ID_CRACKER_SLOW;
    private static final UUID ATTRIBUTE_ID_CRACKER_DAMAGE;
    private static final String KEY_INVENTORY = "Inventory";
    private static final String KEY_SLOT = "Slot";
    private static final String KEY_GIVEN_FOODS = "GivenFoods";
    private static final String KEY_OWNER = "Owner";
    private static final String KEY_MODE = "Mode";
    private static final String KEY_JOB = "Job";
    private static final String KEY_PERSONALITY = "Personality";
    private static final String KEY_IS_VARIABLE_COSTUME = "IsVariableCostume";
    private static final String KEY_COMMITMENT = "Commitment";
    private static final String KEY_HOME = "Home";
    private static final String KEY_ANCHOR = "Anchor";
    private static final String KEY_DELIVERY_BOXES = "DeliveryBoxes";

    public LittleMaidEntity(class_1299<? extends class_1314> type, class_1937 world) {
        super(type, world);
        this.field_6207 = new MaidControl(this);
        this.landNavigation = new class_1409((class_1308)this, world);
        this.canSwimNavigation = new class_5766((class_1308)this, world);
        ((class_1409)this.landNavigation).method_6363(true);
        ((class_1409)this.landNavigation).method_35139(true);
        this.field_5985 = true;
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 nbt) {
        class_5819 random = world.method_8409();
        MaidPersonality personality = MaidSpawnHandler.randomPersonality(random, (class_6880<class_1959>)world.method_23753(this.method_24515()));
        this.setPersonality(personality);
        this.initializeAttributes();
        this.method_5937(random.method_43058() < (double)0.15f);
        this.method_5946(class_1304.field_6173, 2.0f);
        this.method_5946(class_1304.field_6171, 2.0f);
        this.method_5946(class_1304.field_6169, 2.0f);
        this.method_5946(class_1304.field_6166, 2.0f);
        this.method_5952(true);
        return entityData;
    }

    private void initializeAttributes() {
        try {
            MaidPersonality personality = this.getPersonality();
            this.method_5996(class_5134.field_23716).method_6192(personality.getMaxHealth());
            this.method_5996(class_5134.field_23719).method_6192(personality.getMovementSpeed());
            this.method_5996(class_5134.field_23721).method_6192(personality.getAttackDamage());
            this.method_5996(class_5134.field_23722).method_6192(personality.getAttackKnockback());
            this.method_5996(class_5134.field_23724).method_6192(personality.getArmor());
            this.method_5996(class_5134.field_23725).method_6192(personality.getArmorToughness());
            this.method_5996(class_5134.field_23718).method_6192(personality.getKnockbackResistance());
            this.method_5996(class_5134.field_23726).method_6192(personality.getLuck());
        }
        catch (NullPointerException exception) {
            UMULittleMaid.LOGGER.error("\u30e1\u30a4\u30c9\u3055\u3093\u306bAttribute\u304c\u767b\u9332\u3055\u308c\u3066\u306a\u3044\u3088\uff5e");
        }
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(MASTER, Optional.empty());
        this.field_6011.method_12784(MODE, (Object)MaidMode.FOLLOW);
        this.field_6011.method_12784(JOB, (Object)MaidJobs.NONE);
        this.field_6011.method_12784(ACTION, Optional.empty());
        this.field_6011.method_12784(PERSONALITY, (Object)ModEntities.PERSONALITY_BRAVERY);
        this.field_6011.method_12784(FEELING, (Object)MaidFeeling.NORMAL);
        this.field_6011.method_12784(IS_VARIABLE_COSTUME, (Object)true);
        this.field_6011.method_12784(COMMITMENT, (Object)0);
        this.field_6011.method_12784(HOME, Optional.empty());
        this.field_6011.method_12784(ANCHOR, Optional.empty());
        this.field_6011.method_12784(DELIVERY_BOXES, new HashSet());
        this.field_6011.method_12784(ATTACK_TARGET, Optional.empty());
        this.field_6011.method_12784(ATTACK_TYPE, (Object)MaidAttackType.NO_ATTACKING);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23719, 0.3).method_26868(class_5134.field_23721, 1.0).method_26868(class_5134.field_23722, 0.0).method_26868(class_5134.field_23724, 0.0).method_26868(class_5134.field_23725, 0.0).method_26868(class_5134.field_23718, 0.0).method_26868(class_5134.field_23726, 0.0);
    }

    protected class_4095.class_5303<LittleMaidEntity> method_28306() {
        return class_4095.method_28311(MEMORY_MODULES, SENSORS);
    }

    protected class_4095<LittleMaidEntity> method_18867(Dynamic<?> dynamic) {
        class_4095 brain = this.method_28306().method_28335(dynamic);
        this.getJob().initBrain((class_4095<LittleMaidEntity>)brain, this);
        return brain;
    }

    protected class_1408 method_5965(class_1937 world) {
        class_1409 navigation = new class_1409((class_1308)this, world);
        navigation.method_6363(true);
        navigation.method_35139(true);
        return navigation;
    }

    public float method_5944(class_7 nodeType) {
        if (nodeType == class_7.field_18) {
            return this.getJob().equals(MaidJobs.POSEIDON) ? 0.0f : 0.8f;
        }
        return super.method_5944(nodeType);
    }

    public boolean canSwim() {
        return this.method_5799() && this.getJob().equals(MaidJobs.POSEIDON);
    }

    public class_4048 method_18377(class_4050 pose) {
        return switch (pose) {
            case class_4050.field_18078 -> DIMENSIONS_SLEEPING;
            case class_4050.field_18079, class_4050.field_18080 -> DIMENSIONS_CRAWLING;
            default -> this.method_5864().method_18386();
        };
    }

    public float method_18394(class_4050 pose, class_4048 dimensions) {
        return switch (pose) {
            case class_4050.field_18078 -> 0.2f;
            case class_4050.field_18079, class_4050.field_18080 -> 0.4f;
            default -> 1.2f;
        };
    }

    public void method_6007() {
        super.method_6007();
        if (this.getAction().isEmpty()) {
            if (!this.method_24828() && this.hasDripleaf() && ModUtils.getHeightFromGround(this.method_37908(), (class_1297)this) >= 3) {
                this.setAction(MaidAction.GLIDING);
            }
        } else if (this.isGliding() && (this.method_24828() || !this.hasDripleaf())) {
            this.removeAction();
        }
        this.updateAttributes();
        class_243 velocity = this.method_18798();
        if (this.isGliding() && velocity.method_10214() < 0.0) {
            this.method_18799(velocity.method_18805(1.0, 0.6, 1.0));
        }
        if (this.getJob().equals(MaidJobs.ARCHER) || this.getJob().equals(MaidJobs.HUNTER)) {
            this.pickUpArrows();
        }
        if (this.getJob().equals(MaidJobs.POSEIDON)) {
            this.pickUpTridents();
        }
        this.method_6119();
    }

    private void updateAttributes() {
        IMaidJob job = this.getJob();
        class_1324 speedAttribute = Objects.requireNonNull(this.method_5996(class_5134.field_23719));
        class_1324 attackAttribute = Objects.requireNonNull(this.method_5996(class_5134.field_23721));
        if (job.equals(MaidJobs.CRACKER)) {
            if (speedAttribute.method_6199(ATTRIBUTE_ID_CRACKER_SLOW) == null) {
                speedAttribute.method_26835(new class_1322(ATTRIBUTE_ID_CRACKER_SLOW, "Cracker slow", -0.25, class_1322.class_1323.field_6331));
            }
            if (attackAttribute.method_6199(ATTRIBUTE_ID_CRACKER_DAMAGE) == null) {
                attackAttribute.method_26835(new class_1322(ATTRIBUTE_ID_CRACKER_DAMAGE, "Cracker attack", 0.4, class_1322.class_1323.field_6331));
            }
        } else {
            if (speedAttribute.method_6199(ATTRIBUTE_ID_CRACKER_SLOW) != null) {
                speedAttribute.method_6200(ATTRIBUTE_ID_CRACKER_SLOW);
            }
            if (attackAttribute.method_6199(ATTRIBUTE_ID_CRACKER_DAMAGE) != null) {
                attackAttribute.method_6200(ATTRIBUTE_ID_CRACKER_DAMAGE);
            }
        }
    }

    public void method_5790() {
        this.field_6189 = this.getJob().equals(MaidJobs.POSEIDON) ? this.canSwimNavigation : this.landNavigation;
        super.method_5790();
    }

    private void pickUpArrows() {
        if (!this.method_37908().method_8608()) {
            class_238 box = this.method_5829().method_1009(1.0, 0.5, 1.0);
            Predicate<class_1665> filter = arrow -> {
                @Nullable class_1297 owner = arrow.method_24921();
                return owner != null && owner.equals((Object)this) && arrow.field_7572 == class_1665.class_1666.field_7593 && (((PersistentProjectileEntityAccessor)arrow).isInGround() || arrow.method_7441()) && arrow.field_7574 <= 0;
            };
            ImmutableList collideArrows = ImmutableList.builder().addAll((Iterable)this.method_37908().method_18023((class_5575)class_1299.field_6122, box, filter)).addAll((Iterable)this.method_37908().method_18023((class_5575)class_1299.field_6135, box, filter)).build();
            for (class_1665 arrow2 : collideArrows) {
                class_1799 arrowStack = ((PersistentProjectileEntityAccessor)arrow2).callAsItemStack();
                if (!this.inventory.method_27070(arrowStack)) continue;
                this.inventory.method_5491(arrowStack);
                this.method_6103((class_1297)arrow2, 1);
                arrow2.method_31472();
            }
        }
    }

    private void pickUpTridents() {
        if (!this.method_37908().method_8608()) {
            class_238 box = this.method_5829().method_1009(1.0, 0.5, 1.0);
            Predicate<class_1685> filter = trident -> {
                @Nullable class_1297 owner = trident.method_24921();
                return owner != null && owner.equals((Object)this) && trident.field_7572 == class_1665.class_1666.field_7593 && (((PersistentProjectileEntityAccessor)trident).isInGround() || trident.method_7441()) && trident.field_7574 <= 0 && ((TridentEntityAccessor)trident).isDealtDamage();
            };
            List collideTridents = this.method_37908().method_18023((class_5575)class_1299.field_6127, box, filter);
            for (class_1685 trident2 : collideTridents) {
                class_1799 tridentStack = ((PersistentProjectileEntityAccessor)trident2).callAsItemStack();
                if (this.method_6047().method_7960()) {
                    this.method_6122(class_1268.field_5808, tridentStack);
                    this.method_6103((class_1297)trident2, 1);
                    trident2.method_31472();
                    continue;
                }
                if (!this.inventory.method_27070(tridentStack)) continue;
                this.inventory.method_5491(tridentStack);
                this.method_6103((class_1297)trident2, 1);
                trident2.method_31472();
            }
        }
    }

    public boolean method_6082(double x, double y, double z, boolean spawnParticles) {
        if (this.canTeleport(class_2338.method_49637((double)x, (double)y, (double)z))) {
            this.field_6189.method_6340();
            this.method_5859(x, y, z);
            if (spawnParticles) {
                this.spawnTeleportParticles();
            }
            return true;
        }
        return false;
    }

    public boolean canTeleport(class_2338 toPos) {
        if (this.getJob().equals(MaidJobs.POSEIDON)) {
            class_7 pathType = this.method_5942().method_6342().method_17((class_1922)this.method_37908(), toPos.method_10263(), toPos.method_10264(), toPos.method_10260());
            if (pathType != class_7.field_12 && pathType != class_7.field_18) {
                return false;
            }
            if (pathType != class_7.field_18 && this.method_37908().method_8320(toPos.method_10074()).method_26204() instanceof class_2397) {
                return false;
            }
        } else {
            class_7 pathType = class_14.method_23476((class_1922)this.method_37908(), (class_2338.class_2339)toPos.method_25503());
            if (pathType != class_7.field_12) {
                return false;
            }
            if (this.method_37908().method_8320(toPos.method_10074()).method_26204() instanceof class_2397) {
                return false;
            }
        }
        return this.method_37908().method_8587((class_1297)this, this.method_5829().method_997(class_243.method_24954((class_2382)toPos).method_1020(this.method_19538())));
    }

    @Override
    public boolean shouldAvoidRain() {
        return !this.getJob().equals(MaidJobs.POSEIDON);
    }

    public void method_5773() {
        super.method_5773();
        if (HeadpatManager.isHeadpatted(this)) {
            this.setFeeling(MaidFeeling.HAPPY);
        } else {
            this.setFeeling(MaidFeeling.NORMAL);
        }
    }

    protected void method_5958() {
        long lastDay;
        long dayTime;
        long currentDay;
        this.updateJob();
        this.getJob().tickBrain(this.method_18868(), this);
        this.method_18868().method_19542((class_3218)this.method_37908(), (class_1309)this);
        this.updateSites();
        this.updatePose();
        if (this.getAction().isPresent() && (this.isEating() || this.isHarvesting() || this.isPlanting() || this.isHealing())) {
            this.field_6189.method_6340();
        }
        MaidAttackType state = this.getAttackType();
        switch (state) {
            case SWING_SWORD_DOWNWARD_RIGHT: 
            case SWING_SWORD_DOWNWARD_LEFT: {
                if (this.attackingTicks == 3) {
                    this.method_6121((class_1297)this.attackingTarget);
                    break;
                }
                if (this.attackingTicks < 10) break;
                this.finishAttack();
                break;
            }
            case SWEEP_SWORD: {
                if (this.attackingTicks == 5) {
                    this.method_6121((class_1297)this.attackingTarget);
                    break;
                }
                if (this.attackingTicks < 10) break;
                this.finishAttack();
                break;
            }
            case SPEAR: {
                if (this.attackingTicks == 24) {
                    this.headbutt();
                    break;
                }
                if (this.attackingTicks < 40) break;
                this.finishAttack();
                break;
            }
            case HEADBUTT: {
                if (this.attackingTicks == 9) {
                    this.method_6121((class_1297)this.attackingTarget);
                    break;
                }
                if (this.attackingTicks < 18) break;
                this.finishAttack();
            }
        }
        if (state != MaidAttackType.NO_ATTACKING) {
            this.method_5942().method_6340();
            ++this.attackingTicks;
        }
        if (this.isEating()) {
            ++this.eatingTicks;
            if (this.eatingTicks % 5 == 0) {
                this.spawnEatingParticles();
            }
            this.field_6189.method_6340();
        }
        if (this.eatingTicks >= 16) {
            if (this.onFinishEating != null) {
                this.onFinishEating.accept(this.method_6079());
            }
            this.onFinishEating = null;
            this.eatingTicks = 0;
            this.method_6079().method_7934(1);
            this.method_18380(class_4050.field_18076);
            this.removeAction();
        } else if (this.eatingTicks > 0 && this.method_18376() == class_4050.field_18076) {
            this.onFinishEating = null;
            this.eatingTicks = 0;
            this.inventory.method_5491(this.method_6079().method_7972());
            this.method_6122(class_1268.field_5810, class_1799.field_8037);
        }
        if (this.method_18376() == ModEntities.POSE_CHANGING_COSTUME) {
            ++this.changingCostumeTicks;
            this.field_6189.method_6340();
        }
        if (this.changingCostumeTicks == 20) {
            this.method_6043();
        }
        if (this.changingCostumeTicks == 25) {
            this.setVariableCostume(!this.isVariableCostume());
        }
        if (this.changingCostumeTicks >= 59) {
            this.method_18380(class_4050.field_18076);
            this.changingCostumeTicks = 0;
        }
        if ((currentDay = (dayTime = this.method_37908().method_8532()) / 24000L) > (lastDay = this.lastClearCommitmentDayTime / 24000L)) {
            this.givenFoods.clear();
            this.increaseCommitment(9, true);
            this.increasedCommitment = 0;
            this.lastClearCommitmentDayTime = dayTime;
        }
        this.field_18321.method_18904(class_4140.field_22355).ifPresentOrElse(this::setAttackTarget, this::removeAttackTarget);
        if (this.attackedCooldown > 0) {
            --this.attackedCooldown;
        } else {
            this.continuityAttackedCount = 0;
        }
    }

    private void updatePose() {
        class_4050 entityPose;
        class_4050 pose = this.method_18376();
        if (pose == ModEntities.POSE_EATING || pose == ModEntities.POSE_CHANGING_COSTUME || pose == ModEntities.POSE_HEALING) {
            return;
        }
        if (this.isGliding()) {
            this.method_18380(ModEntities.POSE_USING_DRIPLEAF);
            return;
        }
        if (!this.method_20233(class_4050.field_18079)) {
            return;
        }
        class_4050 class_40502 = this.method_6128() ? class_4050.field_18077 : (this.method_6113() ? class_4050.field_18078 : (this.method_5681() ? class_4050.field_18079 : (this.method_6123() ? class_4050.field_18080 : (entityPose = this.method_5715() ? class_4050.field_18081 : class_4050.field_18076))));
        class_4050 entityPose2 = this.method_7325() || this.method_5765() || this.method_20233(entityPose) ? entityPose : (this.method_20233(class_4050.field_18081) ? class_4050.field_18081 : class_4050.field_18079);
        this.method_18380(entityPose2);
    }

    private void updateJob() {
        IMaidJob job = MaidJobs.getAllJobs().filter(j -> j.canAssume(this)).max(Comparator.comparingInt(IMaidJob::getPriority)).orElse(MaidJobs.NONE);
        if (!job.equals(this.getJob())) {
            this.setJob(job);
            this.onJobChanged((class_3218)this.method_37908());
        }
    }

    private void onJobChanged(class_3218 world) {
        class_4095<LittleMaidEntity> brain = this.method_18868();
        brain.method_18900(world, (class_1309)this);
        this.field_18321 = brain.method_18911();
        this.getJob().initBrain(this.method_18868(), this);
    }

    private void updateSites() {
        class_1937 world = this.method_37908();
        Optional<class_4208> home = this.getHome();
        if (home.isPresent() && home.get().method_19442().equals(world.method_27983()) && !this.isSettableAsHome(world, home.get().method_19446())) {
            this.removeHome();
        }
        Collection<class_4208> deliveryBoxes = this.getDeliveryBoxes();
        for (class_4208 deliveryBox : deliveryBoxes) {
            if (!deliveryBox.method_19442().equals(world.method_27983()) || this.isSettableAsDeliveryBox(world, deliveryBox.method_19446())) continue;
            this.removeDeliveryBox(deliveryBox);
        }
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 interactItem = player.method_5998(hand);
        if (this.isTamed()) {
            if (player == this.getOwner()) {
                if (player.method_5715()) {
                    if (!this.method_37908().method_8608()) {
                        player.method_17355((class_3908)new LittleMaidScreenHandlerFactory(this));
                    }
                    return class_1269.method_29236((boolean)this.method_37908().method_8608());
                }
                if (interactItem.method_31573(ModTags.ITEM_MAID_HEAL_FOODS) && this.method_18376() != ModEntities.POSE_EATING) {
                    if (!this.method_37908().method_8608()) {
                        class_1799 food = (player.method_31549().field_7477 ? interactItem.method_7972() : interactItem).method_7971(1);
                        this.eatFood(food, foodArg -> this.method_6025(6.5f));
                        class_1792 foodType = food.method_7909();
                        if (!this.givenFoods.contains(foodType)) {
                            this.increaseCommitment(this.getPersonality().isIn(ModTags.PERSONALITY_FLUTTER_WHEN_KINDS) ? 6 : 11, true);
                            this.givenFoods.add(foodType);
                        }
                    }
                    return class_1269.method_29236((boolean)this.method_37908().method_8608());
                }
                if (interactItem.method_31573(ModTags.ITEM_MAID_REINFORCE_FOODS) && this.method_18376() != ModEntities.POSE_EATING) {
                    if (!this.method_37908().method_8608()) {
                        class_1799 food = (player.method_31549().field_7477 ? interactItem.method_7972() : interactItem).method_7971(1);
                        this.eatFood(food, foodArg -> {
                            if (food.method_19267()) {
                                for (Pair effect : Objects.requireNonNull(food.method_7909().method_19264()).method_19235()) {
                                    if (!(this.method_37908().method_8409().method_43057() < ((Float)effect.getSecond()).floatValue())) continue;
                                    this.method_6092(new class_1293((class_1293)effect.getFirst()));
                                }
                            }
                        });
                        class_1792 foodType = food.method_7909();
                        if (!this.givenFoods.contains(foodType)) {
                            this.increaseCommitment(this.getPersonality().isIn(ModTags.PERSONALITY_FLUTTER_WHEN_KINDS) ? 50 : 70, true);
                            this.givenFoods.add(foodType);
                        }
                    }
                    return class_1269.method_29236((boolean)this.method_37908().method_8608());
                }
                if (interactItem.method_31573(ModTags.ITEM_MAID_CHANGE_COSTUMES) && this.method_18376() != ModEntities.POSE_CHANGING_COSTUME) {
                    if (!this.method_37908().method_8608()) {
                        this.method_18380(ModEntities.POSE_CHANGING_COSTUME);
                        this.field_6189.method_6340();
                        if (!player.method_31549().field_7477) {
                            interactItem.method_7934(1);
                        }
                    }
                    return class_1269.method_29236((boolean)this.method_37908().method_8608());
                }
                if (interactItem.method_31573(ModTags.ITEM_MAID_INSTRUCTORS)) {
                    if (!this.method_37908().method_8608()) {
                        IInstructionComponent instructionComponent = (IInstructionComponent)player.getComponent(Components.INSTRUCTION);
                        if (instructionComponent.isInstructing()) {
                            instructionComponent.cancelInstruction();
                        } else {
                            instructionComponent.startInstruction(this);
                        }
                    }
                    return class_1269.method_29236((boolean)this.method_37908().method_8608());
                }
                if (interactItem.method_31574(class_1802.field_8688)) {
                    if (!this.method_37908().method_8608()) {
                        List allPersonalities = ModRegistries.MAID_PERSONALITY.method_10220().toList();
                        int currentIndex = allPersonalities.indexOf(this.getPersonality());
                        if (currentIndex + 1 < allPersonalities.size()) {
                            this.setPersonality((MaidPersonality)allPersonalities.get(currentIndex + 1));
                        } else {
                            this.setPersonality((MaidPersonality)allPersonalities.get(0));
                        }
                        this.initializeAttributes();
                        ((class_3222)player).method_43502((class_2561)class_2561.method_43469((String)(class_1802.field_8688.method_7876() + ".select"), (Object[])new Object[]{KEY_PERSONALITY, ModRegistries.MAID_PERSONALITY.method_10221((Object)this.getPersonality())}), true);
                    }
                    return class_1269.method_29236((boolean)this.method_37908().method_8608());
                }
                if (!this.method_37908().method_8608()) {
                    this.setMode(this.getMode().getNext());
                    player.method_7353(this.getMode().getMessage(this), true);
                }
                return class_1269.method_29236((boolean)this.method_37908().method_8608());
            }
        } else if (interactItem.method_31573(ModTags.ITEM_MAID_CONTRACT_FOODS) && this.method_18376() != ModEntities.POSE_EATING) {
            if (!this.method_37908().method_8608()) {
                class_1799 food = (player.method_31549().field_7477 ? interactItem.method_7972() : interactItem).method_7971(1);
                this.eatFood(food, foodArg -> {
                    this.setMaster(player);
                    this.spawnContractParticles();
                    this.playContractSound();
                });
                this.field_18321.method_18878(class_4140.field_18446, (Object)new class_4102((class_1297)player, true));
            }
            return class_1269.method_29236((boolean)this.method_37908().method_8608());
        }
        return super.method_5992(player, hand);
    }

    public void method_6005(double strength, double x, double z) {
        if (this.getPersonality().isIn(ModTags.PERSONALITY_PERSISTENCES) || this.getAttackType() != MaidAttackType.NO_ATTACKING) {
            return;
        }
        super.method_6005(strength, x, z);
    }

    public void eatFood(class_1799 food, Consumer<class_1799> onFinishEating) {
        this.method_6122(class_1268.field_5810, food);
        this.onFinishEating = onFinishEating;
        this.playEatSound(food);
        this.field_18321.method_18875(class_4140.field_18445);
        this.field_18321.method_18875(class_4140.field_18446);
        this.method_18380(ModEntities.POSE_EATING);
        this.setAction(MaidAction.EATING);
    }

    public boolean method_6121(class_1297 target) {
        boolean damagePassed;
        IMaidJob job = this.getJob();
        if (job.equals(MaidJobs.FENCER)) {
            this.playFencerAttackSound();
        } else if (job.equals(MaidJobs.CRACKER)) {
            this.playCrackerAttackSound();
        }
        double damage = (float)this.method_26825(class_5134.field_23721);
        double knockback = (float)this.method_26825(class_5134.field_23722);
        int fireLevel = class_1890.method_8199((class_1309)this);
        if (target instanceof class_1309) {
            class_1309 living = (class_1309)target;
            damage += (double)class_1890.method_8218((class_1799)this.method_6047(), (class_1310)living.method_6046());
            knockback += (double)class_1890.method_8205((class_1309)this);
            if (living instanceof class_1308) {
                class_1308 mob = (class_1308)living;
                @Nullable class_1309 targetTarget = mob.method_5968();
                @Nullable class_1297 owner = this.getOwner();
                if (targetTarget != null && owner != null && targetTarget.equals((Object)owner) && this.getPersonality().isIn(ModTags.PERSONALITY_DEVOTE_WHEN_ATTACK_OWNERS_ENEMIES)) {
                    damage *= 1.0 + (double)this.getCommitment() / 500.0;
                }
            }
        }
        if (fireLevel > 0) {
            target.method_5639(fireLevel * 4);
        }
        if (damagePassed = target.method_5643(target.method_48923().method_48812((class_1309)this), (float)damage)) {
            class_1657 player;
            class_1309 living;
            class_1799 itemStack = this.method_6047();
            if (knockback > 0.0 && target instanceof class_1309) {
                living = (class_1309)target;
                double xStrength = Math.sin((double)this.method_36454() * Math.PI / 180.0);
                double zStrength = -Math.cos((double)this.method_36454() * Math.PI / 180.0);
                living.method_6005(knockback * 0.5, xStrength, zStrength);
                this.method_18799(this.method_18798().method_18805(0.6, 1.0, 0.6));
            }
            if (target instanceof class_1657 && (player = (class_1657)target).method_6115()) {
                ((MobEntityAccessor)((Object)this)).callDisablePlayerShield(player, itemStack, player.method_6030());
            }
            this.method_5723((class_1309)this, target);
            this.method_6114(target);
            if (target instanceof class_1309) {
                living = (class_1309)target;
                itemStack.method_7909().method_7873(itemStack, living, (class_1309)this);
                if (itemStack.method_7960()) {
                    this.method_6122(class_1268.field_5808, class_1799.field_8037);
                }
                if (living.method_29504()) {
                    if (this.method_6032() <= this.method_6063() * 0.3f) {
                        this.playKilledBarelySound();
                    } else {
                        this.playKilledSound();
                    }
                }
            }
        }
        return damagePassed;
    }

    private void headbutt() {
        boolean damagePassed = Objects.requireNonNull(this.attackingTarget).method_5643(this.attackingTarget.method_48923().method_48812((class_1309)this), 5.0f);
        if (damagePassed) {
            double xDir = Math.sin((double)this.method_36454() * Math.PI / 180.0);
            double zDir = -Math.cos((double)this.method_36454() * Math.PI / 180.0);
            this.attackingTarget.method_6005((double)1.6f, xDir, zDir);
        }
    }

    public void startAttack(class_1309 target, MaidAttackType type) {
        this.setAttackType(type);
        this.attackingTarget = target;
        this.attackingTicks = 0;
    }

    public void finishAttack() {
        this.setAttackType(MaidAttackType.NO_ATTACKING);
        this.attackingTarget = null;
        this.attackingTicks = 0;
    }

    public void method_7105(class_1309 target, float pullProgress) {
        class_1799 mainStack = this.method_6047();
        if (this.getJob().equals(MaidJobs.ARCHER)) {
            class_1799 arrow = this.method_18808(mainStack);
            if (arrow.method_7960()) {
                return;
            }
            boolean consumeArrow = !ModUtils.hasEnchantment(class_1893.field_9125, mainStack) || arrow.method_31574(class_1802.field_8087) || arrow.method_31574(class_1802.field_8236);
            class_1665 projectile = class_1675.method_18813((class_1309)this, (class_1799)arrow, (float)pullProgress);
            double xVelocity = target.method_23317() - this.method_23317();
            double yVelocity = target.method_23323(0.3333333333333333) - projectile.method_23318();
            double zVelocity = target.method_23321() - this.method_23321();
            double power = Math.sqrt(xVelocity * xVelocity + zVelocity * zVelocity);
            projectile.method_7485(xVelocity, yVelocity + power * 0.2, zVelocity, 1.6f, 6.0f);
            projectile.field_7572 = consumeArrow ? class_1665.class_1666.field_7593 : class_1665.class_1666.field_7594;
            this.method_37908().method_8649((class_1297)projectile);
            this.method_5783(class_3417.field_14600, 1.0f, 1.0f / (this.method_6051().method_43057() * 0.4f + 0.8f));
            this.playArcherAttackSound();
            mainStack.method_7956(1, (class_1309)this, entity -> {});
            if (consumeArrow) {
                arrow.method_7934(1);
            }
        } else if (this.getJob().equals(MaidJobs.HUNTER)) {
            this.method_24654((class_1309)this, 1.6f);
        }
    }

    @Override
    public void throwTrident(class_1297 target) {
        class_1799 mainStack = this.method_6047();
        if (class_1890.method_8202((class_1799)mainStack) > 0) {
            return;
        }
        class_1685 trident = new class_1685(this.method_37908(), (class_1309)this, mainStack);
        double x = target.method_23317() - this.method_23317();
        double y = target.method_23323(0.3333333333333333) - trident.method_23318();
        double z = target.method_23321() - this.method_23321();
        double power = Math.sqrt(x * x + z * z);
        trident.method_7485(x, y + power * 0.2, z, 1.6f, 6.0f);
        trident.field_7572 = class_1665.class_1666.field_7593;
        this.method_37908().method_8649((class_1297)trident);
        mainStack.method_7956(1, (class_1309)this, selfValue -> selfValue.method_20236(this.method_6058()));
        mainStack.method_7934(1);
        this.method_5783(class_3417.field_14753, 1.0f, 1.0f / (this.method_6051().method_43057() * 0.4f + 0.8f));
        if (mainStack.method_7947() <= 0) {
            this.method_6122(class_1268.field_5808, class_1799.field_8037);
            this.field_18321.method_24525(ModMemories.THROWN_TRIDENT_COOLDOWN, (Object)class_3902.field_17274, 200L);
            if (class_1890.method_8206((class_1799)trident.method_7445()) <= 0) {
                this.field_18321.method_24525(ModMemories.THROWN_TRIDENT, (Object)trident, 200L);
            }
        }
    }

    protected void method_5997(class_1309 target) {
        this.method_6121((class_1297)target);
    }

    public void method_7110(boolean charging) {
    }

    public void method_18811(class_1309 target, class_1799 crossbow, class_1676 projectile, float multiShotSpray) {
        this.method_24652((class_1309)this, target, projectile, multiShotSpray, 1.6f);
    }

    public void method_24651() {
    }

    public boolean method_25938(class_1811 weapon) {
        return this.getJob().equals(MaidJobs.ARCHER) || this.getJob().equals(MaidJobs.POSEIDON) || this.getJob().equals(MaidJobs.HUNTER);
    }

    @Nullable
    public class_1309 method_5968() {
        return this.getAttackTarget().orElse(null);
    }

    public boolean method_5679(class_1282 source) {
        @Nullable UUID owner = this.getMasterUuid();
        @Nullable class_1297 attacker = source.method_5529();
        if (owner != null && attacker instanceof class_1657) {
            class_1657 player = (class_1657)attacker;
            return owner.equals(player.method_5667());
        }
        if (attacker != null && attacker.method_5864().equals(ModEntities.LITTLE_MAID)) {
            return true;
        }
        return super.method_5679(source);
    }

    public boolean method_5643(class_1282 source, float amount) {
        boolean result = super.method_5643(source, amount);
        if (!this.method_37908().method_8608() && (result || this.damageBlocked)) {
            if (this.attackedCooldown > 0) {
                ++this.continuityAttackedCount;
            }
            this.attackedCooldown = 40;
        }
        this.damageBlocked = false;
        if (!this.method_37908().method_8608() && this.isSitting()) {
            this.setMode(MaidMode.FREE);
        }
        return result;
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 source) {
        if (this.isGliding()) {
            return false;
        }
        return super.method_5747(fallDistance, damageMultiplier, source);
    }

    public void method_6105(class_1282 source, float amount) {
        this.damageArmor(source, amount, this.method_6118(class_1304.field_6166));
        this.damageArmor(source, amount, this.method_6118(class_1304.field_6169));
    }

    public void method_36977(class_1282 source, float amount) {
        this.damageArmor(source, amount, this.method_6118(class_1304.field_6169));
    }

    private void damageArmor(class_1282 source, float amount, class_1799 itemStack) {
        float f;
        if (amount <= 0.0f) {
            return;
        }
        if (!(itemStack.method_7909() instanceof class_1738)) {
            return;
        }
        if (source.method_48789(class_8103.field_42246) && itemStack.method_7909().method_24358()) {
            return;
        }
        amount /= 4.0f;
        if (f < 1.0f) {
            amount = 1.0f;
        }
        itemStack.method_7956((int)amount, (class_1309)this, maid -> {});
    }

    public void method_6056(float amount) {
        if (!this.field_6277.method_31574(class_1802.field_8255)) {
            return;
        }
        this.damageBlocked = true;
        if (!this.method_37908().field_9236) {
            this.method_5783(class_3417.field_15150, 1.0f, 0.8f + this.method_37908().method_8409().method_43057() * 0.4f);
        }
        if (amount >= 3.0f) {
            int damage = 1 + class_3532.method_15375((float)amount);
            class_1268 hand = this.method_6058();
            this.field_6277.method_7956(damage, (class_1309)this, entity -> {});
            if (this.field_6277.method_7960()) {
                if (hand == class_1268.field_5808) {
                    this.method_5673(class_1304.field_6173, class_1799.field_8037);
                } else {
                    this.method_5673(class_1304.field_6171, class_1799.field_8037);
                }
                this.field_6277 = class_1799.field_8037;
                this.method_5783(class_3417.field_15239, 0.8f, 0.8f + this.method_37908().method_8409().method_43057() * 0.4f);
            }
        }
    }

    protected int method_6064(int air) {
        return Math.min(air + 10, this.method_5748());
    }

    public void method_18403(class_2338 pos) {
        super.method_18403(pos);
        this.field_18321.method_18875(class_4140.field_18445);
        this.field_18321.method_18875(class_4140.field_19293);
        this.field_18321.method_18875(class_4140.field_18446);
    }

    public void method_18400() {
        super.method_18400();
        this.field_18321.method_18878(class_4140.field_20616, (Object)this.method_37908().method_8510());
        this.field_18321.method_18875(ModMemories.SLEEP_POS);
        this.field_18321.method_18875(class_4140.field_18445);
        this.field_18321.method_18875(class_4140.field_18446);
    }

    protected void method_6013(class_1282 source) {
        if (!this.damageBlocked) {
            super.method_6013(source);
        }
    }

    public class_1799 method_18808(class_1799 itemStack) {
        class_1792 class_17922 = itemStack.method_7909();
        if (class_17922 instanceof class_1811) {
            class_1811 rangedItem = (class_1811)class_17922;
            Predicate projectiles = rangedItem.method_20310();
            class_1799 heldProjectile = class_1811.method_18815((class_1309)this, (Predicate)projectiles);
            if (!heldProjectile.method_7960()) {
                return heldProjectile;
            }
            projectiles = rangedItem.method_19268();
            for (int i = 0; i < this.inventory.method_5439(); ++i) {
                class_1799 inventoryStack = this.inventory.method_5438(i);
                if (!projectiles.test(inventoryStack)) continue;
                return inventoryStack;
            }
        }
        return class_1799.field_8037;
    }

    public boolean hasArrow() {
        boolean hasArrowInInventory;
        class_1799 ranged = this.method_6047();
        boolean bl = hasArrowInInventory = !this.method_18808(ranged).method_7960();
        if (!ranged.method_31574(class_1802.field_8399)) {
            return hasArrowInInventory;
        }
        return hasArrowInInventory || class_1764.method_7781((class_1799)ranged);
    }

    public class_1799 getHasChorusFruit() {
        if (this.method_6079().method_31573(ModTags.ITEM_MAID_CROPS)) {
            return this.method_6079();
        }
        for (int i = 0; i < this.inventory.method_5439(); ++i) {
            class_1799 itemStack = this.inventory.method_5438(i);
            if (!itemStack.method_31573(ModTags.ITEM_MAID_CHORUS_FRUITS)) continue;
            return itemStack;
        }
        return class_1799.field_8037;
    }

    public boolean canBreakGourd() {
        return this.getCommitment() >= 75;
    }

    public boolean hasDripleaf() {
        for (int i = 0; i < this.inventory.method_5439(); ++i) {
            if (!this.inventory.method_5438(i).method_31573(ModTags.ITEM_MAID_DRIPLEAFS)) continue;
            return true;
        }
        return false;
    }

    public void method_5711(byte status) {
        if (status == 7) {
            class_2400 particleEffect = class_2398.field_11201;
            for (int i = 0; i < 7; ++i) {
                double d = this.field_5974.method_43059() * 0.02;
                double e = this.field_5974.method_43059() * 0.02;
                double f = this.field_5974.method_43059() * 0.02;
                this.method_37908().method_8406((class_2394)particleEffect, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), d, e, f);
            }
        } else {
            super.method_5711(status);
        }
    }

    public void spawnContractParticles() {
        class_2400 particle = class_2398.field_11201;
        for (int i = 0; i < 7; ++i) {
            double x = this.field_5974.method_43059() * 0.02;
            double y = this.field_5974.method_43059() * 0.02;
            double z = this.field_5974.method_43059() * 0.02;
            ((class_3218)this.method_37908()).method_14199((class_2394)particle, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), 0, x, y, z, 1.0);
        }
    }

    public void spawnEatingParticles() {
        if (!this.method_37908().method_8608()) {
            for (int i = 0; i < 6; ++i) {
                double y = -this.field_5974.method_43058() * 0.6 - 0.3;
                class_243 pos = new class_243((this.field_5974.method_43058() - 0.5) * 0.3, y, 0.6).method_1037(-this.method_36455() * ((float)Math.PI / 180)).method_1024(-this.field_6283 * ((float)Math.PI / 180)).method_1031(this.method_23317(), this.method_23320(), this.method_23321());
                class_243 delta = new class_243((this.field_5974.method_43058() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).method_1037(-this.method_36455() * ((float)Math.PI / 180)).method_1024(-this.method_36454() * ((float)Math.PI / 180));
                for (class_3222 target : ((class_3218)this.method_37908()).method_18456()) {
                    class_2540 packet = PacketByteBufs.create();
                    packet.method_10793(this.method_6079());
                    packet.writeDouble(pos.method_10216());
                    packet.writeDouble(pos.method_10214());
                    packet.writeDouble(pos.method_10215());
                    packet.writeDouble(delta.method_10216());
                    packet.writeDouble(delta.method_10214());
                    packet.writeDouble(delta.method_10215());
                    ServerPlayNetworking.send((class_3222)target, (class_2960)NetworkHandler.CHANNEL_MAID_EAT_PARTICLE, (class_2540)packet);
                }
            }
        }
    }

    public void spawnTeleportParticles() {
        if (!this.method_37908().method_8608()) {
            for (int i = 0; i < 128; ++i) {
                double delta = (double)i / 127.0;
                double xPos = class_3532.method_16436((double)delta, (double)this.field_6014, (double)this.method_23317()) + (this.field_5974.method_43058() - 0.5) * (double)this.method_17681() * 2.0;
                double yPos = class_3532.method_16436((double)delta, (double)this.field_6036, (double)this.method_23318()) + this.field_5974.method_43058() * (double)this.method_17682();
                double zPos = class_3532.method_16436((double)delta, (double)this.field_5969, (double)this.method_23321()) + (this.field_5974.method_43058() - 0.5) * (double)this.method_17681() * 2.0;
                float xDelta = (this.field_5974.method_43057() - 0.5f) * 0.2f;
                float yDelta = (this.field_5974.method_43057() - 0.5f) * 0.2f;
                float zDelta = (this.field_5974.method_43057() - 0.5f) * 0.2f;
                ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11214, xPos, yPos, zPos, 0, (double)xDelta, (double)yDelta, (double)zDelta, 1.0);
            }
        }
    }

    private void spawnSingleParticle(class_2394 particle) {
        if (!this.method_37908().method_8608()) {
            ((class_3218)this.method_37908()).method_14199(particle, this.method_23317(), this.method_23318() + 1.2, this.method_23321(), 0, 1.0, 0.0, 0.0, 1.0);
        }
    }

    protected void method_16078() {
        for (int i = 0; i < this.inventory.method_5439(); ++i) {
            class_1799 itemStack = this.inventory.method_5438(i);
            if (itemStack.method_7960() || class_1890.method_8221((class_1799)itemStack)) continue;
            this.method_5775(itemStack);
        }
    }

    public boolean method_5973(class_1299<?> type) {
        return !this.isSitting() && super.method_5973(type);
    }

    public boolean method_18395(class_1309 living) {
        return !this.isSitting() && super.method_18395(living);
    }

    protected void method_5949(class_1542 item) {
        class_6067.method_43544((class_1308)this, (class_6067)this, (class_1542)item);
    }

    public boolean method_5939(class_1799 itemStack) {
        if (this.getJob().equals(MaidJobs.FARMER)) {
            return itemStack.method_31573(ModTags.ITEM_MAID_PRODUCTS);
        }
        return false;
    }

    public static boolean canSpawn(class_1299<LittleMaidEntity> ignoredType, class_5425 world, class_3730 ignoredReason, class_2338 pos, class_5819 ignoredRandom) {
        return world.method_8320(pos.method_10074()).method_26164(class_3481.field_35573) && world.method_22335(pos, 0) > 8;
    }

    public boolean method_17326() {
        return this.isTamed();
    }

    public class_1277 method_35199() {
        return this.inventory;
    }

    public class_4095<LittleMaidEntity> method_18868() {
        return super.method_18868();
    }

    @Nullable
    private UUID getMasterUuid() {
        return ((Optional)this.field_6011.method_12789(MASTER)).orElse(null);
    }

    private void setMasterUuid(@Nullable UUID uuid) {
        this.field_6011.method_12778(MASTER, Optional.ofNullable(uuid));
    }

    @Nullable
    public class_1297 getOwner() {
        UUID uuid = this.getMasterUuid();
        if (uuid == null) {
            return null;
        }
        return this.method_37908().method_18470(uuid);
    }

    @Override
    public Optional<class_1657> getMaster() {
        return Optional.ofNullable(this.getMasterUuid()).map(id -> this.method_37908().method_18470(id));
    }

    private void setMaster(class_1657 master) {
        this.setMasterUuid(master.method_5667());
    }

    public boolean isTamed() {
        return this.getMasterUuid() != null;
    }

    public MaidMode getMode() {
        return (MaidMode)((Object)this.field_6011.method_12789(MODE));
    }

    private void setMode(MaidMode value) {
        this.field_6011.method_12778(MODE, (Object)value);
        if (value == MaidMode.WAIT) {
            this.field_18321.method_18878(ModMemories.IS_SITTING, (Object)class_3902.field_17274);
        } else {
            this.field_18321.method_18875(ModMemories.IS_SITTING);
        }
        if (value == MaidMode.FREE) {
            this.setAnchor(class_4208.method_19443((class_5321)this.method_37908().method_27983(), (class_2338)this.method_24515()));
        } else {
            this.removeAnchor();
        }
    }

    @Override
    public boolean isFollowingMaster() {
        return this.field_6011.method_12789(MODE) == MaidMode.FOLLOW;
    }

    @Override
    public boolean isSitting() {
        return this.field_6011.method_12789(MODE) == MaidMode.WAIT;
    }

    @Override
    public boolean isHeadpatted() {
        if (this.getMaster().isPresent()) {
            return HeadpatManager.isHeadpattingWith(this.getMaster().get(), (class_1297)this);
        }
        return false;
    }

    @Override
    public Optional<class_4208> getHome() {
        return (Optional)this.field_6011.method_12789(HOME);
    }

    @Override
    public void setHome(class_4208 value) {
        this.field_6011.method_12778(HOME, Optional.of(value));
        this.field_18321.method_18879(class_4140.field_18438, Optional.of(value));
    }

    @Override
    public void removeHome() {
        this.field_6011.method_12778(HOME, Optional.empty());
        this.field_18321.method_18875(class_4140.field_18438);
    }

    @Override
    public boolean isSettableAsHome(class_1937 world, class_2338 pos) {
        return world.method_8320(pos).method_26164(ModTags.BLOCK_MAID_SETTABLE_AS_HOME);
    }

    @Override
    public Optional<class_4208> getAnchor() {
        return (Optional)this.field_6011.method_12789(ANCHOR);
    }

    @Override
    public void setAnchor(class_4208 value) {
        this.field_6011.method_12778(ANCHOR, Optional.of(value));
        this.field_18321.method_18879(ModMemories.ANCHOR, Optional.of(value));
    }

    @Override
    public void removeAnchor() {
        this.field_6011.method_12778(ANCHOR, Optional.empty());
        this.field_18321.method_18875(ModMemories.ANCHOR);
    }

    @Override
    public Collection<class_4208> getDeliveryBoxes() {
        return (Collection)this.field_6011.method_12789(DELIVERY_BOXES);
    }

    @Override
    public void addDeliveryBox(class_4208 value) {
        Collection boxes = (Collection)this.field_6011.method_12789(DELIVERY_BOXES);
        boxes.add(value);
        this.field_6011.method_49743(DELIVERY_BOXES, (Object)boxes, true);
    }

    @Override
    public void removeDeliveryBox(class_4208 value) {
        Collection boxes = (Collection)this.field_6011.method_12789(DELIVERY_BOXES);
        boxes.remove(value);
        this.field_6011.method_49743(DELIVERY_BOXES, (Object)boxes, true);
    }

    @Override
    public boolean isSettableAsDeliveryBox(class_1937 world, class_2338 pos) {
        return world.method_8320(pos).method_26164(ModTags.BLOCK_MAID_SETTABLE_AS_DELIVERY_BOX);
    }

    public IMaidJob getJob() {
        return (IMaidJob)this.field_6011.method_12789(JOB);
    }

    public void setJob(IMaidJob value) {
        this.field_6011.method_12778(JOB, (Object)value);
    }

    public MaidPersonality getPersonality() {
        return (MaidPersonality)this.field_6011.method_12789(PERSONALITY);
    }

    public void setPersonality(MaidPersonality value) {
        this.field_6011.method_12778(PERSONALITY, (Object)value);
    }

    @Override
    public Optional<MaidAction> getAction() {
        return (Optional)this.field_6011.method_12789(ACTION);
    }

    @Override
    public void setAction(MaidAction value) {
        this.field_6011.method_12778(ACTION, Optional.of(value));
    }

    @Override
    public void removeAction() {
        this.field_6011.method_12778(ACTION, Optional.empty());
    }

    @Deprecated
    public IMaidFeeling getFeeling() {
        return (IMaidFeeling)this.field_6011.method_12789(FEELING);
    }

    public void setFeeling(IMaidFeeling value) {
        this.field_6011.method_12778(FEELING, (Object)value);
    }

    public boolean isIdle() {
        return this.field_18321.method_18906(class_4168.field_18595);
    }

    public boolean isGliding() {
        return this.getAction().map(action -> action.equals((Object)MaidAction.GLIDING)).orElse(false);
    }

    @Override
    public boolean isEating() {
        return this.getAction().map(action -> action.equals((Object)MaidAction.EATING)).orElse(false);
    }

    public boolean isVariableCostume() {
        return (Boolean)this.field_6011.method_12789(IS_VARIABLE_COSTUME);
    }

    private void setVariableCostume(boolean value) {
        this.field_6011.method_12778(IS_VARIABLE_COSTUME, (Object)value);
    }

    public int getCommitment() {
        return (Integer)this.field_6011.method_12789(COMMITMENT);
    }

    private void setCommitment(int value) {
        this.field_6011.method_12778(COMMITMENT, (Object)value);
    }

    public Optional<class_1309> getAttackTarget() {
        return ((Optional)this.field_6011.method_12789(ATTACK_TARGET)).map(id -> (class_1309)this.method_37908().method_8469(id.intValue()));
    }

    public void setAttackTarget(class_1309 value) {
        this.field_6011.method_12778(ATTACK_TARGET, Optional.of(value.method_5628()));
    }

    public void removeAttackTarget() {
        this.field_6011.method_12778(ATTACK_TARGET, Optional.empty());
    }

    public MaidAttackType getAttackType() {
        return (MaidAttackType)((Object)this.field_6011.method_12789(ATTACK_TYPE));
    }

    public void setAttackType(MaidAttackType value) {
        this.field_6011.method_12778(ATTACK_TYPE, (Object)value);
    }

    public void increaseCommitment(int value, boolean force) {
        if (force) {
            if (this.increasedCommitment + value > 30) {
                value -= this.increasedCommitment + value - 30;
            }
            this.increasedCommitment += value;
        }
        if (value > 0) {
            this.setCommitment(Math.min(this.getCommitment() + value, 300));
            this.spawnSingleParticle((class_2394)class_2398.field_11201);
        }
    }

    public int getContinuityAttackedCount() {
        return this.continuityAttackedCount;
    }

    public void resetContinuityAttackedCount() {
        this.continuityAttackedCount = 0;
    }

    public float method_6017() {
        return 1.0f;
    }

    @Nullable
    protected class_3414 method_5994() {
        return this.getPersonality().getAmbientSound();
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return this.getPersonality().getHurtSound();
    }

    @Nullable
    protected class_3414 method_6002() {
        return this.getPersonality().getDeathSound();
    }

    public class_3414 method_18869(class_1799 stack) {
        return this.getPersonality().getEatSound();
    }

    public void method_5966() {
        if (!this.method_37908().method_8608() && this.isIdle()) {
            this.method_5783(this.method_5994(), this.method_6107(), this.method_6017());
        }
    }

    public void playFencerAttackSound() {
        this.method_5783(this.getPersonality().getFencerAttackSound(), this.method_6107(), this.method_6017());
    }

    public void playCrackerAttackSound() {
        this.method_5783(this.getPersonality().getCrackerAttackSound(), this.method_6107(), this.method_6017());
    }

    public void playArcherAttackSound() {
        this.method_5783(this.getPersonality().getArcherAttackSound(), this.method_6107(), this.method_6017());
    }

    public void playKilledSound() {
        this.method_5783(this.getPersonality().getKilledSound(), this.method_6107(), this.method_6017());
    }

    public void playKilledBarelySound() {
        this.method_5783(this.getPersonality().getKilledBarelySound(), this.method_6107(), this.method_6017());
    }

    public void playEatSound(class_1799 itemStack) {
        this.method_5783(this.method_18869(itemStack), this.method_6107(), this.method_6017());
    }

    public void playContractSound() {
        this.method_5783(this.getPersonality().getContractSound(), this.method_6107(), this.method_6017());
    }

    public void playSitSound() {
        this.method_5783(this.getPersonality().getSitSound(), this.method_6107(), this.method_6017());
    }

    public void playEngageSound() {
        this.method_5783(this.getPersonality().getEngageSound(), this.method_6107(), this.method_6017());
    }

    public int method_5970() {
        return 300;
    }

    public void method_5652(class_2487 nbt) {
        class_2960 personality;
        super.method_5652(nbt);
        class_2499 inventoryNbt = new class_2499();
        for (int i = 0; i < this.inventory.method_5439(); ++i) {
            class_1799 itemStack = this.inventory.method_5438(i);
            if (itemStack.method_7960()) continue;
            class_2487 nbtCompound = new class_2487();
            nbtCompound.method_10569(KEY_SLOT, i);
            itemStack.method_7953(nbtCompound);
            inventoryNbt.add((Object)nbtCompound);
        }
        nbt.method_10566(KEY_INVENTORY, (class_2520)inventoryNbt);
        class_2499 givenFoodsNbt = new class_2499();
        for (class_1792 givenFood : this.givenFoods) {
            givenFoodsNbt.add((Object)class_2519.method_23256((String)class_7923.field_41178.method_10221((Object)givenFood).toString()));
        }
        nbt.method_10566(KEY_GIVEN_FOODS, (class_2520)givenFoodsNbt);
        UUID uuid = this.getMasterUuid();
        if (uuid != null) {
            nbt.method_25927(KEY_OWNER, uuid);
        }
        nbt.method_10569(KEY_MODE, this.getMode().getId());
        @Nullable class_2960 job = ModRegistries.MAID_JOB.method_10221((Object)this.getJob());
        if (job != null) {
            nbt.method_10582(KEY_JOB, job.toString());
        }
        if ((personality = ModRegistries.MAID_PERSONALITY.method_10221((Object)this.getPersonality())) != null) {
            nbt.method_10582(KEY_PERSONALITY, personality.toString());
        }
        nbt.method_10556(KEY_IS_VARIABLE_COSTUME, this.isVariableCostume());
        nbt.method_10569(KEY_COMMITMENT, this.getCommitment());
        this.getHome().map(ModUtils.Conversions::globalPosToNBT).ifPresent(n -> nbt.method_10566(KEY_HOME, n));
        this.getAnchor().map(ModUtils.Conversions::globalPosToNBT).ifPresent(n -> nbt.method_10566(KEY_ANCHOR, n));
        class_2499 boxesNBT = new class_2499();
        this.getDeliveryBoxes().stream().map(ModUtils.Conversions::globalPosToNBT).forEach(arg_0 -> boxesNBT.add(arg_0));
        nbt.method_10566(KEY_DELIVERY_BOXES, (class_2520)boxesNBT);
    }

    public void method_5749(class_2487 nbt) {
        UUID uuid;
        super.method_5749(nbt);
        class_2499 inventoryNbt = nbt.method_10554(KEY_INVENTORY, 10);
        for (int i = 0; i < inventoryNbt.size(); ++i) {
            class_2487 nbtCompound = inventoryNbt.method_10602(i);
            this.inventory.method_5447(nbtCompound.method_10550(KEY_SLOT), class_1799.method_7915((class_2487)nbtCompound));
        }
        class_2499 givenFoodsNbt = nbt.method_10554(KEY_GIVEN_FOODS, 8);
        for (int i = 0; i < givenFoodsNbt.size(); ++i) {
            class_1792 foodType = (class_1792)class_7923.field_41178.method_10223(class_2960.method_12829((String)givenFoodsNbt.method_10608(i)));
            if (foodType == class_1802.field_8162) continue;
            this.givenFoods.add(foodType);
        }
        if (nbt.method_25928(KEY_OWNER)) {
            uuid = nbt.method_25926(KEY_OWNER);
        } else {
            String string = nbt.method_10558(KEY_OWNER);
            uuid = class_3321.method_14546((MinecraftServer)this.method_5682(), (String)string);
        }
        this.setMasterUuid(uuid);
        this.setMode(MaidMode.fromId(nbt.method_10550(KEY_MODE)));
        if (nbt.method_10545(KEY_JOB)) {
            this.setJob((IMaidJob)ModRegistries.MAID_JOB.method_10223(class_2960.method_12829((String)nbt.method_10558(KEY_JOB))));
            this.getJob().initBrain(this.method_18868(), this);
        }
        if (nbt.method_10545(KEY_PERSONALITY)) {
            this.setPersonality((MaidPersonality)ModRegistries.MAID_PERSONALITY.method_10223(class_2960.method_12829((String)nbt.method_10558(KEY_PERSONALITY))));
        }
        this.setVariableCostume(nbt.method_10577(KEY_IS_VARIABLE_COSTUME));
        this.setCommitment(nbt.method_10550(KEY_COMMITMENT));
        if (nbt.method_10545(KEY_HOME)) {
            this.setHome(ModUtils.Conversions.nbtToGlobalPos(nbt.method_10580(KEY_HOME)));
        }
        if (nbt.method_10545(KEY_ANCHOR)) {
            this.setAnchor(ModUtils.Conversions.nbtToGlobalPos(nbt.method_10580(KEY_ANCHOR)));
        }
        class_2499 boxesNBT = nbt.method_10554(KEY_DELIVERY_BOXES, 10);
        for (class_2520 boxNBT : boxesNBT) {
            this.addDeliveryBox(ModUtils.Conversions.nbtToGlobalPos(boxNBT));
        }
    }

    @Override
    public class_1308 self() {
        return this;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController main = new AnimationController((GeoAnimatable)this, "main", 1, state -> {
            RawAnimation builder = RawAnimation.begin();
            if (this.isGliding()) {
                return state.setAndContinue(GLIDE);
            }
            if (this.isTransforming()) {
                return state.setAndContinue(TRANSFORM);
            }
            if (this.isHeadpatted()) {
                return state.setAndContinue(HEADPATTED);
            }
            if (this.isEating()) {
                return state.setAndContinue(EAT);
            }
            if (this.method_6113()) {
                return state.setAndContinue(SLEEP);
            }
            if (this.isHarvesting()) {
                return state.setAndContinue(HARVEST);
            }
            if (this.isPlanting()) {
                return state.setAndContinue(PLANT);
            }
            if (this.isHealing()) {
                return state.setAndContinue(HEAL);
            }
            if (this.isDelivering()) {
                return state.setAndContinue(ANIMATION_DELIVER);
            }
            if (!this.getAttackType().equals((Object)MaidAttackType.NO_ATTACKING)) {
                switch (this.getAttackType()) {
                    case SWING_SWORD_DOWNWARD_RIGHT: {
                        return state.setAndContinue(SWING_SWORD_DOWNWARD_RIGHT);
                    }
                    case SWING_SWORD_DOWNWARD_LEFT: {
                        return state.setAndContinue(SWING_SWORD_DOWNWARD_LEFT);
                    }
                    case SPEAR: {
                        return state.setAndContinue(SPEAR_RIGHT);
                    }
                    case HEADBUTT: {
                        return state.setAndContinue(HEADBUTT);
                    }
                }
            } else if (this.method_6014() > 0) {
                switch (this.method_6030().method_7976()) {
                    case field_8953: {
                        MaidItemAnimationSetter.BOW.setItemAnimation(this, builder);
                        break;
                    }
                    case field_8951: {
                        MaidItemAnimationSetter.SPEAR.setItemAnimation(this, builder);
                    }
                }
            } else if (this.isSitting()) {
                builder.thenLoop("sit");
            } else if (state.isMoving()) {
                if (this.method_5968() != null && this.getJob().equals(MaidJobs.FENCER)) {
                    return state.setAndContinue(CHASE_SWORD);
                }
                builder.thenLoop("walk");
            } else {
                builder.thenLoop("idle");
            }
            state.setAndContinue(builder);
            return PlayState.CONTINUE;
        }).setParticleKeyframeHandler(event -> {
            switch (event.getKeyframeData().getEffect()) {
                case "kirakira": {
                    this.generateKirakiraEffect(event.getAnimationTick());
                    break;
                }
                case "shock": {
                    this.generateShockEffect();
                    break;
                }
                case "zzz": {
                    this.generateZZZEffect();
                }
            }
        });
        AnimationController sub = new AnimationController((GeoAnimatable)this, "sub", 1, state -> {
            if (this.isGliding()) {
                return state.setAndContinue(GLIDE_ROOT);
            }
            return PlayState.STOP;
        });
        controllers.add(new AnimationController[]{main, sub});
    }

    private void generateKirakiraEffect(double animationTick) {
        double rotate = Math.toRadians((double)this.method_36454() + (animationTick - 1.0) * 360.0 / 10.0);
        class_243 left = new class_243(0.0, 0.0, -0.5).method_1024((float)rotate).method_1031(this.method_23317(), this.method_23318() + 0.7, this.method_23321());
        class_243 right = new class_243(0.0, 0.0, 0.5).method_1024((float)rotate).method_1031(this.method_23317(), this.method_23318() + 0.7, this.method_23321());
        this.method_37908().method_8406((class_2394)ModParticles.TWINKLE, left.method_10216(), left.method_10214(), left.method_10215(), 0.0, 0.0, 0.0);
        this.method_37908().method_8406((class_2394)ModParticles.TWINKLE, right.method_10216(), right.method_10214(), right.method_10215(), 0.0, 0.0, 0.0);
    }

    private void generateShockEffect() {
        class_243 pos = new class_243(0.0, 0.0, 1.6).method_1024((float)Math.toRadians(-this.method_36454())).method_1019(this.method_19538()).method_1031(0.0, 1.25, 0.0);
        this.method_37908().method_8406((class_2394)ModParticles.SHOCK, pos.method_10216(), pos.method_10214(), pos.method_10215(), 0.0, 0.0, 0.0);
        this.method_37908().method_8406((class_2394)ModParticles.SHOCKWAVE, pos.method_10216(), pos.method_10214(), pos.method_10215(), 0.0, 0.0, 0.0);
    }

    private void generateZZZEffect() {
        double rotateX = Math.toRadians(this.field_5974.method_43059() * 5.0);
        double rotateY = Math.toRadians((double)Objects.requireNonNull(this.method_18401()).method_10144() + this.field_5974.method_43059() * 5.0);
        double rotateZ = Math.toRadians(this.field_5974.method_43059() * 5.0);
        class_243 vel = new class_243(0.34, 0.78, 0.34).method_1037((float)rotateX).method_1024((float)rotateY).method_31033((float)rotateZ).method_1029().method_1021(0.2);
        class_243 pos = vel.method_1029().method_1021(0.8).method_1019(this.method_19538());
        this.method_37908().method_8406((class_2394)new ZZZParticle.Mediator(0), pos.method_10216(), pos.method_10214(), pos.method_10215(), vel.method_10216(), vel.method_10214(), vel.method_10215());
        this.method_37908().method_8406((class_2394)new ZZZParticle.Mediator(1), pos.method_10216(), pos.method_10214(), pos.method_10215(), vel.method_10216(), vel.method_10214(), vel.method_10215());
        this.method_37908().method_8406((class_2394)new ZZZParticle.Mediator(2), pos.method_10216(), pos.method_10214(), pos.method_10215(), vel.method_10216(), vel.method_10214(), vel.method_10215());
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animationFactory;
    }

    static {
        DIMENSIONS_SLEEPING = class_4048.method_18385((float)0.2f, (float)0.2f);
        DIMENSIONS_CRAWLING = class_4048.method_18384((float)0.6f, (float)0.6f);
        ATTRIBUTE_ID_CRACKER_SLOW = UUID.fromString("7ED8E765-F4D0-4428-BCBE-654FFF51BAF0");
        ATTRIBUTE_ID_CRACKER_DAMAGE = UUID.fromString("56A32427-E09D-BA9C-EC1C-A1C7BAD8E88A");
        MEMORY_MODULES = ImmutableSet.of((Object)class_4140.field_18445, (Object)class_4140.field_18449, (Object)class_4140.field_26389, (Object)class_4140.field_19293, (Object)class_4140.field_18446, (Object)class_4140.field_18441, (Object[])new class_4140[]{class_4140.field_18442, class_4140.field_18451, class_4140.field_18452, class_4140.field_39408, ModMemories.IS_SITTING, ModMemories.SHOULD_EAT, ModMemories.SHOULD_SLEEP, class_4140.field_19007, class_4140.field_18438, class_4140.field_20616, class_4140.field_19385, class_4140.field_30243, class_4140.field_22355, class_4140.field_22475, ModMemories.HAS_ARROWS, ModMemories.ATTRACTABLE_LIVINGS, ModMemories.GUARDABLE_LIVING, ModMemories.GUARD_AGAINST, ModMemories.SHOULD_HEAL, ModMemories.FARMABLE_POSES, ModMemories.FARM_POS, ModMemories.THROWN_TRIDENT, ModMemories.THROWN_TRIDENT_COOLDOWN, ModMemories.SHOULD_BREATH, ModMemories.IS_HUNTING, ModMemories.ANCHOR, ModMemories.DELIVERY_BOX, ModMemories.UNDELIVERABLE_BOXES, ModMemories.CANT_REACH_HOME, ModMemories.AVAILABLE_BED, ModMemories.SLEEP_POS});
        SENSORS = ImmutableSet.of((Object)class_4149.field_18466, (Object)class_4149.field_18469, ModSensors.SENSOR_HOME_CANDIDATE, ModSensors.AVAILABLE_BED, ModSensors.SENSOR_MAID_ATTACKABLE, ModSensors.SENSOR_MAID_ATTRACTABLE_LIVINGS, (Object[])new class_4149[]{ModSensors.SENSOR_MAID_GUARDABLE_LIVING, ModSensors.SENSOR_MAID_FARMABLE_POSES});
        MASTER = class_2945.method_12791(LittleMaidEntity.class, (class_2941)class_2943.field_13313);
        MODE = class_2945.method_12791(LittleMaidEntity.class, ModEntities.MODE_HANDLER);
        JOB = class_2945.method_12791(LittleMaidEntity.class, ModDataHandlers.MAID_JOB);
        PERSONALITY = class_2945.method_12791(LittleMaidEntity.class, ModEntities.PERSONALITY_HANDLER);
        ACTION = class_2945.method_12791(LittleMaidEntity.class, ModDataHandlers.OPTIONAL_MAID_ACTION);
        FEELING = class_2945.method_12791(LittleMaidEntity.class, ModDataHandlers.MAID_FEELING);
        IS_VARIABLE_COSTUME = class_2945.method_12791(LittleMaidEntity.class, (class_2941)class_2943.field_13323);
        COMMITMENT = class_2945.method_12791(LittleMaidEntity.class, (class_2941)class_2943.field_13327);
        HOME = class_2945.method_12791(LittleMaidEntity.class, (class_2941)class_2943.field_38825);
        ANCHOR = class_2945.method_12791(LittleMaidEntity.class, (class_2941)class_2943.field_38825);
        DELIVERY_BOXES = class_2945.method_12791(LittleMaidEntity.class, ModDataHandlers.COLLECTION_GLOBAL_POS);
        ATTACK_TARGET = class_2945.method_12791(LittleMaidEntity.class, ModDataHandlers.OPTIONAL_INT);
        ATTACK_TYPE = class_2945.method_12791(LittleMaidEntity.class, ModDataHandlers.MAID_ATTACK_TYPE);
    }
}

