/*
 * Decompiled with CFR 0.152.
 */
package io.github.zemelua.umu_little_maid.entity.brain.task.tameable;

import com.google.common.collect.ImmutableMap;
import io.github.zemelua.umu_little_maid.util.IHasMaster;
import io.github.zemelua.umu_little_maid.util.ITameable;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1314;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_5712;

public class TeleportToMasterTask<E extends class_1314>
extends class_4097<E> {
    private static final Map<class_4140<?>, class_4141> REQUIRED_MEMORIES = ImmutableMap.of();
    private final float startDistance;

    public TeleportToMasterTask(float startDistance) {
        super(REQUIRED_MEMORIES, 60);
        this.startDistance = startDistance;
    }

    protected boolean shouldRun(class_3218 world, E pet) {
        Optional<class_1657> master = ((IHasMaster)pet).getMaster();
        return master.filter(masterValue -> this.shouldTeleport(pet, (class_1657)masterValue)).isPresent();
    }

    protected boolean shouldKeepRunning(class_3218 world, E pet, long time) {
        Optional<class_1657> master = ((IHasMaster)pet).getMaster();
        return master.filter(masterValue -> this.shouldTeleport(pet, (class_1657)masterValue)).isPresent();
    }

    protected void finishRunning(class_3218 world, E pet, long time) {
        Optional<class_1657> master = ((IHasMaster)pet).getMaster();
        if (this.method_18915(time)) {
            master.ifPresent(masterValue -> {
                for (int i = 0; i < 16; ++i) {
                    int xOffset = pet.method_6051().method_43048(7) - 3;
                    int yOffset = pet.method_6051().method_43048(3) - 1;
                    int zOffset = pet.method_6051().method_43048(7) - 3;
                    class_2338 oldPos = new class_2338((class_2382)pet.method_24515());
                    class_2338 newPos = masterValue.method_24515().method_10069(xOffset, yOffset, zOffset);
                    boolean teleported = pet.method_6082((double)newPos.method_10263(), (double)newPos.method_10264(), (double)newPos.method_10260(), true);
                    if (!teleported) continue;
                    world.method_43276(class_5712.field_39446, oldPos, class_5712.class_7397.method_43285((class_1297)pet));
                    world.method_8396(null, new class_2338((class_2382)oldPos), class_3417.field_14890, class_3419.field_15254, 1.0f, 1.0f);
                    world.method_8396(null, pet.method_24515(), class_3417.field_14890, class_3419.field_15254, 1.0f, 1.0f);
                    return;
                }
            });
        }
    }

    private boolean shouldTeleport(E pet, class_1657 master) {
        if (pet.method_5934()) {
            return false;
        }
        if (pet.method_5765()) {
            return false;
        }
        return !master.method_7325() && pet.method_5739((class_1297)master) >= this.startDistance && ((ITameable)pet).isFollowingMaster();
    }
}

