/*
 * Decompiled with CFR 0.152.
 */
package io.github.zemelua.umu_little_maid.entity.brain.task.tameable;

import com.google.common.collect.ImmutableMap;
import io.github.zemelua.umu_little_maid.entity.maid.LittleMaidEntity;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_14;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4142;
import net.minecraft.class_7;

public class FollowOwnerTask
extends class_4097<LittleMaidEntity> {
    private static final Map<class_4140<?>, class_4141> REQUIRED_MEMORIES = ImmutableMap.of();
    private final float minDistance;
    private final float maxDistance;

    public FollowOwnerTask(float minDistance, float maxDistance) {
        super(REQUIRED_MEMORIES);
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
    }

    protected boolean shouldRun(class_3218 world, LittleMaidEntity maid) {
        class_1297 owner = maid.getOwner();
        if (owner != null) {
            return !owner.method_7325() && maid.method_5739(owner) > this.minDistance;
        }
        return false;
    }

    protected boolean shouldKeepRunning(class_3218 world, LittleMaidEntity maid, long time) {
        class_1297 owner = maid.getOwner();
        if (owner != null) {
            return !owner.method_7325() && maid.method_5739(owner) > this.maxDistance;
        }
        return false;
    }

    protected void keepRunning(class_3218 world, LittleMaidEntity maid, long time) {
        class_1297 owner = maid.getOwner();
        if (owner != null) {
            maid.method_5988().method_6226(owner, 10.0f, (float)maid.method_5978());
            if (maid.method_5934()) {
                return;
            }
            if (maid.method_5765()) {
                return;
            }
            if (maid.method_5739(owner) >= 12.0f) {
                this.tryTeleport(maid, owner);
            } else {
                maid.method_18868().method_18878(class_4140.field_18445, (Object)new class_4142(owner, 0.9f, 0));
            }
        }
    }

    protected void finishRunning(class_3218 world, LittleMaidEntity entity, long time) {
        entity.method_18868().method_18875(class_4140.field_18445);
    }

    private void tryTeleport(LittleMaidEntity maid, class_1297 owner) {
        class_2338 blockPos = owner.method_24515();
        for (int i = 0; i < 10; ++i) {
            int xOffset = maid.method_6051().method_43048(7) - 3;
            int yOffset = maid.method_6051().method_43048(3) - 1;
            int zOffset = maid.method_6051().method_43048(7) - 3;
            boolean teleported = this.tryTeleportTo(maid, owner, blockPos.method_10263() + xOffset, blockPos.method_10264() + yOffset, blockPos.method_10260() + zOffset);
            if (!teleported) continue;
            return;
        }
    }

    private boolean tryTeleportTo(LittleMaidEntity maid, class_1297 owner, int x, int y, int z) {
        if (Math.abs((double)x - owner.method_23317()) < 2.0 && Math.abs((double)z - owner.method_23321()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(maid, new class_2338(x, y, z))) {
            return false;
        }
        maid.method_5808((double)x + 0.5, y, (double)z + 0.5, maid.method_36454(), maid.method_36455());
        maid.method_5942().method_6340();
        return true;
    }

    protected boolean canTeleportTo(LittleMaidEntity maid, class_2338 pos) {
        class_7 pathType = class_14.method_23476((class_1922)maid.method_37908(), (class_2338.class_2339)pos.method_25503());
        if (pathType != class_7.field_12) {
            return false;
        }
        if (maid.method_37908().method_8320(pos.method_10074()).method_26204() instanceof class_2397) {
            return false;
        }
        return maid.method_37908().method_8587((class_1297)maid, maid.method_5829().method_996(pos.method_10059((class_2382)maid.method_24515())));
    }
}

