/*
 * Decompiled with CFR 0.152.
 */
package io.github.zemelua.umu_little_maid.entity.brain.task.heal;

import com.google.common.collect.ImmutableMap;
import io.github.zemelua.umu_little_maid.util.IHasMaster;
import io.github.zemelua.umu_little_maid.util.ModUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_4081;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4102;
import net.minecraft.class_4140;
import net.minecraft.class_4141;

public class HealOwnerTask<E extends class_1309>
extends class_4097<E> {
    private static final Map<class_4140<?>, class_4141> REQUIRED_MEMORIES = ImmutableMap.of();
    protected int cooldown = 0;

    public HealOwnerTask() {
        super(REQUIRED_MEMORIES);
    }

    protected boolean method_18919(class_3218 world, E living) {
        Optional<class_1657> master = ((IHasMaster)living).getMaster();
        if (master.isEmpty()) {
            return false;
        }
        if ((double)living.method_5739((class_1297)master.get()) > 4.0) {
            return false;
        }
        return HealOwnerTask.shouldRecover(living, (class_1309)master.get()) || HealOwnerTask.shouldCure(living, (class_1309)master.get());
    }

    protected boolean method_18927(class_3218 world, E entity, long time) {
        return this.method_18919(world, entity);
    }

    protected void method_18920(class_3218 world, E living, long time) {
        class_4095 brain = living.method_18868();
        Optional<class_1657> master = ((IHasMaster)living).getMaster();
        brain.method_18875(class_4140.field_18445);
        master.ifPresent(player -> brain.method_18878(class_4140.field_18446, (Object)new class_4102((class_1297)player, true)));
    }

    protected void method_18924(class_3218 world, E living, long time) {
        Optional<class_1657> master = ((IHasMaster)living).getMaster();
        if (master.isEmpty()) {
            return;
        }
        if (ModUtils.hasHarmfulEffect((class_1309)master.get())) {
            List<class_1293> effects = master.get().method_6026().stream().filter(effect -> effect.method_5579().method_18792() == class_4081.field_18272).toList();
            for (class_1293 effect2 : effects) {
                master.get().method_6016(effect2.method_5579());
                living.method_6092(effect2);
            }
        }
        if (this.cooldown >= 30) {
            master.get().method_6025(5.0f);
            living.method_5643(living.method_48923().method_48831(), 3.0f);
            for (int i = 0; i < 5; ++i) {
                double posX = living.method_23322(1.0);
                double posY = living.method_23319() + 1.0;
                double posZ = living.method_23325(1.0);
                double deltaX = living.method_6051().method_43059() * 0.02;
                double deltaY = living.method_6051().method_43059() * 0.02;
                double deltaZ = living.method_6051().method_43059() * 0.02;
                ((class_3218)living.method_37908()).method_14199((class_2394)class_2398.field_11211, posX, posY, posZ, 0, deltaX, deltaY, deltaZ, 1.0);
            }
            this.cooldown = 0;
        }
        living.method_5636(living.method_5791());
        ++this.cooldown;
        class_4095 brain = living.method_18868();
        if (!brain.method_18896(class_4140.field_18446)) {
            brain.method_18878(class_4140.field_18446, (Object)new class_4102((class_1297)master.get(), true));
        }
    }

    protected void method_18926(class_3218 world, E tameable, long time) {
        class_4095 brain = tameable.method_18868();
        brain.method_18875(class_4140.field_18446);
    }

    protected boolean method_18915(long time) {
        return false;
    }

    public static <E extends class_1309> boolean shouldHeal(E living) {
        Optional<class_1657> master = ((IHasMaster)living).getMaster();
        if (master.isEmpty()) {
            return false;
        }
        if (master.get().method_29504() || master.get().method_31481()) {
            return false;
        }
        if (master.get().method_7325()) {
            return false;
        }
        return HealOwnerTask.shouldRecover(living, (class_1309)master.get()) || HealOwnerTask.shouldCure(living, (class_1309)master.get());
    }

    public static boolean shouldRecover(class_1309 entity, class_1309 owner) {
        return (double)entity.method_6032() > 3.0 && owner.method_6032() < owner.method_6063();
    }

    public static boolean shouldCure(class_1309 entity, class_1309 owner) {
        return (double)entity.method_6032() > 3.0 && ModUtils.hasHarmfulEffect(owner);
    }
}

