/*
 * Decompiled with CFR 0.152.
 */
package io.github.zemelua.umu_little_maid.entity.brain.task.guard;

import com.google.common.collect.ImmutableMap;
import io.github.zemelua.umu_little_maid.entity.brain.ModMemories;
import io.github.zemelua.umu_little_maid.util.IHasMaster;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4102;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_7833;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class MaidGuardTask<E extends class_1308>
extends class_4097<E> {
    private static final ImmutableMap<class_4140<?>, class_4141> REQUIRED_MEMORIES = ImmutableMap.of(ModMemories.GUARD_AGAINST, (Object)class_4141.field_18456);
    private final double moveStartDistance;
    private final double guardStartDistance;
    private final float normalSpeed;
    private final float guardSpeed;

    public MaidGuardTask(double moveStartDistance, double guardStartDistance, float speed) {
        super(REQUIRED_MEMORIES);
        this.moveStartDistance = moveStartDistance;
        this.guardStartDistance = guardStartDistance;
        this.normalSpeed = speed;
        this.guardSpeed = speed * 0.46666667f;
    }

    protected boolean shouldRun(class_3218 world, E mob) {
        Optional<class_1657> master = ((IHasMaster)mob).getMaster();
        return master.filter(player -> !player.method_7325() && (double)mob.method_5739((class_1297)player) <= this.moveStartDistance).isPresent();
    }

    protected boolean shouldKeepRunning(class_3218 world, E mob, long time) {
        return this.shouldRun(world, mob) && this.method_19546((class_1309)mob);
    }

    protected boolean method_18915(long time) {
        return false;
    }

    protected void run(class_3218 world, E tameable, long time) {
        class_4095 brain = tameable.method_18868();
        brain.method_18875(class_4140.field_18445);
        brain.method_18875(class_4140.field_18446);
    }

    protected void keepRunning(class_3218 world, E mob, long time) {
        class_4095 brain = mob.method_18868();
        Optional<class_1657> master = ((IHasMaster)mob).getMaster();
        if (master.isEmpty()) {
            return;
        }
        brain.method_46873(ModMemories.ATTRACTABLE_LIVINGS).ifPresent(list -> list.stream().filter(living -> living instanceof class_1308).map(living -> (class_1308)living).forEach(target -> target.method_5980((class_1309)mob)));
        Optional guardTarget = brain.method_46873(ModMemories.GUARD_AGAINST);
        if (guardTarget.isPresent()) {
            boolean shouldGuard = (double)mob.method_5739((class_1297)master.get()) <= this.guardStartDistance;
            brain.method_18878(class_4140.field_18446, (Object)new class_4102((class_1297)guardTarget.get(), true));
            if (shouldGuard) {
                if (!mob.method_6039()) {
                    mob.method_6019(class_1268.field_5808);
                }
            } else if (mob.method_6039()) {
                mob.method_6021();
            }
            class_243 ownerPos = master.get().method_19538();
            class_243 guardTargetPos = ((class_1309)guardTarget.get()).method_19538();
            class_243 guardPos = ownerPos.method_1019(guardTargetPos.method_1020(ownerPos).method_1029());
            class_243 maidPos = mob.method_19538();
            Vector3f moveVec = maidPos.method_1020(guardPos).method_46409();
            Vector3f lookVec = mob.method_5720().method_18805(1.0, 0.0, 1.0).method_46409();
            Vector3f forwardVec = new Vector3f((Vector3fc)lookVec);
            Quaternionf quaternion = class_7833.field_40716.rotationDegrees(-90.0f);
            quaternion.transform(lookVec);
            Vector3f sidewaysVec = new Vector3f((Vector3fc)lookVec);
            moveVec.normalize();
            float speed = mob.method_6039() ? this.guardSpeed : this.normalSpeed;
            float forwardSpeed = -moveVec.dot((Vector3fc)forwardVec) * speed;
            float sidewaysSpeed = moveVec.dot((Vector3fc)sidewaysVec) * speed;
            mob.method_5962().method_6243(forwardSpeed, sidewaysSpeed);
            mob.method_36456(class_3532.method_20306((float)mob.method_36454(), (float)mob.method_5791(), (float)0.0f));
        }
    }

    protected void finishRunning(class_3218 world, E mob, long time) {
        mob.method_6021();
    }
}

