/*
 * Decompiled with CFR 0.152.
 */
package io.github.zemelua.umu_little_maid.entity.brain.task.attack.trident;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1675;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4102;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4142;

public abstract class AbstractTridentTask<E extends class_1308>
extends class_4097<E> {
    private static final Map<class_4140<?>, class_4141> REQUIRED_MEMORIES = ImmutableMap.of((Object)class_4140.field_22355, (Object)class_4141.field_18456, (Object)class_4140.field_22475, (Object)class_4141.field_18457);
    private final double range;
    private final double speed;
    private final int interval;
    private int combatTicks;
    private boolean movingToLeft;
    private boolean backward;

    public AbstractTridentTask(double range, double speed, int interval) {
        super(REQUIRED_MEMORIES);
        this.range = range;
        this.speed = speed;
        this.interval = interval;
        this.combatTicks = -1;
        this.movingToLeft = true;
        this.backward = true;
    }

    protected boolean shouldRun(class_3218 world, E mob) {
        class_4095 brain = mob.method_18868();
        return brain.method_46873(class_4140.field_22355).filter(target -> !mob.method_42150(target)).isPresent();
    }

    protected boolean shouldKeepRunning(class_3218 world, E mob, long time) {
        class_4095 brain = mob.method_18868();
        return brain.method_46873(class_4140.field_22355).filter(target -> mob.method_5985().method_6369((class_1297)target)).isPresent() && this.method_19546((class_1309)mob);
    }

    protected boolean method_18915(long time) {
        return false;
    }

    protected void run(class_3218 world, E mob, long time) {
        class_4095 brain = mob.method_18868();
        brain.method_46873(class_4140.field_22355).ifPresent(targetObject -> {
            brain.method_18878(class_4140.field_18445, (Object)new class_4142((class_1297)targetObject, (float)this.speed, (int)this.range));
            brain.method_18878(class_4140.field_18446, (Object)new class_4102((class_1297)targetObject, true));
        });
        mob.method_19540(true);
        mob.method_6019(class_1675.method_18812(mob, (class_1792)class_1802.field_8547));
    }

    protected void keepRunning(class_3218 world, E mob, long time) {
        class_4095 brain = mob.method_18868();
        brain.method_46873(class_4140.field_22355).ifPresent(targetObject -> {
            int itemUseTime;
            double distance = mob.method_5739((class_1297)targetObject);
            this.combatTicks = distance > this.range ? -1 : ++this.combatTicks;
            if (this.combatTicks >= 20) {
                if (mob.method_6051().method_43058() < 0.3) {
                    boolean bl = this.movingToLeft = !this.movingToLeft;
                }
                if (mob.method_6051().method_43058() < 0.3) {
                    this.backward = !this.backward;
                }
                this.combatTicks = 0;
            }
            if (this.combatTicks > -1 && !mob.method_5799()) {
                if (distance > this.range * Math.sqrt(0.75)) {
                    this.backward = false;
                } else if (distance < this.range * Math.sqrt(0.25)) {
                    this.backward = true;
                }
                mob.method_5962().method_6243(this.backward ? -0.5f : 0.5f, this.movingToLeft ? 0.5f : -0.5f);
                mob.method_36456(class_3532.method_20306((float)mob.method_36454(), (float)mob.method_5791(), (float)0.0f));
            }
            brain.method_18878(class_4140.field_18446, (Object)new class_4102((class_1297)targetObject, true));
            if (mob.method_6115() && (itemUseTime = mob.method_6048()) >= 20) {
                this.attack(world, mob, itemUseTime, (class_1309)targetObject);
                brain.method_24525(class_4140.field_22475, (Object)true, (long)this.interval);
            }
        });
    }

    protected void finishRunning(class_3218 world, E mob, long time) {
        mob.method_19540(false);
        mob.method_6021();
    }

    protected abstract void attack(class_3218 var1, E var2, int var3, class_1309 var4);
}

