/*
 * Decompiled with CFR 0.152.
 */
package io.github.zemelua.umu_little_maid.entity.brain.task.attack.bow;

import com.google.common.collect.ImmutableMap;
import io.github.zemelua.umu_little_maid.data.tag.ModTags;
import io.github.zemelua.umu_little_maid.entity.maid.LittleMaidEntity;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1675;
import net.minecraft.class_1753;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4097;
import net.minecraft.class_4102;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4142;

public class MaidBowAttackTask
extends class_4097<LittleMaidEntity> {
    private static final Map<class_4140<?>, class_4141> REQUIRED_MEMORIES = ImmutableMap.of((Object)class_4140.field_22355, (Object)class_4141.field_18456);
    private final double range;
    private final float speed;
    private final int interval;
    private int targetSeeingTicker;
    private int combatTicks = -1;
    private boolean movingToLeft;
    private boolean backward;

    public MaidBowAttackTask(double range, float speed, int interval) {
        super(REQUIRED_MEMORIES);
        this.range = range;
        this.speed = speed;
        this.interval = interval;
    }

    protected boolean shouldRun(class_3218 world, LittleMaidEntity maid) {
        return MaidBowAttackTask.hasTarget(maid) && MaidBowAttackTask.hasArrows(maid);
    }

    protected boolean shouldKeepRunning(class_3218 world, LittleMaidEntity maid, long time) {
        return MaidBowAttackTask.hasTarget(maid) && MaidBowAttackTask.hasArrows(maid);
    }

    protected boolean method_18915(long time) {
        return false;
    }

    protected void run(class_3218 world, LittleMaidEntity maid, long time) {
        maid.method_19540(true);
        this.targetSeeingTicker = 0;
    }

    protected void keepRunning(class_3218 world, LittleMaidEntity maid, long time) {
        boolean isSeeingTarget;
        Optional target = maid.method_18868().method_18904(class_4140.field_22355);
        if (target.isEmpty()) {
            return;
        }
        double distance = maid.method_5739((class_1297)target.get());
        boolean canSeeTarget = maid.method_5985().method_6369((class_1297)target.get());
        boolean bl = isSeeingTarget = this.targetSeeingTicker > 0;
        if (canSeeTarget != isSeeingTarget) {
            this.targetSeeingTicker = 0;
        }
        this.targetSeeingTicker = canSeeTarget ? ++this.targetSeeingTicker : --this.targetSeeingTicker;
        if (distance > this.range || this.targetSeeingTicker < 20) {
            maid.method_18868().method_18878(class_4140.field_18445, (Object)new class_4142((class_1297)target.get(), this.speed, 0));
            this.combatTicks = -1;
        } else {
            maid.method_5942().method_6340();
            ++this.combatTicks;
        }
        if (this.combatTicks >= 20) {
            if (maid.method_6051().method_43058() < 0.3) {
                boolean bl2 = this.movingToLeft = !this.movingToLeft;
            }
            if (maid.method_6051().method_43058() < 0.3) {
                this.backward = !this.backward;
            }
            this.combatTicks = 0;
        }
        if (this.combatTicks > -1) {
            if (distance > this.range * Math.sqrt(0.75)) {
                this.backward = false;
            } else if (distance < this.range * Math.sqrt(0.25)) {
                this.backward = true;
            }
            maid.method_5962().method_6243(this.backward ? -0.5f : 0.5f, this.movingToLeft ? 0.5f : -0.5f);
            maid.method_36456(class_3532.method_20306((float)maid.method_36454(), (float)maid.method_5791(), (float)0.0f));
        }
        maid.method_18868().method_18878(class_4140.field_18446, (Object)new class_4102((class_1297)target.get(), true));
        if (maid.method_6115()) {
            int itemUseTime = maid.method_6048();
            if (!canSeeTarget && this.targetSeeingTicker < -60) {
                maid.method_6021();
            } else if (canSeeTarget && itemUseTime >= 20) {
                maid.method_6021();
                maid.method_7105((class_1309)target.get(), class_1753.method_7722((int)itemUseTime));
                int interval = maid.getPersonality().isIn(ModTags.PERSONALITY_DEVOTE_WHEN_BOW_ATTACKS) ? (int)Math.ceil((double)this.interval - (double)maid.getCommitment() * 0.03) : this.interval;
                maid.method_18868().method_24525(class_4140.field_22475, (Object)true, (long)interval);
            }
        } else if (!maid.method_18868().method_18896(class_4140.field_22475) && this.targetSeeingTicker >= -60) {
            maid.method_6019(class_1675.method_18812((class_1309)maid, (class_1792)class_1802.field_8102));
        }
    }

    protected void finishRunning(class_3218 world, LittleMaidEntity maid, long time) {
        maid.method_19540(false);
        this.targetSeeingTicker = 0;
        maid.method_6021();
    }

    private static boolean hasTarget(LittleMaidEntity maid) {
        return maid.method_18868().method_18904(class_4140.field_22355).isPresent();
    }

    private static boolean hasArrows(LittleMaidEntity maid) {
        return !maid.method_18808(maid.method_6047()).method_7960();
    }
}

