/*
 * Decompiled with CFR 0.152.
 */
package io.github.zemelua.umu_little_maid.entity.brain;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import io.github.zemelua.umu_little_maid.UMULittleMaid;
import io.github.zemelua.umu_little_maid.data.tag.ModTags;
import io.github.zemelua.umu_little_maid.entity.ModEntities;
import io.github.zemelua.umu_little_maid.entity.brain.ModActivities;
import io.github.zemelua.umu_little_maid.entity.brain.ModMemories;
import io.github.zemelua.umu_little_maid.entity.brain.task.KeepAroundHomeOrAnchorTask;
import io.github.zemelua.umu_little_maid.entity.brain.task.ShelterFromRainTask;
import io.github.zemelua.umu_little_maid.entity.brain.task.eat.MaidEatTask;
import io.github.zemelua.umu_little_maid.entity.brain.task.eat.UpdateShouldEatTask;
import io.github.zemelua.umu_little_maid.entity.brain.task.farm.MaidHarvestTask;
import io.github.zemelua.umu_little_maid.entity.brain.task.farm.MaidPlantTask;
import io.github.zemelua.umu_little_maid.entity.brain.task.farm.UpdateFarmPosTask;
import io.github.zemelua.umu_little_maid.entity.brain.task.farm.WalkToFarmPosTask;
import io.github.zemelua.umu_little_maid.entity.brain.task.farm.deliver.MaidDeliverTask;
import io.github.zemelua.umu_little_maid.entity.brain.task.farm.deliver.MaidWalkToBoxTask;
import io.github.zemelua.umu_little_maid.entity.brain.task.farm.deliver.UpdateDeliveryBoxTask;
import io.github.zemelua.umu_little_maid.entity.brain.task.look.LookAtEntityTask;
import io.github.zemelua.umu_little_maid.entity.brain.task.sleep.MaidSleepTask;
import io.github.zemelua.umu_little_maid.entity.brain.task.sleep.UpdateShouldSleepTask;
import io.github.zemelua.umu_little_maid.entity.brain.task.sleep.UpdateSleepPosTask;
import io.github.zemelua.umu_little_maid.entity.brain.task.sleep.WalkToSleepPosTask;
import io.github.zemelua.umu_little_maid.entity.brain.task.tameable.FollowMasterTask;
import io.github.zemelua.umu_little_maid.entity.brain.task.tameable.SitTask;
import io.github.zemelua.umu_little_maid.entity.brain.task.tameable.TeleportToMasterTask;
import io.github.zemelua.umu_little_maid.entity.maid.LittleMaidEntity;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1299;
import net.minecraft.class_2195;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_2350;
import net.minecraft.class_2511;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_4095;
import net.minecraft.class_4101;
import net.minecraft.class_4107;
import net.minecraft.class_4110;
import net.minecraft.class_4112;
import net.minecraft.class_4118;
import net.minecraft.class_4120;
import net.minecraft.class_4125;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4168;
import net.minecraft.class_4214;
import net.minecraft.class_4818;
import net.minecraft.class_6019;
import net.minecraft.class_7895;

public final class MaidFarmerBrainManager {
    public static void initBrain(class_4095<LittleMaidEntity> brain, LittleMaidEntity maid) {
        MaidFarmerBrainManager.addCoreTasks(brain);
        MaidFarmerBrainManager.addIdleTasks(brain);
        MaidFarmerBrainManager.addSitTasks(brain);
        MaidFarmerBrainManager.addEatTasks(brain);
        MaidFarmerBrainManager.addFarmTasks(brain);
        MaidFarmerBrainManager.addDeliverTasks(brain);
        MaidFarmerBrainManager.addSleepTasks(brain);
        brain.method_18890((Set)ImmutableSet.of((Object)class_4168.field_18594));
        brain.method_18897(class_4168.field_18595);
        brain.method_24536();
    }

    public static void tickBrain(class_4095<LittleMaidEntity> brain, LittleMaidEntity maid) {
        ImmutableList.Builder activities = ImmutableList.builder();
        activities.add((Object)ModActivities.SIT);
        activities.add((Object)ModActivities.EAT);
        activities.add((Object)class_4168.field_18597);
        activities.add((Object)ModActivities.FARM);
        if (maid.hasHarvests()) {
            activities.add((Object)ModActivities.DELIVER);
        }
        activities.add((Object)class_4168.field_18595);
        brain.method_24531((List)activities.build());
    }

    private static void addCoreTasks(class_4095<LittleMaidEntity> brain) {
        brain.method_18881(class_4168.field_18594, ImmutableList.of((Object)Pair.of((Object)0, (Object)new class_4125(0.8f)), (Object)Pair.of((Object)0, (Object)class_4107.method_46964()), (Object)Pair.of((Object)0, (Object)class_4214.method_47204()), (Object)Pair.of((Object)0, (Object)((Object)new KeepAroundHomeOrAnchorTask())), (Object)Pair.of((Object)1, (Object)new class_4110(45, 90)), (Object)Pair.of((Object)2, (Object)new class_4112()), (Object)Pair.of((Object)99, new UpdateShouldEatTask()), (Object)Pair.of((Object)99, new UpdateShouldSleepTask()), (Object)Pair.of((Object)99, (Object)new UpdateSleepPosTask()), (Object)Pair.of((Object)99, new UpdateFarmPosTask()), (Object)Pair.of((Object)99, new UpdateDeliveryBoxTask())));
    }

    private static void addIdleTasks(class_4095<LittleMaidEntity> brain) {
        brain.method_18881(class_4168.field_18595, ImmutableList.of((Object)Pair.of((Object)0, new FollowMasterTask(10.0f)), (Object)Pair.of((Object)0, new TeleportToMasterTask(15.0f)), (Object)Pair.of((Object)1, new ShelterFromRainTask()), (Object)Pair.of((Object)2, (Object)class_7895.method_47069((class_1299)class_1299.field_6097, (float)6.0f, (class_6019)class_6019.method_35017((int)30, (int)60))), (Object)Pair.of((Object)3, (Object)new class_4118((List)ImmutableList.of((Object)Pair.of((Object)class_4818.method_47014((float)0.8f), (Object)2), (Object)Pair.of((Object)class_4120.method_47104((float)0.8f, (int)3), (Object)2), (Object)Pair.of((Object)new class_4101(30, 60), (Object)1)))), (Object)Pair.of((Object)3, (Object)new class_4118((List)ImmutableList.of((Object)Pair.of(new LookAtEntityTask<LittleMaidEntity>((self, target) -> target.equals(self.getMaster().orElse(null))), (Object)1), (Object)Pair.of((Object)new class_4101(30, 60), (Object)4))))));
    }

    private static void addSitTasks(class_4095<LittleMaidEntity> brain) {
        brain.method_24529(ModActivities.SIT, ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new SitTask()))), (Set)ImmutableSet.of((Object)Pair.of(ModMemories.IS_SITTING, (Object)class_4141.field_18456)));
    }

    private static void addEatTasks(class_4095<LittleMaidEntity> brain) {
        brain.method_24530(ModActivities.EAT, ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new MaidEatTask()))), (Set)ImmutableSet.of((Object)Pair.of(ModMemories.SHOULD_EAT, (Object)class_4141.field_18456), (Object)Pair.of((Object)class_4140.field_39408, (Object)class_4141.field_18457)), (Set)ImmutableSet.of(ModMemories.SHOULD_EAT));
    }

    private static void addFarmTasks(class_4095<LittleMaidEntity> brain) {
        brain.method_24529(ModActivities.FARM, ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new MaidHarvestTask())), (Object)Pair.of((Object)0, (Object)((Object)new MaidPlantTask())), (Object)Pair.of((Object)1, new WalkToFarmPosTask(1.0f))), (Set)ImmutableSet.of((Object)Pair.of(ModMemories.FARM_POS, (Object)class_4141.field_18456), (Object)Pair.of((Object)class_4140.field_39408, (Object)class_4141.field_18457)));
    }

    private static void addDeliverTasks(class_4095<LittleMaidEntity> brain) {
        brain.method_24529(ModActivities.DELIVER, ImmutableList.of((Object)Pair.of((Object)0, new MaidDeliverTask()), (Object)Pair.of((Object)1, new MaidWalkToBoxTask())), (Set)ImmutableSet.of((Object)Pair.of(ModMemories.FARM_POS, (Object)class_4141.field_18457), (Object)Pair.of(ModMemories.DELIVERY_BOX, (Object)class_4141.field_18456), (Object)Pair.of((Object)class_4140.field_39408, (Object)class_4141.field_18457)));
    }

    public static void addSleepTasks(class_4095<LittleMaidEntity> brain) {
        brain.method_24529(class_4168.field_18597, ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new MaidSleepTask())), (Object)Pair.of((Object)1, new WalkToSleepPosTask())), (Set)ImmutableSet.of((Object)Pair.of(ModMemories.SHOULD_SLEEP, (Object)class_4141.field_18456), (Object)Pair.of(ModMemories.SLEEP_POS, (Object)class_4141.field_18456)));
    }

    private MaidFarmerBrainManager() {
    }

    public static boolean isPlantable(class_2338 pos, class_3218 world) {
        class_2680 blockState = world.method_8320(pos);
        class_2680 downState = world.method_8320(pos.method_10074());
        return downState.method_26204() instanceof class_2344 && blockState.method_26215();
    }

    public static boolean isHarvestable(class_2338 pos, class_3218 world) {
        class_2680 blockState = world.method_8320(pos);
        class_2248 block = blockState.method_26204();
        if (blockState.method_26164(ModTags.BLOCK_MAID_HARVESTS)) {
            if (block instanceof class_2302) {
                class_2302 crop = (class_2302)block;
                return crop.method_9825(blockState);
            }
            return true;
        }
        return false;
    }

    public static boolean isGourd(class_2338 pos, class_3218 world) {
        class_2680 blockState = world.method_8320(pos);
        class_2248 block = blockState.method_26204();
        if (blockState.method_26164(ModTags.BLOCK_MAID_GOURDS)) {
            if (block instanceof class_2511) {
                class_2511 gourd = (class_2511)block;
                for (int i = 0; i < 4; ++i) {
                    class_2350 direction = class_2350.method_10139((int)i);
                    class_2680 sideState = world.method_8320(pos.method_10093(direction));
                    if (!sideState.method_27852((class_2248)gourd.method_10680())) continue;
                    try {
                        if (!((class_2350)sideState.method_11654((class_2769)class_2195.field_9873)).equals((Object)direction.method_10153())) continue;
                        return true;
                    }
                    catch (IllegalArgumentException exception) {
                        UMULittleMaid.LOGGER.info(ModEntities.MARKER, "\u4e0d\u660e\u306a\u539f\u56e0\u3067Block\u304b\u3089FACING\u3092\u5f97\u3089\u308c\u306a\u304b\u3063\u305f\u3088\uff01");
                    }
                }
                return false;
            }
            return true;
        }
        return false;
    }
}

