/*
 * Decompiled with CFR 0.152.
 */
package io.github.zemelua.umu_little_maid.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.zemelua.umu_little_maid.UMULittleMaid;
import io.github.zemelua.umu_little_maid.c_component.Components;
import io.github.zemelua.umu_little_maid.c_component.instruction.IInstructionComponent;
import io.github.zemelua.umu_little_maid.client.renderer.gui.overlay.Overlay;
import io.github.zemelua.umu_little_maid.client.renderer.gui.overlay.OverlayRenderer;
import io.github.zemelua.umu_little_maid.entity.maid.LittleMaidEntity;
import io.github.zemelua.umu_little_maid.util.ImmutableText;
import io.github.zemelua.umu_little_maid.util.InstructionUtils;
import io.github.zemelua.umu_little_maid.util.ModGUIUtils;
import io.github.zemelua.umu_little_maid.util.ModMathUtils;
import io.github.zemelua.umu_little_maid.util.ModUtils;
import io.github.zemelua.umu_little_maid.util.ModWorldUtils;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2742;
import net.minecraft.class_2745;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4208;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_638;
import net.minecraft.class_757;
import org.joml.Matrix4f;

public final class InstructionRenderer {
    public static final class_2960 CROSSHAIR = UMULittleMaid.identifier("textures/gui/hud/instruction_crosshair.png");
    public static final class_2960 HEADDRESS = UMULittleMaid.identifier("textures/instruction/site/headdress.png");
    public static final class_2960 ICON_HOME = UMULittleMaid.identifier("textures/gui/home_icon.png");
    public static final class_2960 ICON_ANCHOR = UMULittleMaid.identifier("textures/gui/anchor_icon.png");
    public static final class_2960 ICON_DELIVERY_BOX = UMULittleMaid.identifier("textures/gui/delivery_box_icon.png");

    public static void renderTargetOverlay(class_4597 verticesProvider, class_4587 matrices, class_4184 camera, class_1937 world, class_2338 pos, class_2680 state, LittleMaidEntity maid) {
        if (maid.isAnchor(world, pos)) {
            OverlayRenderer.OVERLAY_ANCHOR.render(verticesProvider, matrices, camera, pos, null);
        }
        if (maid.isAnyRemovableSite(world, pos)) {
            InstructionRenderer.renderOverlay(verticesProvider, matrices, camera, OverlayRenderer.OVERLAY_DELETABLE, pos, state);
        } else if (maid.isSettableAsAnySite(world, pos)) {
            InstructionRenderer.renderOverlay(verticesProvider, matrices, camera, OverlayRenderer.AVAILABLE, pos, state);
        } else if (!maid.isAnchor(world, pos)) {
            InstructionRenderer.renderOverlay(verticesProvider, matrices, camera, OverlayRenderer.OVERLAY_UNAVAILABLE, pos, state);
        }
    }

    public static void renderSitesOverlay(class_310 client, WorldRenderContext context) {
        class_1657 player = (class_1657)Objects.requireNonNull(class_310.method_1551().field_1724);
        IInstructionComponent instructionComponent = (IInstructionComponent)player.getComponent(Components.INSTRUCTION);
        Optional<LittleMaidEntity> maid = instructionComponent.getTarget();
        class_638 world = context.world();
        class_4587 matrices = context.matrixStack();
        class_4184 camera = context.camera();
        class_4597 verticesProvider = Objects.requireNonNull(context.consumers());
        maid.flatMap(LittleMaidEntity::getHome).filter(h -> InstructionRenderer.shouldRenderSiteOverlay(client, (class_1937)world, player, h)).ifPresent(h -> {
            class_2338 homePos = h.method_19446();
            InstructionRenderer.renderOverlay(verticesProvider, matrices, camera, OverlayRenderer.OVERLAY_HOME, homePos, world.method_8320(homePos));
        });
        maid.flatMap(LittleMaidEntity::getAnchor).filter(h -> InstructionRenderer.shouldRenderAnchorOverlay(client, (class_1937)world, player, h)).ifPresent(h -> {
            class_2338 anchorPos = h.method_19446();
            OverlayRenderer.OVERLAY_ANCHOR.render(verticesProvider, matrices, camera, anchorPos, null);
        });
        maid.ifPresent(m -> m.getDeliveryBoxes().stream().filter(b -> InstructionRenderer.shouldRenderSiteOverlay(client, (class_1937)world, player, b)).forEach(b -> {
            class_2338 boxPos = b.method_19446();
            InstructionRenderer.renderOverlay(verticesProvider, matrices, camera, OverlayRenderer.OVERLAY_DELIVERY_BOX, boxPos, world.method_8320(boxPos));
        }));
    }

    private static boolean shouldRenderSiteOverlay(class_310 client, class_1937 world, class_1657 player, class_4208 pos) {
        Optional<class_239> target = Optional.ofNullable(client.field_1765);
        if (target.filter(h -> h.method_17783() == class_239.class_240.field_1332).filter(h -> ModUtils.isSameObject(world, ((class_3965)h).method_17777(), pos)).isPresent()) {
            return false;
        }
        int renderDistance = (Integer)class_310.method_1551().field_1690.method_42503().method_41753() * 16;
        return world.method_27983().equals(pos.method_19442()) && pos.method_19446().method_19769((class_2374)player.method_19538(), (double)renderDistance);
    }

    private static boolean shouldRenderAnchorOverlay(class_310 client, class_1937 world, class_1657 player, class_4208 pos) {
        Optional<class_239> target = Optional.ofNullable(client.field_1765);
        if (target.filter(h -> h.method_17783() == class_239.class_240.field_1332).filter(h -> pos.equals((Object)class_4208.method_19443((class_5321)world.method_27983(), (class_2338)((class_3965)h).method_17777()))).isPresent()) {
            return false;
        }
        int renderDistance = (Integer)class_310.method_1551().field_1690.method_42503().method_41753() * 16;
        return world.method_27983().equals(pos.method_19442()) && pos.method_19446().method_19769((class_2374)player.method_19538(), (double)renderDistance);
    }

    private static void renderOverlay(class_4597 verticesProvider, class_4587 matrices, class_4184 camera, Overlay overlay, class_2338 pos, class_2680 state) {
        if (state.method_28498((class_2769)class_2741.field_12483)) {
            class_2350 connectTo = switch ((class_2742)state.method_11654((class_2769)class_2741.field_12483)) {
                default -> throw new IncompatibleClassChangeError();
                case class_2742.field_12560 -> ((class_2350)state.method_11654((class_2769)class_2741.field_12481)).method_10153();
                case class_2742.field_12557 -> (class_2350)state.method_11654((class_2769)class_2741.field_12481);
            };
            InstructionRenderer.renderDoubleOverlay(overlay, verticesProvider, matrices, camera, pos, connectTo);
        } else if (state.method_28498((class_2769)class_2741.field_12533)) {
            class_2350 connectTo = switch ((class_2756)state.method_11654((class_2769)class_2741.field_12533)) {
                default -> throw new IncompatibleClassChangeError();
                case class_2756.field_12609 -> class_2350.field_11033;
                case class_2756.field_12607 -> class_2350.field_11036;
            };
            InstructionRenderer.renderDoubleOverlay(overlay, verticesProvider, matrices, camera, pos, connectTo);
        } else if (state.method_28498((class_2769)class_2741.field_12481) && state.method_28498((class_2769)class_2741.field_12506)) {
            class_2350 connectTo;
            switch ((class_2745)state.method_11654((class_2769)class_2741.field_12506)) {
                case field_12574: {
                    class_2350 class_23502 = ((class_2350)state.method_11654((class_2769)class_2741.field_12481)).method_10170();
                    break;
                }
                case field_12571: {
                    class_2350 class_23502 = ((class_2350)state.method_11654((class_2769)class_2741.field_12481)).method_10160();
                    break;
                }
                default: {
                    class_2350 class_23502 = connectTo = null;
                }
            }
            if (connectTo == null) {
                overlay.render(verticesProvider, matrices, camera, pos, null);
            } else {
                InstructionRenderer.renderDoubleOverlay(overlay, verticesProvider, matrices, camera, pos, connectTo);
            }
        } else {
            overlay.render(verticesProvider, matrices, camera, pos, null);
        }
    }

    public static void renderSiteTooltip(class_332 context, class_310 client, class_327 textRenderer, class_1937 world, class_4184 camera, int screenW, int screenH) {
        class_1657 player = (class_1657)Objects.requireNonNull(class_310.method_1551().field_1724);
        IInstructionComponent instructionComponent = (IInstructionComponent)player.getComponent(Components.INSTRUCTION);
        Optional<LittleMaidEntity> maid = instructionComponent.getTarget();
        if (maid.isEmpty()) {
            return;
        }
        double length = (Integer)class_310.method_1551().field_1690.method_42503().method_41753() * 16;
        class_243 cameraPos = camera.method_19326();
        class_243 cameraRot = ModMathUtils.rotationToVector(camera.method_19329(), camera.method_19330());
        class_243 endPos = cameraPos.method_1019(cameraRot.method_1021(length));
        class_1297 cameraEntity = camera.method_19331();
        class_3959 raycast = new class_3959(cameraPos, endPos, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, cameraEntity);
        int x = Math.round((float)screenW / 2.0f) + 12;
        int y = Math.round((float)screenH / 2.0f) + 7;
        int width = 200;
        class_3965 hitSite = ModWorldUtils.raycast((class_1922)world, raycast, p -> ((LittleMaidEntity)maid.get()).isAnySite(world, (class_2338)p));
        class_2338 hitPos = hitSite.method_17777();
        if (maid.get().isHome(world, hitPos)) {
            class_5250 title = InstructionUtils.homeMessage(maid.get()).method_27694(s -> s.method_10982(Boolean.valueOf(true)));
            ImmutableText content = InstructionUtils.HOME_TOOLTIP;
            ModGUIUtils.drawULMTooltip(context, client, textRenderer, x, y, ICON_HOME, (class_2561)title, content, width);
        } else if (maid.get().isDeliveryBox(world, hitPos)) {
            class_5250 title = InstructionUtils.deliveryBoxMessage(maid.get()).method_27694(s -> s.method_10982(Boolean.valueOf(true)));
            ImmutableText content = InstructionUtils.DELIVERY_BOX_TOOLTIP;
            ModGUIUtils.drawULMTooltip(context, client, textRenderer, x, y, ICON_DELIVERY_BOX, (class_2561)title, content, width);
        } else if (maid.get().isAnchor(world, hitPos)) {
            class_5250 title = InstructionUtils.anchorMessage(maid.get()).method_27694(s -> s.method_10982(Boolean.valueOf(true)));
            ImmutableText content = InstructionUtils.ANCHOR_TOOLTIP;
            ModGUIUtils.drawULMTooltip(context, client, textRenderer, x, y, ICON_ANCHOR, (class_2561)title, content, width);
        }
    }

    private static void renderDoubleOverlay(Overlay overlay, class_4597 verticesProvider, class_4587 matrices, class_4184 camera, class_2338 pos, class_2350 connectTo) {
        overlay.render(verticesProvider, matrices, camera, pos, connectTo);
        overlay.render(verticesProvider, matrices, camera, pos.method_10093(connectTo), connectTo.method_10153());
    }

    public static void renderCrossHair(class_4587 matrices, int screenW, int screenH) {
        RenderSystem.setShaderTexture((int)0, (class_2960)CROSSHAIR);
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        Matrix4f matrix = matrices.method_23760().method_23761();
        int textureW = 16;
        int textureH = 16;
        float x0 = (float)(screenW - textureW) / 2.0f;
        float y0 = (float)(screenH - textureH) / 2.0f;
        float x1 = x0 + (float)textureW;
        float y1 = y0 + (float)textureH;
        float u0 = 0.0f;
        float v0 = 0.0f;
        float u1 = 1.0f;
        float v1 = 1.0f;
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.ONE_MINUS_DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix, x0, y1, 0.0f).method_22913(u0, v1).method_1344();
        bufferBuilder.method_22918(matrix, x1, y1, 0.0f).method_22913(u1, v1).method_1344();
        bufferBuilder.method_22918(matrix, x1, y0, 0.0f).method_22913(u1, v0).method_1344();
        bufferBuilder.method_22918(matrix, x0, y0, 0.0f).method_22913(u0, v0).method_1344();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
    }

    public static void renderGuideMessage(class_332 context, class_327 textRenderer, int screenW, int screenH, class_1937 world, class_239 target, IInstructionComponent component) {
        int padding = 20;
        float centerX = (float)screenW / 2.0f;
        float centerY = (float)screenH / 2.0f;
        Objects.requireNonNull(textRenderer);
        int y = Math.round(centerY - 9.0f / 2.0f);
        class_5250 onLeftClick = InstructionUtils.guideCancelMessage();
        int leftW = textRenderer.method_27525((class_5348)onLeftClick);
        int leftX = Math.round(centerX - (float)padding - (float)leftW);
        ModUtils.GUIs.drawTextWithBackground(context, textRenderer, (class_2561)onLeftClick, leftX, y, 0xFFFFFF);
        int rightX = Math.round(centerX + (float)padding);
        if (target.method_17783() == class_239.class_240.field_1332) {
            class_2338 targetPos = ((class_3965)target).method_17777();
            Optional<LittleMaidEntity> maid = component.getTarget();
            if (maid.isPresent() && world.method_8621().method_11952(targetPos)) {
                if (maid.get().isAnyRemovableSite(world, targetPos)) {
                    ModUtils.GUIs.drawTextWithBackground(context, textRenderer, (class_2561)InstructionUtils.guideRemoveMessage(), rightX, y, 0xFFFFFF);
                } else if (maid.get().isSettableAsAnySite(world, targetPos)) {
                    ModUtils.GUIs.drawTextWithBackground(context, textRenderer, (class_2561)InstructionUtils.guideDecideMessage(), rightX, y, 0xFFFFFF);
                }
            }
        }
    }
}

