/*
 * Decompiled with CFR 0.152.
 */
package io.github.zemelua.umu_little_maid.client;

import io.github.zemelua.umu_little_maid.c_component.headpatting.IHeadpattingComponent;
import io.github.zemelua.umu_little_maid.c_component.instruction.IInstructionComponent;
import io.github.zemelua.umu_little_maid.client.renderer.InstructionRenderer;
import io.github.zemelua.umu_little_maid.entity.maid.LittleMaidEntity;
import io.github.zemelua.umu_little_maid.util.HeadpatManager;
import io.github.zemelua.umu_little_maid.util.InstructionUtils;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1041;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_638;

@Environment(value=EnvType.CLIENT)
public final class ClientCallbacks {
    static void onStartTick(class_310 client) {
        Optional<IHeadpattingComponent> component = HeadpatManager.getHeadpattingComponent(client);
        component.ifPresent(c -> HeadpatManager.clientTick(client, c));
    }

    static boolean onRenderBlockOutline(WorldRenderContext worldRenderContext, WorldRenderContext.BlockOutlineContext blockOutlineContext) {
        class_310 client = class_310.method_1551();
        Optional<LittleMaidEntity> maid = InstructionUtils.getMaid(client);
        if (maid.isPresent()) {
            class_4597 verticesProvider = Objects.requireNonNull(worldRenderContext.consumers());
            class_4587 matrices = worldRenderContext.matrixStack();
            class_4184 camera = worldRenderContext.camera();
            class_638 world = worldRenderContext.world();
            class_2338 pos = blockOutlineContext.blockPos();
            class_2680 state = blockOutlineContext.blockState();
            InstructionRenderer.renderTargetOverlay(verticesProvider, matrices, camera, (class_1937)world, pos, state, maid.get());
            return false;
        }
        return true;
    }

    static void beforeRenderDebug(WorldRenderContext context) {
        class_310 client = class_310.method_1551();
        InstructionRenderer.renderSitesOverlay(client, context);
    }

    static void onRenderHUD(class_332 context, float tickDelta) {
        class_310 client = class_310.method_1551();
        class_327 textRenderer = client.field_1772;
        class_1041 window = client.method_22683();
        int screenW = window.method_4486();
        int screenH = window.method_4502();
        class_638 world = client.field_1687;
        class_4184 camera = client.field_1773.method_19418();
        class_239 target = Objects.requireNonNull(client.field_1765);
        Optional<IInstructionComponent> component = InstructionUtils.getComponent(client);
        if (component.isPresent() && component.get().isInstructing()) {
            InstructionRenderer.renderGuideMessage(context, textRenderer, screenW, screenH, (class_1937)world, target, component.get());
            InstructionRenderer.renderSiteTooltip(context, client, textRenderer, (class_1937)world, camera, screenW, screenH);
        }
    }
}

