/*
 * Decompiled with CFR 0.152.
 */
package io.github.zemelua.umu_little_maid.c_component.instruction;

import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import io.github.zemelua.umu_little_maid.c_component.Components;
import io.github.zemelua.umu_little_maid.c_component.instruction.IInstructionComponent;
import io.github.zemelua.umu_little_maid.data.tag.ModTags;
import io.github.zemelua.umu_little_maid.entity.maid.LittleMaidEntity;
import io.github.zemelua.umu_little_maid.util.InstructionUtils;
import io.github.zemelua.umu_little_maid.util.ModUtils;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstructionComponent
implements IInstructionComponent,
AutoSyncedComponent {
    private final class_1657 owner;
    @Nullable
    private LittleMaidEntity target;

    public InstructionComponent(class_1657 owner) {
        this.owner = owner;
    }

    @Override
    public void startInstruction(LittleMaidEntity target) {
        this.target = target;
        Components.INSTRUCTION.sync((Object)this.owner);
    }

    @Override
    public class_1269 tryInstruction(class_1937 world, class_3965 target) {
        Objects.requireNonNull(this.target);
        class_2338 pos = target.method_17777();
        class_2680 state = world.method_8320(pos);
        Optional<class_4208> home = this.target.getHome();
        Collection<class_4208> boxes = this.target.getDeliveryBoxes();
        Optional<class_4208> sameBox = boxes.stream().filter(b -> ModUtils.isSameObject(world, pos, b)).findAny();
        if (home.isPresent() && ModUtils.isSameObject(world, pos, home.get())) {
            if (!world.method_8608()) {
                this.target.removeHome();
                this.owner.method_43496((class_2561)InstructionUtils.removeHomeMessage(state, pos, this.target));
                this.finishInstruction();
            }
            return class_1269.method_29236((boolean)world.method_8608());
        }
        if (sameBox.isPresent()) {
            if (!world.method_8608()) {
                this.target.removeDeliveryBox(sameBox.get());
                this.owner.method_43496((class_2561)InstructionUtils.removeDeliveryBoxMessage(state, pos, this.target));
                this.finishInstruction();
            }
            return class_1269.method_29236((boolean)world.method_8608());
        }
        if (this.target.isSettableAsHome(world, pos)) {
            if (!world.method_8608()) {
                this.target.setHome(class_4208.method_19443((class_5321)world.method_27983(), (class_2338)pos));
                if (home.isPresent()) {
                    this.owner.method_43496((class_2561)InstructionUtils.renewHomeMessage(state, pos, this.target));
                } else {
                    this.owner.method_43496((class_2561)InstructionUtils.setHomeMessage(state, pos, this.target));
                }
                this.finishInstruction();
            }
            return class_1269.method_29236((boolean)world.method_8608());
        }
        if (this.target.isSettableAsDeliveryBox(world, pos)) {
            if (!world.method_8608()) {
                this.target.addDeliveryBox(class_4208.method_19443((class_5321)world.method_27983(), (class_2338)pos));
                this.owner.method_43496((class_2561)InstructionUtils.addDeliveryBoxMessage(state, pos, this.target));
                this.finishInstruction();
            }
            return class_1269.method_29236((boolean)world.method_8608());
        }
        if (this.target.isAnchor(world, pos)) {
            if (world.method_8608()) {
                this.owner.method_7353((class_2561)InstructionUtils.PASS_ON_ANCHOR_MESSAGE, true);
            }
            return class_1269.field_5814;
        }
        if (world.method_8608()) {
            this.owner.method_7353((class_2561)InstructionUtils.PASS_ON_BLOCK_MESSAGE, true);
        }
        return class_1269.field_5814;
    }

    @Override
    public class_1269 tryInstruction(class_1937 world, class_3966 target) {
        if (world.method_8608()) {
            this.owner.method_7353((class_2561)InstructionUtils.PASS_ON_ENTITY_MESSAGE, true);
        }
        return class_1269.field_5814;
    }

    @Override
    public void finishInstruction() {
        this.target = null;
        Components.INSTRUCTION.sync((Object)this.owner);
    }

    @Override
    public void cancelInstruction() {
        this.target = null;
        Components.INSTRUCTION.sync((Object)this.owner);
        if (!this.owner.method_37908().method_8608()) {
            this.owner.method_7353((class_2561)InstructionUtils.CANCEL, true);
        }
    }

    @Override
    public Optional<LittleMaidEntity> getTarget() {
        return Optional.ofNullable(this.target);
    }

    @Deprecated
    public void serverTick() {
        if (this.isInstructing()) {
            class_1799 mainHandStack = this.owner.method_6047();
            class_1799 offHandStack = this.owner.method_6079();
            if (!mainHandStack.method_31573(ModTags.ITEM_MAID_INSTRUCTORS) && !offHandStack.method_31573(ModTags.ITEM_MAID_INSTRUCTORS)) {
                this.cancelInstruction();
            }
        }
    }

    public void writeSyncPacket(class_2540 packet, class_3222 recipient) {
        packet.method_37435(Optional.ofNullable(this.target).map(class_1297::method_5628), class_2540::writeInt);
    }

    public void applySyncPacket(class_2540 packet) {
        this.target = packet.method_37436(class_2540::readInt).map(i -> this.owner.method_37908().method_8469(i.intValue())).filter(e -> e instanceof LittleMaidEntity).orElse(null);
    }

    public void readFromNbt(@NotNull class_2487 nbt) {
    }

    public void writeToNbt(@NotNull class_2487 nbt) {
    }
}

