/*
 * Decompiled with CFR 0.152.
 */
package me.ImJoshh.elytra_physics.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.Map;
import me.ImJoshh.elytra_physics.ElytraPhysicsClientMod;
import me.ImJoshh.elytra_physics.config.ModConfig;
import net.fabricmc.loader.api.FabricLoader;

public class ElytraPhysicsConfigManager {
    private static ModConfig loadedConfig;
    private static ModConfig defaultConfig;

    public static void init() {
        Path configDir = FabricLoader.getInstance().getConfigDir();
        File configFile = configDir.resolve("elytra-physics-config.json").toFile();
        Map<String, Object> defaultConfigJson = ElytraPhysicsConfigManager.getDefaultConfigJSON();
        if (defaultConfigJson == null) {
            ElytraPhysicsClientMod.LOGGER.error("Default config file could not be found in mod Jar");
            return;
        }
        defaultConfig = ModConfig.fromJSON(defaultConfigJson);
        if (!configFile.exists()) {
            loadedConfig = defaultConfig.copy(configFile);
            loadedConfig.saveConfig();
        } else {
            loadedConfig = ModConfig.fromFile(configFile);
        }
    }

    public static Object getConfigValue(String key) {
        Object fromLoaded = loadedConfig.get(key);
        if (fromLoaded != null) {
            return fromLoaded;
        }
        Object fromDefault = defaultConfig.get(key);
        if (fromDefault != null) {
            loadedConfig.add(key, fromDefault);
            loadedConfig.saveConfig();
            return fromDefault;
        }
        return null;
    }

    static Map<String, Object> getDefaultConfigJSON() {
        try {
            String line;
            InputStream stream = ElytraPhysicsClientMod.class.getClassLoader().getResourceAsStream("defaultConfig.json");
            if (stream == null) {
                return null;
            }
            InputStreamReader reader = new InputStreamReader(stream);
            BufferedReader bufferedReader = new BufferedReader(reader);
            StringBuilder builder = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                builder.append(line);
            }
            bufferedReader.close();
            reader.close();
            stream.close();
            Gson gson = new GsonBuilder().create();
            return (Map)gson.fromJson(builder.toString(), Map.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

